/*
 * Decompiled with CFR 0.152.
 */
package com.excel.poi.excel;

import com.excel.poi.common.DateFormatUtil;
import com.excel.poi.common.RegexUtil;
import com.excel.poi.common.StringUtil;
import com.excel.poi.entity.ErrorEntity;
import com.excel.poi.entity.ExcelEntity;
import com.excel.poi.entity.ExcelPropertyEntity;
import com.excel.poi.exception.AllEmptyRowException;
import com.excel.poi.exception.ExcelBootException;
import com.excel.poi.function.ImportFunction;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExcelReader
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(ExcelReader.class);
    private Integer currentSheetIndex = -1;
    private Integer currentRowIndex = 0;
    private Integer excelCurrentCellIndex = 0;
    private ExcelCellType cellFormatStr;
    private String currentCellLocation;
    private String previousCellLocation;
    private String endCellLocation;
    private SharedStringsTable mSharedStringsTable;
    private String currentCellValue;
    private Boolean isNeedSharedStrings = false;
    private ExcelEntity excelMapping;
    private ImportFunction importFunction;
    private Class excelClass;
    private List<String> cellsOnRow = new ArrayList<String>();
    private Integer beginReadRowIndex;
    private Integer dataCurrentCellIndex = -1;

    public ExcelReader(Class entityClass, ExcelEntity excelMapping, ImportFunction importFunction) {
        this(entityClass, excelMapping, 1, importFunction);
    }

    public ExcelReader(Class entityClass, ExcelEntity excelMapping, Integer beginReadRowIndex, ImportFunction importFunction) {
        this.excelClass = entityClass;
        this.excelMapping = excelMapping;
        this.beginReadRowIndex = beginReadRowIndex;
        this.importFunction = importFunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(InputStream in) throws IOException, OpenXML4JException, SAXException {
        OPCPackage opcPackage = null;
        InputStream sheet = null;
        try {
            opcPackage = OPCPackage.open((InputStream)in);
            XSSFReader xssfReader = new XSSFReader(opcPackage);
            XMLReader parser = this.fetchSheetParser(xssfReader.getSharedStringsTable());
            Iterator sheets = xssfReader.getSheetsData();
            while (sheets.hasNext()) {
                this.currentRowIndex = 0;
                Integer n = this.currentSheetIndex;
                Integer n2 = this.currentSheetIndex = Integer.valueOf(this.currentSheetIndex + 1);
                try {
                    sheet = (InputStream)sheets.next();
                    InputSource sheetSource = new InputSource(sheet);
                    try {
                        log.info("\u5f00\u59cb\u8bfb\u53d6\u7b2c{}\u4e2aSheet!", (Object)(this.currentSheetIndex + 1));
                        parser.parse(sheetSource);
                    }
                    catch (AllEmptyRowException e) {
                        log.warn(e.getMessage());
                    }
                    catch (Exception e) {
                        throw new ExcelBootException(e, "\u7b2c{}\u4e2aSheet,\u7b2c{}\u884c,\u7b2c{}\u5217,\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38! ", this.currentSheetIndex + 1, this.currentRowIndex + 1, this.dataCurrentCellIndex + 1);
                    }
                }
                finally {
                    if (sheet == null) continue;
                    sheet.close();
                }
            }
        }
        finally {
            if (opcPackage != null) {
                opcPackage.close();
            }
        }
    }

    private XMLReader fetchSheetParser(SharedStringsTable sst) throws SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        this.mSharedStringsTable = sst;
        parser.setContentHandler(this);
        return parser;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) {
        if ("c".equals(name)) {
            String xyzLocation = attributes.getValue("r");
            this.previousCellLocation = null == this.previousCellLocation ? xyzLocation : this.currentCellLocation;
            this.currentCellLocation = xyzLocation;
            String cellType = attributes.getValue("t");
            this.isNeedSharedStrings = null != cellType && cellType.equals("s");
            this.setCellType(cellType);
        }
        this.currentCellValue = "";
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        this.currentCellValue = this.currentCellValue.concat(new String(chars, start, length));
    }

    @Override
    public void endElement(String uri, String localName, String name) {
        if ("c".equals(name)) {
            Integer n;
            Integer n2;
            if (this.isNeedSharedStrings.booleanValue() && !StringUtil.isBlank(this.currentCellValue) && StringUtil.isNumeric(this.currentCellValue)) {
                int index = Integer.parseInt(this.currentCellValue);
                this.currentCellValue = new XSSFRichTextString(this.mSharedStringsTable.getEntryAt(index)).toString();
            }
            if (!this.currentCellLocation.equals(this.previousCellLocation) && this.currentRowIndex != 0) {
                for (int i = 0; i < this.countNullCell(this.currentCellLocation, this.previousCellLocation); ++i) {
                    this.cellsOnRow.add(this.excelCurrentCellIndex, "");
                    n2 = this.excelCurrentCellIndex;
                    n = this.excelCurrentCellIndex = Integer.valueOf(this.excelCurrentCellIndex + 1);
                }
            }
            if (this.currentRowIndex != 0 || !"".equals(this.currentCellValue.trim())) {
                String value = this.getCellValue(this.currentCellValue.trim());
                this.cellsOnRow.add(this.excelCurrentCellIndex, value);
                n2 = this.excelCurrentCellIndex;
                n = this.excelCurrentCellIndex = Integer.valueOf(this.excelCurrentCellIndex + 1);
            }
        } else if ("row".equals(name)) {
            Integer n;
            if (this.currentRowIndex == 0) {
                this.endCellLocation = this.currentCellLocation;
                int propertySize = this.excelMapping.getPropertyList().size();
                if (this.cellsOnRow.size() != propertySize) {
                    throw new ExcelBootException("Excel\u6709\u6548\u5217\u6570\u4e0d\u7b49\u4e8e\u6807\u6ce8\u6ce8\u89e3\u7684\u5c5e\u6027\u6570\u91cf!Excel\u5217\u6570:{},\u6807\u6ce8\u6ce8\u89e3\u7684\u5c5e\u6027\u6570\u91cf:{}", this.cellsOnRow.size(), propertySize);
                }
            }
            if (null != this.endCellLocation) {
                for (int i = 0; i <= this.countNullCell(this.endCellLocation, this.currentCellLocation); ++i) {
                    this.cellsOnRow.add(this.excelCurrentCellIndex, "");
                    n = this.excelCurrentCellIndex;
                    Integer n3 = this.excelCurrentCellIndex = Integer.valueOf(this.excelCurrentCellIndex + 1);
                }
            }
            try {
                this.assembleData();
            }
            catch (AllEmptyRowException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ExcelBootException(e);
            }
            this.cellsOnRow.clear();
            Integer n4 = this.currentRowIndex;
            n = this.currentRowIndex = Integer.valueOf(this.currentRowIndex + 1);
            this.dataCurrentCellIndex = -1;
            this.excelCurrentCellIndex = 0;
            this.previousCellLocation = null;
            this.currentCellLocation = null;
        }
    }

    private void setCellType(String cellType) {
        if ("inlineStr".equals(cellType)) {
            this.cellFormatStr = ExcelCellType.INLINESTR;
        } else if ("s".equals(cellType) || cellType == null) {
            this.cellFormatStr = ExcelCellType.STRING;
        } else {
            throw new ExcelBootException("Excel\u5355\u5143\u683c\u683c\u5f0f\u672a\u8bbe\u7f6e\u6210\u6587\u672c\u6216\u8005\u5e38\u89c4!\u5355\u5143\u683c\u683c\u5f0f:{}", cellType);
        }
    }

    private String getCellValue(String value) {
        switch (this.cellFormatStr) {
            case INLINESTR: {
                return new XSSFRichTextString(value).toString();
            }
        }
        return String.valueOf(value);
    }

    private void assembleData() throws Exception {
        if (this.currentRowIndex >= this.beginReadRowIndex) {
            List<ExcelPropertyEntity> propertyList = this.excelMapping.getPropertyList();
            for (int i = 0; i < propertyList.size() - this.cellsOnRow.size(); ++i) {
                this.cellsOnRow.add(i, "");
            }
            if (this.isAllEmptyRowData()) {
                throw new AllEmptyRowException("\u7b2c{}\u884c\u4e3a\u7a7a\u884c,\u7b2c{}\u4e2aSheet\u5bfc\u5165\u7ed3\u675f!", this.currentRowIndex + 1, this.currentSheetIndex + 1);
            }
            Object entity = this.excelClass.newInstance();
            ErrorEntity errorEntity = ErrorEntity.builder().build();
            for (int i = 0; i < propertyList.size(); ++i) {
                this.dataCurrentCellIndex = i;
                Object cellValue = this.cellsOnRow.get(i);
                ExcelPropertyEntity property = propertyList.get(i);
                errorEntity = this.checkCellValue(i, property, cellValue);
                if (errorEntity.getErrorMessage() != null) break;
                if ((cellValue = this.convertCellValue(property, cellValue)) == null) continue;
                Field field = property.getFieldEntity();
                field.set(entity, cellValue);
            }
            if (errorEntity.getErrorMessage() == null) {
                this.importFunction.onProcess(this.currentSheetIndex + 1, this.currentRowIndex + 1, entity);
            } else {
                this.importFunction.onError(errorEntity);
            }
        }
    }

    private boolean isAllEmptyRowData() {
        int emptyCellCount = 0;
        for (String cellData : this.cellsOnRow) {
            if (!StringUtil.isBlank(cellData)) continue;
            ++emptyCellCount;
        }
        return emptyCellCount == this.cellsOnRow.size();
    }

    private Object convertCellValue(ExcelPropertyEntity mappingProperty, Object cellValue) throws ParseException, ExecutionException {
        Class<?> filedClazz = mappingProperty.getFieldEntity().getType();
        if (filedClazz == Date.class) {
            cellValue = !StringUtil.isBlank(cellValue) ? DateFormatUtil.parse(mappingProperty.getDateFormat(), cellValue.toString()) : null;
        } else if (filedClazz == Short.class || filedClazz == Short.TYPE) {
            cellValue = Short.valueOf(StringUtil.convertNullTOZERO(cellValue));
        } else if (filedClazz == Integer.class || filedClazz == Integer.TYPE) {
            cellValue = Integer.valueOf(StringUtil.convertNullTOZERO(cellValue));
        } else if (filedClazz == Double.class || filedClazz == Double.TYPE) {
            cellValue = Double.valueOf(StringUtil.convertNullTOZERO(cellValue));
        } else if (filedClazz == Long.class || filedClazz == Long.TYPE) {
            cellValue = Long.valueOf(StringUtil.convertNullTOZERO(cellValue));
        } else if (filedClazz == Float.class || filedClazz == Float.TYPE) {
            cellValue = Float.valueOf(StringUtil.convertNullTOZERO(cellValue));
        } else if (filedClazz == BigDecimal.class) {
            cellValue = mappingProperty.getScale() == -1 ? new BigDecimal(StringUtil.convertNullTOZERO(cellValue)) : new BigDecimal(StringUtil.convertNullTOZERO(cellValue)).setScale((int)mappingProperty.getScale(), mappingProperty.getRoundingMode());
        } else if (filedClazz != String.class) {
            throw new ExcelBootException("\u4e0d\u652f\u6301\u7684\u5c5e\u6027\u7c7b\u578b:{},\u5bfc\u5165\u5931\u8d25!", filedClazz);
        }
        return cellValue;
    }

    private ErrorEntity checkCellValue(Integer cellIndex, ExcelPropertyEntity mappingProperty, Object cellValue) throws Exception {
        boolean matches;
        Boolean required = mappingProperty.getRequired();
        if (null != required && required.booleanValue() && (null == cellValue || StringUtil.isBlank(cellValue))) {
            String validErrorMessage = String.format("\u7b2c[%s]\u4e2aSheet,\u7b2c[%s]\u884c,\u7b2c[%s]\u5217\u5fc5\u586b\u5355\u5143\u683c\u4e3a\u7a7a!", this.currentSheetIndex + 1, this.currentRowIndex + 1, cellIndex + 1);
            return this.buildErrorMsg(cellIndex, cellValue, validErrorMessage);
        }
        String regex = mappingProperty.getRegex();
        if (!(StringUtil.isBlank(cellValue) || StringUtil.isBlank(regex) || (matches = RegexUtil.isMatch(regex, cellValue.toString()).booleanValue()))) {
            String regularExpMessage = mappingProperty.getRegexMessage();
            String validErrorMessage = String.format("\u7b2c[%s]\u4e2aSheet,\u7b2c[%s]\u884c,\u7b2c[%s]\u5217,\u5355\u5143\u683c\u503c:[%s],\u6b63\u5219\u8868\u8fbe\u5f0f[%s]\u6821\u9a8c\u5931\u8d25!", this.currentSheetIndex + 1, this.currentRowIndex + 1, cellIndex + 1, cellValue, regularExpMessage);
            return this.buildErrorMsg(cellIndex, cellValue, validErrorMessage);
        }
        return this.buildErrorMsg(cellIndex, cellValue, null);
    }

    private ErrorEntity buildErrorMsg(Integer cellIndex, Object cellValue, String validErrorMessage) {
        return ErrorEntity.builder().sheetIndex(this.currentSheetIndex + 1).rowIndex(this.currentRowIndex + 1).cellIndex(cellIndex + 1).cellValue(StringUtil.convertNull(cellValue)).errorMessage(validErrorMessage).build();
    }

    public int countNullCell(String refA, String refB) {
        String xfdA = refA.replaceAll("\\d+", "");
        String xfdB = refB.replaceAll("\\d+", "");
        xfdA = this.fillChar(xfdA, 3, '@', true);
        xfdB = this.fillChar(xfdB, 3, '@', true);
        char[] letterA = xfdA.toCharArray();
        char[] letterB = xfdB.toCharArray();
        int res = (letterA[0] - letterB[0]) * 26 * 26 + (letterA[1] - letterB[1]) * 26 + (letterA[2] - letterB[2]);
        return res - 1;
    }

    private String fillChar(String str, int len, char let, boolean isPre) {
        int lenA = str.length();
        if (lenA < len) {
            if (isPre) {
                StringBuilder strBuilder = new StringBuilder(str);
                for (int i = 0; i < len - lenA; ++i) {
                    strBuilder.insert(0, let);
                }
                str = strBuilder.toString();
            } else {
                StringBuilder strBuilder = new StringBuilder(str);
                for (int i = 0; i < len - lenA; ++i) {
                    strBuilder.append(let);
                }
                str = strBuilder.toString();
            }
        }
        return str;
    }

    static enum ExcelCellType {
        INLINESTR,
        STRING,
        NULL;

    }
}

