/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.regex;

import java.util.HashMap;
import org.apache.oro.text.regex.CharStringPointer;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.OpCode;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.Perl5Pattern;

public final class Perl5Compiler
implements PatternCompiler {
    private static final int __WORSTCASE = 0;
    private static final int __NONNULL = 1;
    private static final int __SIMPLE = 2;
    private static final int __SPSTART = 4;
    private static final int __TRYAGAIN = 8;
    private static final char __CASE_INSENSITIVE = '\u0001';
    private static final char __GLOBAL = '\u0002';
    private static final char __KEEP = '\u0004';
    private static final char __MULTILINE = '\b';
    private static final char __SINGLELINE = '\u0010';
    private static final char __EXTENDED = ' ';
    private static final char __READ_ONLY = '\u8000';
    private static final String __HEX_DIGIT = "0123456789abcdef0123456789ABCDEFx";
    private CharStringPointer __input;
    private boolean __sawBackreference;
    private final char[] __modifierFlags = new char[]{'\u0000'};
    private int __numParentheses;
    private int __programSize;
    private int __cost;
    private char[] __program;
    private static final HashMap<String, Character> __hashPOSIX = new HashMap();
    public static final int DEFAULT_MASK = 0;
    public static final int CASE_INSENSITIVE_MASK = 1;
    public static final int MULTILINE_MASK = 8;
    public static final int SINGLELINE_MASK = 16;
    public static final int EXTENDED_MASK = 32;
    public static final int READ_ONLY_MASK = 32768;

    public static final String quotemeta(char[] expression) {
        StringBuffer buffer = new StringBuffer(2 * expression.length);
        for (int ch = 0; ch < expression.length; ++ch) {
            if (!OpCode._isWordCharacter(expression[ch])) {
                buffer.append('\\');
            }
            buffer.append(expression[ch]);
        }
        return buffer.toString();
    }

    public static final String quotemeta(String expression) {
        return Perl5Compiler.quotemeta(expression.toCharArray());
    }

    private static boolean __isSimpleRepetitionOp(char ch) {
        return ch == '*' || ch == '+' || ch == '?';
    }

    private static boolean __isComplexRepetitionOp(char[] ch, int offset) {
        if (offset < ch.length && offset >= 0) {
            return ch[offset] == '*' || ch[offset] == '+' || ch[offset] == '?' || ch[offset] == '{' && Perl5Compiler.__parseRepetition(ch, offset);
        }
        return false;
    }

    private static boolean __parseRepetition(char[] str, int off) {
        int offset = off;
        if (str[offset] != '{') {
            return false;
        }
        if (++offset >= str.length || !Character.isDigit(str[offset])) {
            return false;
        }
        while (offset < str.length && Character.isDigit(str[offset])) {
            ++offset;
        }
        if (offset < str.length && str[offset] == ',') {
            ++offset;
        }
        while (offset < str.length && Character.isDigit(str[offset])) {
            ++offset;
        }
        return offset < str.length && str[offset] == '}';
    }

    private static int __parseHex(char[] str, int off, int ml, int[] scanned) {
        int index;
        int maxLength = ml;
        int val = 0;
        scanned[0] = 0;
        for (int offset = off; offset < str.length && maxLength-- > 0 && (index = __HEX_DIGIT.indexOf(str[offset])) != -1; ++offset) {
            val <<= 4;
            val |= index & 0xF;
            scanned[0] = scanned[0] + 1;
        }
        return val;
    }

    private static int __parseOctal(char[] str, int off, int ml, int[] scanned) {
        int maxLength = ml;
        int val = 0;
        scanned[0] = 0;
        for (int offset = off; offset < str.length && maxLength > 0 && str[offset] >= '0' && str[offset] <= '7'; --maxLength, ++offset) {
            val <<= 3;
            val |= str[offset] - 48;
            scanned[0] = scanned[0] + 1;
        }
        return val;
    }

    private static void __setModifierFlag(char[] flags, char ch) {
        switch (ch) {
            case 'i': {
                flags[0] = (char)(flags[0] | '\u0001');
                return;
            }
            case 'g': {
                flags[0] = (char)(flags[0] | 2);
                return;
            }
            case 'o': {
                flags[0] = (char)(flags[0] | 4);
                return;
            }
            case 'm': {
                flags[0] = (char)(flags[0] | 8);
                return;
            }
            case 's': {
                flags[0] = (char)(flags[0] | 0x10);
                return;
            }
            case 'x': {
                flags[0] = (char)(flags[0] | 0x20);
                return;
            }
        }
    }

    private void __emitCode(char code) {
        if (this.__program != null) {
            this.__program[this.__programSize] = code;
        }
        ++this.__programSize;
    }

    private int __emitNode(char operator) {
        int offset = this.__programSize;
        if (this.__program == null) {
            this.__programSize += 2;
        } else {
            this.__program[this.__programSize++] = operator;
            this.__program[this.__programSize++] = '\u0000';
        }
        return offset;
    }

    private int __emitArgNode(char operator, char arg) {
        int offset = this.__programSize;
        if (this.__program == null) {
            this.__programSize += 3;
        } else {
            this.__program[this.__programSize++] = operator;
            this.__program[this.__programSize++] = '\u0000';
            this.__program[this.__programSize++] = arg;
        }
        return offset;
    }

    private void __programInsertOperator(char operator, int oper) {
        int offset;
        int operand = oper;
        int n = offset = OpCode._opType[operator] == '\n' ? 2 : 0;
        if (this.__program == null) {
            this.__programSize += 2 + offset;
            return;
        }
        int src = this.__programSize;
        this.__programSize += 2 + offset;
        int dest = this.__programSize;
        while (src > operand) {
            this.__program[--dest] = this.__program[--src];
        }
        this.__program[operand++] = operator;
        this.__program[operand++] = '\u0000';
        while (offset-- > 0) {
            this.__program[operand++] = '\u0000';
        }
    }

    private void __programAddTail(int current, int value) {
        int temp;
        if (this.__program == null || current == -1) {
            return;
        }
        int scan = current;
        while ((temp = OpCode._getNext(this.__program, scan)) != -1) {
            scan = temp;
        }
        int offset = this.__program[scan] == '\r' ? scan - value : value - scan;
        this.__program[scan + 1] = (char)offset;
    }

    private void __programAddOperatorTail(int current, int value) {
        if (this.__program == null || current == -1 || OpCode._opType[this.__program[current]] != '\f') {
            return;
        }
        this.__programAddTail(OpCode._getNextOperator(current), value);
    }

    private char __getNextChar() {
        char ret = this.__input._postIncrement();
        while (true) {
            char value;
            if ((value = this.__input._getValue()) == '(' && this.__input._getValueRelative(1) == '?' && this.__input._getValueRelative(2) == '#') {
                while (value != '\uffff' && value != ')') {
                    value = this.__input._increment();
                }
                this.__input._increment();
                continue;
            }
            if ((this.__modifierFlags[0] & 0x20) == 0) break;
            if (Character.isWhitespace(value)) {
                this.__input._increment();
                continue;
            }
            if (value != '#') break;
            while (value != '\uffff' && value != '\n') {
                value = this.__input._increment();
            }
            this.__input._increment();
        }
        return ret;
    }

    private int __parseAlternation(int[] retFlags) throws MalformedPatternException {
        int flags = 0;
        retFlags[0] = 0;
        int offset = this.__emitNode('\f');
        int chain = -1;
        if (this.__input._getOffset() == 0) {
            this.__input._setOffset(-1);
            this.__getNextChar();
        } else {
            this.__input._decrement();
            this.__getNextChar();
        }
        char value = this.__input._getValue();
        while (value != '\uffff' && value != '|' && value != ')') {
            flags &= 0xFFFFFFF7;
            int latest = this.__parseBranch(retFlags);
            if (latest == -1) {
                if ((flags & 8) != 0) {
                    value = this.__input._getValue();
                    continue;
                }
                return -1;
            }
            retFlags[0] = retFlags[0] | flags & 1;
            if (chain == -1) {
                retFlags[0] = retFlags[0] | flags & 4;
            } else {
                ++this.__cost;
                this.__programAddTail(chain, latest);
            }
            chain = latest;
            value = this.__input._getValue();
        }
        if (chain == -1) {
            this.__emitNode('\u000f');
        }
        return offset;
    }

    /*
     * Unable to fully structure code
     */
    private int __parseAtom(int[] retFlags) throws MalformedPatternException {
        flags = new int[]{0};
        retFlags[0] = 0;
        doDefault = false;
        offset = -1;
        block50: while (true) {
            value = this.__input._getValue();
            switch (value) {
                case '^': {
                    this.__getNextChar();
                    if ((this.__modifierFlags[0] & 8) != 0) {
                        offset = this.__emitNode('\u0002');
                        break block50;
                    }
                    if ((this.__modifierFlags[0] & 16) != 0) {
                        offset = this.__emitNode('\u0003');
                        break block50;
                    }
                    offset = this.__emitNode('\u0001');
                    break block50;
                }
                case '$': {
                    this.__getNextChar();
                    if ((this.__modifierFlags[0] & 8) != 0) {
                        offset = this.__emitNode('\u0005');
                        break block50;
                    }
                    if ((this.__modifierFlags[0] & 16) != 0) {
                        offset = this.__emitNode('\u0006');
                        break block50;
                    }
                    offset = this.__emitNode('\u0004');
                    break block50;
                }
                case '.': {
                    this.__getNextChar();
                    offset = (this.__modifierFlags[0] & 16) != 0 ? this.__emitNode('\b') : this.__emitNode('\u0007');
                    ++this.__cost;
                    retFlags[0] = retFlags[0] | 3;
                    break block50;
                }
                case '[': {
                    this.__input._increment();
                    offset = this.__parseUnicodeClass();
                    retFlags[0] = retFlags[0] | 3;
                    break block50;
                }
                case '(': {
                    this.__getNextChar();
                    offset = this.__parseExpression(true, flags);
                    if (offset == -1) {
                        if ((flags[0] & 8) != 0) continue block50;
                        return -1;
                    }
                    retFlags[0] = retFlags[0] | flags[0] & 5;
                    break block50;
                }
                case ')': 
                case '|': {
                    if ((flags[0] & 8) != 0) {
                        retFlags[0] = retFlags[0] | 8;
                        return -1;
                    }
                    throw new MalformedPatternException("Error in expression at " + this.__input._toString(this.__input._getOffset()));
                }
                case '*': 
                case '+': 
                case '?': {
                    throw new MalformedPatternException("?+* follows nothing in expression");
                }
                case '\\': {
                    value = this.__input._increment();
                    switch (value) {
                        case 'A': {
                            offset = this.__emitNode('\u0003');
                            retFlags[0] = retFlags[0] | 2;
                            this.__getNextChar();
                            break block50;
                        }
                        case 'G': {
                            offset = this.__emitNode('\u001e');
                            retFlags[0] = retFlags[0] | 2;
                            this.__getNextChar();
                            break block50;
                        }
                        case 'Z': {
                            offset = this.__emitNode('\u0006');
                            retFlags[0] = retFlags[0] | 2;
                            this.__getNextChar();
                            break block50;
                        }
                        case 'w': {
                            offset = this.__emitNode('\u0012');
                            retFlags[0] = retFlags[0] | 3;
                            this.__getNextChar();
                            break block50;
                        }
                        case 'W': {
                            offset = this.__emitNode('\u0013');
                            retFlags[0] = retFlags[0] | 3;
                            this.__getNextChar();
                            break block50;
                        }
                        case 'b': {
                            offset = this.__emitNode('\u0014');
                            retFlags[0] = retFlags[0] | 2;
                            this.__getNextChar();
                            break block50;
                        }
                        case 'B': {
                            offset = this.__emitNode('\u0015');
                            retFlags[0] = retFlags[0] | 2;
                            this.__getNextChar();
                            break block50;
                        }
                        case 's': {
                            offset = this.__emitNode('\u0016');
                            retFlags[0] = retFlags[0] | 3;
                            this.__getNextChar();
                            break block50;
                        }
                        case 'S': {
                            offset = this.__emitNode('\u0017');
                            retFlags[0] = retFlags[0] | 3;
                            this.__getNextChar();
                            break block50;
                        }
                        case 'd': {
                            offset = this.__emitNode('\u0018');
                            retFlags[0] = retFlags[0] | 3;
                            this.__getNextChar();
                            break block50;
                        }
                        case 'D': {
                            offset = this.__emitNode('\u0019');
                            retFlags[0] = retFlags[0] | 3;
                            this.__getNextChar();
                            break block50;
                        }
                        case '0': 
                        case 'a': 
                        case 'c': 
                        case 'e': 
                        case 'f': 
                        case 'n': 
                        case 'r': 
                        case 't': 
                        case 'x': {
                            doDefault = true;
                            break block50;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            buffer = new StringBuffer(10);
                            num = 0;
                            value = this.__input._getValueRelative(num);
                            while (Character.isDigit(value)) {
                                buffer.append(value);
                                value = this.__input._getValueRelative(++num);
                            }
                            try {
                                num = Integer.parseInt(buffer.toString());
                            }
                            catch (NumberFormatException e) {
                                throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + e.getMessage());
                            }
                            if (num > 9 && num >= this.__numParentheses) {
                                doDefault = true;
                                break block50;
                            }
                            if (num >= this.__numParentheses) {
                                throw new MalformedPatternException("Invalid backreference: \\" + num);
                            }
                            this.__sawBackreference = true;
                            offset = this.__emitArgNode('\u001a', (char)num);
                            retFlags[0] = retFlags[0] | 1;
                            value = this.__input._getValue();
                            while (Character.isDigit(value)) {
                                value = this.__input._increment();
                            }
                            this.__input._decrement();
                            this.__getNextChar();
                            break block50;
                        }
                        case '\u0000': 
                        case '\uffff': {
                            if (!this.__input._isAtEnd()) break;
                            throw new MalformedPatternException("Trailing \\ in expression.");
                        }
                    }
                    doDefault = true;
                    break block50;
                }
                case '#': {
                    if ((this.__modifierFlags[0] & 32) != 0) {
                        while (!this.__input._isAtEnd() && this.__input._getValue() != '\n') {
                            this.__input._increment();
                        }
                        if (this.__input._isAtEnd()) ** break;
                        continue block50;
                    }
                }
                default: {
                    this.__input._increment();
                    doDefault = true;
                    break block50;
                }
            }
            break;
        }
        if (doDefault) {
            offset = this.__emitNode('\u000e');
            this.__emitCode('\uffff');
            pOffset = this.__input._getOffset() - 1;
            maxOffset = this.__input._getLength();
            block54: for (length = 0; length < 127 && pOffset < maxOffset; ++length) {
                lastOffset = pOffset;
                value = this.__input._getValue(pOffset);
                switch (value) {
                    case '$': 
                    case '(': 
                    case ')': 
                    case '.': 
                    case '[': 
                    case '^': 
                    case '|': {
                        break block54;
                    }
                    case '\\': {
                        value = this.__input._getValue(++pOffset);
                        switch (value) {
                            case 'A': 
                            case 'B': 
                            case 'D': 
                            case 'G': 
                            case 'S': 
                            case 'W': 
                            case 'Z': 
                            case 'b': 
                            case 'd': 
                            case 's': 
                            case 'w': {
                                --pOffset;
                                break block54;
                            }
                            case 'n': {
                                ender = '\n';
                                ++pOffset;
                                break;
                            }
                            case 'r': {
                                ender = '\r';
                                ++pOffset;
                                break;
                            }
                            case 't': {
                                ender = '\t';
                                ++pOffset;
                                break;
                            }
                            case 'f': {
                                ender = '\f';
                                ++pOffset;
                                break;
                            }
                            case 'e': {
                                ender = '\u001b';
                                ++pOffset;
                                break;
                            }
                            case 'a': {
                                ender = '\u0007';
                                ++pOffset;
                                break;
                            }
                            case 'x': {
                                numLength = new int[1];
                                ender = (char)Perl5Compiler.__parseHex(this.__input._array, ++pOffset, 2, numLength);
                                pOffset += numLength[0];
                                break;
                            }
                            case 'c': {
                                v0 = ++pOffset;
                                ++pOffset;
                                ender = this.__input._getValue(v0);
                                if (Character.isLowerCase(ender)) {
                                    ender = Character.toUpperCase(ender);
                                }
                                ender = (char)(ender ^ 64);
                                break;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                doOctal = false;
                                value = this.__input._getValue(pOffset);
                                if (value == '0') {
                                    doOctal = true;
                                }
                                if (Character.isDigit(value = this.__input._getValue(pOffset + 1))) {
                                    buffer = new StringBuffer(10);
                                    num = pOffset;
                                    value = this.__input._getValue(num);
                                    while (Character.isDigit(value)) {
                                        buffer.append(value);
                                        value = this.__input._getValue(++num);
                                    }
                                    try {
                                        num = Integer.parseInt(buffer.toString());
                                    }
                                    catch (NumberFormatException e) {
                                        throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + e.getMessage());
                                    }
                                    if (!doOctal) {
                                        v1 = doOctal = num >= this.__numParentheses;
                                    }
                                }
                                if (doOctal) {
                                    numLength = new int[1];
                                    ender = (char)Perl5Compiler.__parseOctal(this.__input._array, pOffset, 3, numLength);
                                    pOffset += numLength[0];
                                    break;
                                }
                                --pOffset;
                                break block54;
                            }
                            case '\u0000': 
                            case '\uffff': {
                                if (pOffset >= maxOffset) {
                                    throw new MalformedPatternException("Trailing \\ in expression.");
                                }
                            }
                            default: {
                                ender = this.__input._getValue(pOffset++);
                                break;
                            }
                        }
                        break;
                    }
                    case '#': {
                        if ((this.__modifierFlags[0] & 32) != 0) {
                            while (pOffset < maxOffset && this.__input._getValue(pOffset) != '\n') {
                                ++pOffset;
                            }
                        }
                    }
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if ((this.__modifierFlags[0] & 32) != 0) {
                            ++pOffset;
                            --length;
                            continue block54;
                        }
                    }
                    default: {
                        ender = this.__input._getValue(pOffset++);
                    }
                }
                if ((this.__modifierFlags[0] & '\u0001') != 0 && Character.isUpperCase(ender)) {
                    ender = Character.toLowerCase(ender);
                }
                if (pOffset < maxOffset && Perl5Compiler.__isComplexRepetitionOp(this.__input._array, pOffset)) {
                    if (length > 0) {
                        pOffset = lastOffset;
                        break;
                    }
                    ++length;
                    this.__emitCode(ender);
                    break;
                }
                this.__emitCode(ender);
            }
            this.__input._setOffset(pOffset - 1);
            this.__getNextChar();
            if (length < 0) {
                throw new MalformedPatternException("Unexpected compilation failure.  Please report this bug!");
            }
            if (length > 0) {
                retFlags[0] = retFlags[0] | 1;
            }
            if (length == 1) {
                retFlags[0] = retFlags[0] | 2;
            }
            if (this.__program != null) {
                this.__program[OpCode._getOperand((int)offset)] = (char)length;
            }
            this.__emitCode('\uffff');
        }
        return offset;
    }

    private int __parseUnicodeClass() throws MalformedPatternException {
        int offset;
        boolean range = false;
        char lastclss = '\uffff';
        int[] numLength = new int[]{0};
        boolean[] negFlag = new boolean[]{false};
        if (this.__input._getValue() == '^') {
            offset = this.__emitNode('$');
            this.__input._increment();
        } else {
            offset = this.__emitNode('#');
        }
        char clss = this.__input._getValue();
        boolean skipTest = clss == ']' || clss == '-';
        while (!this.__input._isAtEnd() && (clss = this.__input._getValue()) != ']' || skipTest) {
            skipTest = false;
            boolean opcodeFlag = false;
            this.__input._increment();
            if (clss == '\\' || clss == '[') {
                if (clss == '\\') {
                    clss = this.__input._postIncrement();
                } else {
                    char posixOpCode = this.__parsePOSIX(negFlag);
                    if (posixOpCode != '\u0000') {
                        opcodeFlag = true;
                        clss = posixOpCode;
                    }
                }
                if (!opcodeFlag) {
                    switch (clss) {
                        case 'w': {
                            opcodeFlag = true;
                            clss = '\u0012';
                            lastclss = '\uffff';
                            break;
                        }
                        case 'W': {
                            opcodeFlag = true;
                            clss = '\u0013';
                            lastclss = '\uffff';
                            break;
                        }
                        case 's': {
                            opcodeFlag = true;
                            clss = '\u0016';
                            lastclss = '\uffff';
                            break;
                        }
                        case 'S': {
                            opcodeFlag = true;
                            clss = '\u0017';
                            lastclss = '\uffff';
                            break;
                        }
                        case 'd': {
                            opcodeFlag = true;
                            clss = '\u0018';
                            lastclss = '\uffff';
                            break;
                        }
                        case 'D': {
                            opcodeFlag = true;
                            clss = '\u0019';
                            lastclss = '\uffff';
                            break;
                        }
                        case 'n': {
                            clss = '\n';
                            break;
                        }
                        case 'r': {
                            clss = '\r';
                            break;
                        }
                        case 't': {
                            clss = '\t';
                            break;
                        }
                        case 'f': {
                            clss = '\f';
                            break;
                        }
                        case 'b': {
                            clss = '\b';
                            break;
                        }
                        case 'e': {
                            clss = '\u001b';
                            break;
                        }
                        case 'a': {
                            clss = '\u0007';
                            break;
                        }
                        case 'x': {
                            clss = (char)Perl5Compiler.__parseHex(this.__input._array, this.__input._getOffset(), 2, numLength);
                            this.__input._increment(numLength[0]);
                            break;
                        }
                        case 'c': {
                            clss = this.__input._postIncrement();
                            if (Character.isLowerCase(clss)) {
                                clss = Character.toUpperCase(clss);
                            }
                            clss = (char)(clss ^ 0x40);
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            clss = (char)Perl5Compiler.__parseOctal(this.__input._array, this.__input._getOffset() - 1, 3, numLength);
                            this.__input._increment(numLength[0] - 1);
                            break;
                        }
                    }
                }
            }
            if (range) {
                if (lastclss > clss) {
                    throw new MalformedPatternException("Invalid [] range in expression.");
                }
                range = false;
            } else {
                lastclss = clss;
                if (!opcodeFlag && this.__input._getValue() == '-' && this.__input._getOffset() + 1 < this.__input._getLength() && this.__input._getValueRelative(1) != ']') {
                    this.__input._increment();
                    range = true;
                    continue;
                }
            }
            if (lastclss == clss) {
                if (opcodeFlag) {
                    if (!negFlag[0]) {
                        this.__emitCode('/');
                    } else {
                        this.__emitCode('0');
                    }
                } else {
                    this.__emitCode('1');
                }
                this.__emitCode(clss);
                if ((this.__modifierFlags[0] & '\u0001') != 0 && Character.isUpperCase(clss) && Character.isUpperCase(lastclss)) {
                    --this.__programSize;
                    this.__emitCode(Character.toLowerCase(clss));
                }
            }
            if (lastclss < clss) {
                this.__emitCode('%');
                this.__emitCode(lastclss);
                this.__emitCode(clss);
                if ((this.__modifierFlags[0] & '\u0001') != 0 && Character.isUpperCase(clss) && Character.isUpperCase(lastclss)) {
                    this.__programSize -= 2;
                    this.__emitCode(Character.toLowerCase(lastclss));
                    this.__emitCode(Character.toLowerCase(clss));
                }
                lastclss = '\uffff';
                range = false;
            }
            lastclss = clss;
        }
        if (this.__input._getValue() != ']') {
            throw new MalformedPatternException("Unmatched [] in expression.");
        }
        this.__getNextChar();
        this.__emitCode('\u0000');
        return offset;
    }

    private char __parsePOSIX(boolean[] negFlag) {
        char value;
        int offset = this.__input._getOffset();
        int len = this.__input._getLength();
        int pos = offset;
        if ((value = this.__input._getValue(pos++)) != ':') {
            return '\u0000';
        }
        if (this.__input._getValue(pos) == '^') {
            negFlag[0] = true;
            ++pos;
        } else {
            negFlag[0] = false;
        }
        StringBuffer buf = new StringBuffer();
        try {
            while ((value = this.__input._getValue(pos++)) != ':' && pos < len) {
                buf.append(value);
            }
        }
        catch (Exception e) {
            return '\u0000';
        }
        if (this.__input._getValue(pos++) != ']') {
            return '\u0000';
        }
        Character opcode = __hashPOSIX.get(buf.toString());
        if (opcode == null) {
            return '\u0000';
        }
        this.__input._setOffset(pos);
        return opcode.charValue();
    }

    private int __parseBranch(int[] retFlags) throws MalformedPatternException {
        boolean nestCheck = false;
        boolean handleRepetition = false;
        int[] flags = new int[]{0};
        int min = 0;
        int max = 65535;
        int offset = this.__parseAtom(flags);
        if (offset == -1) {
            if ((flags[0] & 8) != 0) {
                retFlags[0] = retFlags[0] | 8;
            }
            return -1;
        }
        char operator = this.__input._getValue();
        if (operator == '(' && this.__input._getValueRelative(1) == '?' && this.__input._getValueRelative(2) == '#') {
            while (operator != '\uffff' && operator != ')') {
                operator = this.__input._increment();
            }
            if (operator != '\uffff') {
                this.__getNextChar();
                operator = this.__input._getValue();
            }
        }
        if (operator == '{' && Perl5Compiler.__parseRepetition(this.__input._array, this.__input._getOffset())) {
            int maxOffset;
            int next = this.__input._getOffset() + 1;
            int pos = maxOffset = this.__input._getLength();
            char value = this.__input._getValue(next);
            while (Character.isDigit(value) || value == ',') {
                if (value == ',') {
                    if (pos != maxOffset) break;
                    pos = next;
                }
                value = this.__input._getValue(++next);
            }
            if (value == '}') {
                StringBuffer buffer = new StringBuffer(10);
                if (pos == maxOffset) {
                    pos = next;
                }
                this.__input._increment();
                int num = this.__input._getOffset();
                value = this.__input._getValue(num);
                while (Character.isDigit(value)) {
                    buffer.append(value);
                    value = this.__input._getValue(++num);
                }
                try {
                    min = Integer.parseInt(buffer.toString());
                }
                catch (NumberFormatException e) {
                    throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + e.getMessage());
                }
                value = this.__input._getValue(pos);
                pos = value == ',' ? ++pos : this.__input._getOffset();
                num = pos;
                buffer = new StringBuffer(10);
                value = this.__input._getValue(num);
                while (Character.isDigit(value)) {
                    buffer.append(value);
                    value = this.__input._getValue(++num);
                }
                try {
                    if (num != pos) {
                        max = Integer.parseInt(buffer.toString());
                    }
                }
                catch (NumberFormatException e) {
                    throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + e.getMessage());
                }
                if (max == 0 && this.__input._getValue(pos) != '0') {
                    max = 65535;
                }
                this.__input._setOffset(next);
                this.__getNextChar();
                nestCheck = true;
                handleRepetition = true;
            }
        }
        if (!nestCheck) {
            handleRepetition = false;
            if (!Perl5Compiler.__isSimpleRepetitionOp(operator)) {
                retFlags[0] = flags[0];
                return offset;
            }
            this.__getNextChar();
            int n = retFlags[0] = operator != '+' ? 4 : 1;
            if (operator == '*' && (flags[0] & 2) != 0) {
                this.__programInsertOperator('\u0010', offset);
                this.__cost += 4;
            } else if (operator == '*') {
                min = 0;
                handleRepetition = true;
            } else if (operator == '+' && (flags[0] & 2) != 0) {
                this.__programInsertOperator('\u0011', offset);
                this.__cost += 3;
            } else if (operator == '+') {
                min = 1;
                handleRepetition = true;
            } else if (operator == '?') {
                min = 0;
                max = 1;
                handleRepetition = true;
            }
        }
        if (handleRepetition) {
            if ((flags[0] & 2) != 0) {
                this.__cost += (2 + this.__cost) / 2;
                this.__programInsertOperator('\n', offset);
            } else {
                this.__cost += 4 + this.__cost;
                this.__programAddTail(offset, this.__emitNode('\"'));
                this.__programInsertOperator('\u000b', offset);
                this.__programAddTail(offset, this.__emitNode('\u000f'));
            }
            if (min > 0) {
                retFlags[0] = 1;
            }
            if (max != 0 && max < min) {
                throw new MalformedPatternException("Invalid interval {" + min + "," + max + "}");
            }
            if (this.__program != null) {
                this.__program[offset + 2] = (char)min;
                this.__program[offset + 3] = (char)max;
            }
        }
        if (this.__input._getValue() == '?') {
            this.__getNextChar();
            this.__programInsertOperator('\u001d', offset);
            this.__programAddTail(offset, offset + 2);
        }
        if (Perl5Compiler.__isComplexRepetitionOp(this.__input._array, this.__input._getOffset())) {
            throw new MalformedPatternException("Nested repetitions *?+ in expression");
        }
        return offset;
    }

    private int __parseExpression(boolean isParenthesized, int[] hintFlags) throws MalformedPatternException {
        int ender;
        char paren;
        int[] flags;
        int parenthesisNum;
        int nodeOffset;
        block31: {
            block29: {
                block30: {
                    char value;
                    char[] posFlags = new char[]{'\u0000'};
                    char[] negFlags = new char[]{'\u0000'};
                    nodeOffset = -1;
                    parenthesisNum = 0;
                    flags = new int[]{0};
                    String modifiers = "iogmsx-";
                    char[] modifierFlags = posFlags;
                    hintFlags[0] = 1;
                    if (!isParenthesized) break block29;
                    paren = '\u0001';
                    if (this.__input._getValue() != '?') break block30;
                    this.__input._increment();
                    paren = value = this.__input._postIncrement();
                    switch (value) {
                        case '!': 
                        case ':': 
                        case '=': {
                            break block31;
                        }
                        case '#': {
                            value = this.__input._getValue();
                            while (value != '\uffff' && value != ')') {
                                value = this.__input._increment();
                            }
                            if (value != ')') {
                                throw new MalformedPatternException("Sequence (?#... not terminated");
                            }
                            this.__getNextChar();
                            hintFlags[0] = 8;
                            return -1;
                        }
                        default: {
                            this.__input._decrement();
                            value = this.__input._getValue();
                            while (value != '\uffff' && "iogmsx-".indexOf(value) != -1) {
                                if (value == '-') {
                                    modifierFlags = negFlags;
                                } else {
                                    Perl5Compiler.__setModifierFlag(modifierFlags, value);
                                }
                                value = this.__input._increment();
                            }
                            this.__modifierFlags[0] = (char)(this.__modifierFlags[0] | posFlags[0]);
                            this.__modifierFlags[0] = (char)(this.__modifierFlags[0] & ~negFlags[0]);
                            if (value != ')') {
                                throw new MalformedPatternException("Sequence (?" + value + "...) not recognized");
                            }
                            this.__getNextChar();
                            hintFlags[0] = 8;
                            return -1;
                        }
                    }
                }
                parenthesisNum = this.__numParentheses++;
                nodeOffset = this.__emitArgNode('\u001b', (char)parenthesisNum);
                break block31;
            }
            paren = '\u0000';
        }
        int br = this.__parseAlternation(flags);
        if (br == -1) {
            return -1;
        }
        if (nodeOffset != -1) {
            this.__programAddTail(nodeOffset, br);
        } else {
            nodeOffset = br;
        }
        if ((flags[0] & 1) == 0) {
            hintFlags[0] = hintFlags[0] & 0xFFFFFFFE;
        }
        hintFlags[0] = hintFlags[0] | flags[0] & 4;
        while (this.__input._getValue() == '|') {
            this.__getNextChar();
            br = this.__parseAlternation(flags);
            if (br == -1) {
                return -1;
            }
            this.__programAddTail(nodeOffset, br);
            if ((flags[0] & 1) == 0) {
                hintFlags[0] = hintFlags[0] & 0xFFFFFFFE;
            }
            hintFlags[0] = hintFlags[0] | flags[0] & 4;
        }
        switch (paren) {
            case ':': {
                ender = this.__emitNode('\u000f');
                break;
            }
            case '\u0001': {
                ender = this.__emitArgNode('\u001c', (char)parenthesisNum);
                break;
            }
            case '!': 
            case '=': {
                ender = this.__emitNode('!');
                hintFlags[0] = hintFlags[0] & 0xFFFFFFFE;
                break;
            }
            default: {
                ender = this.__emitNode('\u0000');
            }
        }
        this.__programAddTail(nodeOffset, ender);
        br = nodeOffset;
        while (br != -1) {
            this.__programAddOperatorTail(br, ender);
            br = OpCode._getNext(this.__program, br);
        }
        if (paren == '=') {
            this.__programInsertOperator('\u001f', nodeOffset);
            this.__programAddTail(nodeOffset, this.__emitNode('\u000f'));
        } else if (paren == '!') {
            this.__programInsertOperator(' ', nodeOffset);
            this.__programAddTail(nodeOffset, this.__emitNode('\u000f'));
        }
        if (paren != '\u0000' && (this.__input._isAtEnd() || this.__getNextChar() != ')')) {
            throw new MalformedPatternException("Unmatched parentheses.");
        }
        if (paren == '\u0000' && !this.__input._isAtEnd()) {
            if (this.__input._getValue() == ')') {
                throw new MalformedPatternException("Unmatched parentheses.");
            }
            throw new MalformedPatternException("Unreached characters at end of expression.  Please report this bug!");
        }
        return nodeOffset;
    }

    @Override
    public Pattern compile(char[] pattern, int options) throws MalformedPatternException {
        String startString;
        String mustString;
        Perl5Pattern regexp;
        int caseInsensitive;
        int minLength;
        block44: {
            int[] flags = new int[]{0};
            boolean sawOpen = false;
            boolean sawPlus = false;
            minLength = 0;
            this.__input = new CharStringPointer(pattern);
            caseInsensitive = options & 1;
            this.__modifierFlags[0] = (char)options;
            this.__sawBackreference = false;
            this.__numParentheses = 1;
            this.__programSize = 0;
            this.__cost = 0;
            this.__program = null;
            this.__emitCode('\u0000');
            if (this.__parseExpression(false, flags) == -1) {
                throw new MalformedPatternException("Unknown compilation error.");
            }
            if (this.__programSize >= 65534) {
                throw new MalformedPatternException("Expression is too large.");
            }
            this.__program = new char[this.__programSize];
            regexp = new Perl5Pattern();
            regexp._program = this.__program;
            regexp._expression = new String(pattern);
            this.__input._setOffset(0);
            this.__numParentheses = 1;
            this.__programSize = 0;
            this.__cost = 0;
            this.__emitCode('\u0000');
            if (this.__parseExpression(false, flags) == -1) {
                throw new MalformedPatternException("Unknown compilation error.");
            }
            caseInsensitive = this.__modifierFlags[0] & '\u0001';
            regexp._isExpensive = this.__cost >= 10;
            regexp._startClassOffset = -1;
            regexp._anchor = 0;
            regexp._back = -1;
            regexp._options = options;
            regexp._startString = null;
            regexp._mustString = null;
            mustString = null;
            startString = null;
            int scan = 1;
            if (this.__program[OpCode._getNext(this.__program, scan)] != '\u0000') break block44;
            int first = scan = OpCode._getNextOperator(scan);
            char op = this.__program[first];
            while (true) {
                block46: {
                    block45: {
                        if (op != '\u001b') break block45;
                        sawOpen = true;
                        if (true) break block46;
                    }
                    if ((op != '\f' || this.__program[OpCode._getNext(this.__program, first)] == '\f') && op != '\u0011' && op != '\u001d' && (OpCode._opType[op] != '\n' || OpCode._getArg1(this.__program, first) <= '\u0000')) break;
                }
                if (op == '\u0011') {
                    sawPlus = true;
                } else {
                    first += OpCode._operandLength[op];
                }
                first = OpCode._getNextOperator(first);
                op = this.__program[first];
            }
            boolean doItAgain = true;
            while (doItAgain) {
                doItAgain = false;
                op = this.__program[first];
                if (op == '\u000e') {
                    startString = new String(this.__program, OpCode._getOperand(first + 1), (int)this.__program[OpCode._getOperand(first)]);
                    continue;
                }
                if (OpCode._isInArray(op, OpCode._opLengthOne, 2)) {
                    regexp._startClassOffset = first;
                    continue;
                }
                if (op == '\u0014' || op == '\u0015') {
                    regexp._startClassOffset = first;
                    continue;
                }
                if (OpCode._opType[op] == '\u0001') {
                    regexp._anchor = op == '\u0001' ? 1 : (op == '\u0002' ? 2 : 3);
                    first = OpCode._getNextOperator(first);
                    doItAgain = true;
                    continue;
                }
                if (op != '\u0010' || OpCode._opType[this.__program[OpCode._getNextOperator(first)]] != '\u0007' || (regexp._anchor & 3) == 0) continue;
                regexp._anchor = 11;
                first = OpCode._getNextOperator(first);
                doItAgain = true;
            }
            if (!(!sawPlus || sawOpen && this.__sawBackreference)) {
                regexp._anchor |= 4;
            }
            StringBuffer lastLongest = new StringBuffer();
            StringBuffer longest = new StringBuffer();
            int length = 0;
            minLength = 0;
            int curBack = 0;
            int back = 0;
            int backmost = 0;
            while (scan > 0 && (op = this.__program[scan]) != '\u0000') {
                if (op == '\f') {
                    if (this.__program[OpCode._getNext(this.__program, scan)] == '\f') {
                        curBack = -30000;
                        while (this.__program[scan] == '\f') {
                            scan = OpCode._getNext(this.__program, scan);
                        }
                        continue;
                    }
                    scan = OpCode._getNextOperator(scan);
                    continue;
                }
                if (op == ' ') {
                    curBack = -30000;
                    scan = OpCode._getNext(this.__program, scan);
                    continue;
                }
                if (op == '\u000e') {
                    int temp;
                    first = scan;
                    while (this.__program[temp = OpCode._getNext(this.__program, scan)] == '\u001c') {
                        scan = temp;
                    }
                    minLength += this.__program[OpCode._getOperand(first)];
                    temp = this.__program[OpCode._getOperand(first)];
                    if (curBack - back == length) {
                        lastLongest.append(new String(this.__program, OpCode._getOperand(first) + 1, temp));
                        length += temp;
                        curBack += temp;
                        first = OpCode._getNext(this.__program, scan);
                    } else if (temp >= length + (curBack >= 0 ? 1 : 0)) {
                        length = temp;
                        lastLongest = new StringBuffer(new String(this.__program, OpCode._getOperand(first) + 1, temp));
                        back = curBack;
                        curBack += length;
                        first = OpCode._getNext(this.__program, scan);
                    } else {
                        curBack += temp;
                    }
                } else if (OpCode._isInArray(op, OpCode._opLengthVaries, 0)) {
                    curBack = -30000;
                    length = 0;
                    if (lastLongest.length() > longest.length()) {
                        longest = lastLongest;
                        backmost = back;
                    }
                    lastLongest = new StringBuffer();
                    if (op == '\u0011' && OpCode._isInArray(this.__program[OpCode._getNextOperator(scan)], OpCode._opLengthOne, 0)) {
                        ++minLength;
                    } else if (OpCode._opType[op] == '\n' && OpCode._isInArray(this.__program[OpCode._getNextOperator(scan) + 2], OpCode._opLengthOne, 0)) {
                        minLength += OpCode._getArg1(this.__program, scan);
                    }
                } else if (OpCode._isInArray(op, OpCode._opLengthOne, 0)) {
                    ++curBack;
                    ++minLength;
                    length = 0;
                    if (lastLongest.length() > longest.length()) {
                        longest = lastLongest;
                        backmost = back;
                    }
                    lastLongest = new StringBuffer();
                }
                scan = OpCode._getNext(this.__program, scan);
            }
            if (lastLongest.length() + (OpCode._opType[this.__program[first]] == '\u0004' ? 1 : 0) > longest.length()) {
                longest = lastLongest;
                backmost = back;
            } else {
                lastLongest = new StringBuffer();
            }
            if (longest.length() > 0 && startString == null) {
                mustString = longest.toString();
                if (backmost < 0) {
                    backmost = -1;
                }
                regexp._back = backmost;
            } else {
                longest = null;
            }
        }
        regexp._isCaseInsensitive = (caseInsensitive & 1) != 0;
        regexp._numParentheses = this.__numParentheses - 1;
        regexp._minLength = minLength;
        if (mustString != null) {
            regexp._mustString = mustString.toCharArray();
            regexp._mustUtility = 100;
        }
        if (startString != null) {
            regexp._startString = startString.toCharArray();
        }
        return regexp;
    }

    @Override
    public Pattern compile(char[] pattern) throws MalformedPatternException {
        return this.compile(pattern, 0);
    }

    @Override
    public Pattern compile(String pattern) throws MalformedPatternException {
        return this.compile(pattern.toCharArray(), 0);
    }

    @Override
    public Pattern compile(String pattern, int options) throws MalformedPatternException {
        return this.compile(pattern.toCharArray(), options);
    }

    static {
        __hashPOSIX.put("alnum", Character.valueOf('2'));
        __hashPOSIX.put("word", Character.valueOf('\u0012'));
        __hashPOSIX.put("alpha", Character.valueOf('&'));
        __hashPOSIX.put("blank", Character.valueOf('\''));
        __hashPOSIX.put("cntrl", Character.valueOf('('));
        __hashPOSIX.put("digit", Character.valueOf('\u0018'));
        __hashPOSIX.put("graph", Character.valueOf(')'));
        __hashPOSIX.put("lower", Character.valueOf('*'));
        __hashPOSIX.put("print", Character.valueOf('+'));
        __hashPOSIX.put("punct", Character.valueOf(','));
        __hashPOSIX.put("space", Character.valueOf('\u0016'));
        __hashPOSIX.put("upper", Character.valueOf('-'));
        __hashPOSIX.put("xdigit", Character.valueOf('.'));
        __hashPOSIX.put("ascii", Character.valueOf('3'));
    }
}

