/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmimemagic.detectors;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.sf.jmimemagic.MagicDetector;
import org.apache.oro.text.perl.Perl5Util;

public final class TextFileDetector
implements MagicDetector {
    @Override
    public String getDisplayName() {
        return "Text File Detector";
    }

    @Override
    public String getVersion() {
        return "0.1";
    }

    @Override
    public String[] getHandledExtensions() {
        return new String[]{"txt", "text"};
    }

    @Override
    public String[] getHandledTypes() {
        return new String[]{"text/plain"};
    }

    @Override
    public String getName() {
        return "textfiledetector";
    }

    @Override
    public String[] process(byte[] data, int offset, int length, long bitmask, char comparator, String mimeType, Map<String, String> params) {
        Perl5Util util = new Perl5Util();
        String s = new String(data, StandardCharsets.UTF_8);
        if (!util.match("/[^[:ascii:][:space:]]/", s)) {
            return new String[]{"text/plain"};
        }
        return null;
    }

    @Override
    public String[] process(File file, int offset, int length, long bitmask, char comparator, String mimeType, Map<String, String> params) {
        return new String[0];
    }
}

