/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.simple;

import de.alpharogroup.crypto.api.Cryptor;
import de.alpharogroup.crypto.api.StringEncryptor;
import de.alpharogroup.crypto.compound.CompoundAlgorithm;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import lombok.NonNull;

public class SimpleEncryptor
implements StringEncryptor,
Cryptor {
    private Cipher cipher;
    private boolean initialized;
    private final String privateKey;

    public SimpleEncryptor(@NonNull String privateKey) {
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        this.privateKey = privateKey;
    }

    public String encrypt(String string) throws UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        this.initialize();
        byte[] utf8 = string.getBytes(StandardCharsets.UTF_8.name());
        byte[] encrypt = this.cipher.doFinal(utf8);
        String encrypted = Base64.getEncoder().encodeToString(encrypt);
        return encrypted;
    }

    private void initialize() throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (!this.isInitialized()) {
            PBEKeySpec keySpec = new PBEKeySpec(this.getPrivateKey().toCharArray());
            SecretKeyFactory factory = SecretKeyFactory.getInstance(CompoundAlgorithm.PBE_WITH_MD5_AND_DES.getAlgorithm());
            SecretKey key = factory.generateSecret(keySpec);
            this.cipher = Cipher.getInstance(key.getAlgorithm());
            PBEParameterSpec paramSpec = new PBEParameterSpec(CompoundAlgorithm.SALT, 19);
            this.cipher.init(this.newOperationMode(), (Key)key, paramSpec);
            this.initialized = true;
        }
    }

    public int newOperationMode() {
        return 1;
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }
}

