/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.obfuscation.character;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import de.alpharogroup.clone.object.CloneObjectExtensions;
import de.alpharogroup.collections.map.MapFactory;
import de.alpharogroup.collections.pairs.KeyValuePair;
import de.alpharogroup.crypto.obfuscation.rule.ObfuscationOperationRule;
import de.alpharogroup.crypto.obfuscation.rule.Operation;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class ObfuscatorExtensions {
    public static String obfuscateWith(BiMap<Character, ObfuscationOperationRule<Character, Character>> rules, String toObfuscate) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toObfuscate.length(); ++i) {
            char currentCharacter = toObfuscate.charAt(i);
            Character asCharacter = Character.valueOf(currentCharacter);
            String charAsString = Character.toString(currentCharacter);
            if (rules.containsKey((Object)asCharacter)) {
                ObfuscationOperationRule obfuscationOperationRule = (ObfuscationOperationRule)rules.get((Object)asCharacter);
                Set indexes = obfuscationOperationRule.getIndexes();
                Operation operation = obfuscationOperationRule.getOperation();
                if (operation != null) {
                    obfuscationOperationRule.setOperatedCharacter(Optional.of(Operation.operate((char)currentCharacter, (Operation)operation)));
                }
                if (indexes.contains(i) && obfuscationOperationRule.getOperatedCharacter().isPresent()) {
                    sb.append(obfuscationOperationRule.getOperatedCharacter().get());
                    continue;
                }
                Character replaceWith = (Character)obfuscationOperationRule.getReplaceWith();
                sb.append(replaceWith);
                continue;
            }
            sb.append(charAsString);
        }
        return sb.toString();
    }

    public static String disentangle(List<KeyValuePair<Character, ObfuscationOperationRule<Character, Character>>> rules, String obfuscated) {
        StringBuilder sb = new StringBuilder();
        Map<Character, Character> swapped = ObfuscatorExtensions.swapMapWithReplaceWithAsKey((BiMap<Character, ObfuscationOperationRule<Character, Character>>)HashBiMap.create((Map)KeyValuePair.toMap(rules)));
        for (int i = 0; i < obfuscated.length(); ++i) {
            char currentChar = obfuscated.charAt(i);
            Character currentCharacter = Character.valueOf(currentChar);
            if (swapped.containsKey(currentCharacter)) {
                sb.append(swapped.get(currentCharacter));
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    public static String disentangleImproved(BiMap<Character, ObfuscationOperationRule<Character, Character>> rules, String obfuscated) {
        StringBuilder sb = new StringBuilder();
        Map<Character, ObfuscationOperationRule<Character, Character>> swapped = ObfuscatorExtensions.swapOperatedMapWithReplaceWithAsKey(rules);
        BiMap<ObfuscationOperationRule<Character, Character>, Character> inverted = ObfuscatorExtensions.inverse(rules);
        BiMap inverseInverted = inverted.inverse();
        for (int i = 0; i < obfuscated.length(); ++i) {
            ObfuscationOperationRule<Character, Character> currentOperationRule;
            char currentChar = obfuscated.charAt(i);
            Character currentCharacter = Character.valueOf(currentChar);
            if (inverseInverted.containsKey((Object)currentCharacter)) {
                currentOperationRule = (ObfuscationOperationRule<Character, Character>)inverseInverted.get((Object)currentCharacter);
                sb.append(currentOperationRule.getReplaceWith());
                continue;
            }
            if (swapped.containsKey(currentCharacter)) {
                currentOperationRule = swapped.get(currentCharacter);
                Set indexes = currentOperationRule.getIndexes();
                if (indexes.isEmpty() || !indexes.contains(i)) continue;
                sb.append(currentOperationRule.getCharacter());
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    public static String disentangle(BiMap<Character, ObfuscationOperationRule<Character, Character>> rules, String obfuscated) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < obfuscated.length(); ++i) {
            boolean processed = false;
            char currentChar = obfuscated.charAt(i);
            boolean upperCase = Character.isUpperCase(currentChar);
            boolean lowerCase = Character.isLowerCase(currentChar);
            Character currentCharacter = Character.valueOf(currentChar);
            for (Map.Entry entry : rules.entrySet()) {
                ObfuscationOperationRule obfuscationOperationRule = (ObfuscationOperationRule)entry.getValue();
                Set indexes = obfuscationOperationRule.getIndexes();
                Operation operation = obfuscationOperationRule.getOperation();
                if (operation != null) {
                    obfuscationOperationRule.setOperatedCharacter(Optional.of(Operation.operate((char)currentCharacter.charValue(), (Operation)operation)));
                }
                Character character = (Character)obfuscationOperationRule.getCharacter();
                Character replaceWith = (Character)obfuscationOperationRule.getReplaceWith();
                if (!indexes.isEmpty() && indexes.contains(i) && operation != null) {
                    Character operatedCharacter = Operation.operate((char)character.charValue(), (Operation)operation);
                    if (currentCharacter.equals(operatedCharacter)) {
                        if (operation.equals((Object)Operation.UPPERCASE) && upperCase || operation.equals((Object)Operation.LOWERCASE) && lowerCase) {
                            sb.append(Operation.operate((char)currentChar, (Operation)operation, (boolean)true));
                        } else {
                            sb.append(Operation.operate((char)currentChar, (Operation)operation, (boolean)false));
                        }
                        processed = true;
                        continue;
                    }
                    if (currentCharacter.equals(replaceWith)) {
                        sb.append(character);
                        processed = true;
                        continue;
                    }
                }
                if (!currentCharacter.equals(replaceWith) || !rules.containsKey((Object)replaceWith)) continue;
                sb.append(character);
                processed = true;
            }
            if (processed || rules.containsKey((Object)currentCharacter)) continue;
            sb.append(currentChar);
        }
        return sb.toString();
    }

    public static boolean validate(BiMap<Character, ObfuscationOperationRule<Character, Character>> rules) {
        Set keySet = rules.keySet();
        for (Map.Entry entry : rules.entrySet()) {
            ObfuscationOperationRule value = (ObfuscationOperationRule)entry.getValue();
            Character operatedCharacter = Operation.operate((char)((Character)value.getCharacter()).charValue(), (Operation)value.getOperation());
            if (!keySet.contains(operatedCharacter)) continue;
            return false;
        }
        return true;
    }

    public static Map<Character, Character> swapMapWithReplaceWithAsKey(BiMap<Character, ObfuscationOperationRule<Character, Character>> rules) {
        Map swapped = MapFactory.newLinkedHashMap();
        rules.entrySet().forEach(entry -> {
            ObfuscationOperationRule value = (ObfuscationOperationRule)entry.getValue();
            if (value.getOperation() != null && !value.getOperation().equals((Object)Operation.NONE) && !value.getIndexes().isEmpty()) {
                value.setOperatedCharacter(Optional.of(Operation.operate((char)((Character)value.getCharacter()).charValue(), (Operation)value.getOperation())));
                swapped.put(value.getOperatedCharacter().get(), entry.getKey());
            }
            swapped.put(value.getReplaceWith(), entry.getKey());
        });
        return swapped;
    }

    public static Map<Character, ObfuscationOperationRule<Character, Character>> swapOperatedMapWithReplaceWithAsKey(BiMap<Character, ObfuscationOperationRule<Character, Character>> rules) {
        Map swapped = MapFactory.newLinkedHashMap();
        rules.entrySet().forEach(entry -> {
            ObfuscationOperationRule value = (ObfuscationOperationRule)entry.getValue();
            if (value.getOperation() != null && !value.getOperation().equals((Object)Operation.NONE) && !value.getIndexes().isEmpty()) {
                value.setOperatedCharacter(Optional.of(Operation.operate((char)((Character)value.getCharacter()).charValue(), (Operation)value.getOperation())));
                swapped.put(value.getOperatedCharacter().get(), value);
            }
            swapped.put(value.getReplaceWith(), value);
        });
        return swapped;
    }

    public static void inverse(ObfuscationOperationRule<Character, Character> rule) {
        char currentChar = ((Character)rule.getCharacter()).charValue();
        char replaceWithChar = ((Character)rule.getReplaceWith()).charValue();
        rule.setCharacter((Object)Character.valueOf(replaceWithChar));
        rule.setReplaceWith((Object)Character.valueOf(currentChar));
        rule.setInverted(!rule.isInverted());
    }

    public static BiMap<ObfuscationOperationRule<Character, Character>, Character> inverse(BiMap<Character, ObfuscationOperationRule<Character, Character>> rules) {
        Optional<BiMap<Character, ObfuscationOperationRule<Character, Character>>> optional = ObfuscatorExtensions.tryToClone(rules);
        BiMap<Character, ObfuscationOperationRule<Character, Character>> cloned = optional.isPresent() ? optional.get() : rules;
        BiMap invertedBiMap = cloned.inverse();
        invertedBiMap.entrySet().forEach(entry -> {
            ObfuscationOperationRule key = (ObfuscationOperationRule)entry.getKey();
            ObfuscatorExtensions.inverse((ObfuscationOperationRule<Character, Character>)key);
            entry.setValue(key.getCharacter());
        });
        return invertedBiMap;
    }

    public static Map<ObfuscationOperationRule<Character, Character>, Character> inverseToMap(BiMap<Character, ObfuscationOperationRule<Character, Character>> rules) {
        HashMap<ObfuscationOperationRule<Character, Character>, Character> invertedMap = new HashMap<ObfuscationOperationRule<Character, Character>, Character>();
        rules.entrySet().forEach(entry -> invertedMap.put((ObfuscationOperationRule<Character, Character>)ObfuscatorExtensions.tryToClone(entry.getValue()).get(), (Character)ObfuscatorExtensions.tryToClone(entry.getKey()).get()));
        return invertedMap;
    }

    public static <T> Optional<T> tryToClone(T object) {
        try {
            return Optional.of(CloneObjectExtensions.clone(object));
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private ObfuscatorExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

