/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key;

import de.alpharogroup.crypto.algorithm.Algorithm;
import de.alpharogroup.crypto.algorithm.KeyPairWithModeAndPaddingAlgorithm;
import de.alpharogroup.crypto.api.ByteArrayDecryptor;
import de.alpharogroup.crypto.core.AbstractDecryptor;
import de.alpharogroup.crypto.factories.CipherFactory;
import de.alpharogroup.crypto.model.CryptModel;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class PrivateKeyDecryptor
extends AbstractDecryptor<Cipher, PrivateKey, byte[]>
implements ByteArrayDecryptor {
    private static final long serialVersionUID = 1L;

    public PrivateKeyDecryptor(CryptModel<Cipher, PrivateKey, byte[]> model) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
    }

    public byte[] decrypt(byte[] encrypted) throws Exception {
        byte[] decrypted = ((Cipher)this.getModel().getCipher()).doFinal(encrypted);
        return decrypted;
    }

    @Override
    protected String newAlgorithm() {
        if (this.getModel().getAlgorithm() == null) {
            this.getModel().setAlgorithm((Algorithm)KeyPairWithModeAndPaddingAlgorithm.RSA_ECB_OAEPWithSHA1AndMGF1Padding);
        }
        return this.getModel().getAlgorithm().getAlgorithm();
    }

    @Override
    protected Cipher newCipher(PrivateKey key, String algorithm, byte[] salt, int iterationCount, int operationMode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        Cipher cipher = CipherFactory.newCipher((String)algorithm);
        cipher.init(operationMode, key);
        return cipher;
    }
}

