/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.file.xml;

import com.thoughtworks.xstream.XStream;
import de.alpharogroup.crypto.hex.HexExtensions;
import de.alpharogroup.file.write.WriteFileExtensions;
import de.alpharogroup.xml.ObjectToXmlExtensions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import lombok.NonNull;

public final class XmlEncryptionExtensions {
    public static <T> void writeToFileAsXmlAndHex(@NonNull XStream xstream, @NonNull Map<String, Class<?>> aliases, @NonNull T data, @NonNull File file) throws IOException {
        if (xstream == null) {
            throw new NullPointerException("xstream is marked non-null but is null");
        }
        if (aliases == null) {
            throw new NullPointerException("aliases is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        String xmlString = ObjectToXmlExtensions.toXmlWithXStream((XStream)xstream, data, aliases);
        String hexXmlString = HexExtensions.encodeHex((String)xmlString, (Charset)Charset.forName("UTF-8"), (boolean)true);
        WriteFileExtensions.writeStringToFile((File)file, (String)hexXmlString, (String)"UTF-8");
    }

    private XmlEncryptionExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

