/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.file.xml;

import com.thoughtworks.xstream.XStream;
import de.alpharogroup.crypto.hex.HexExtensions;
import de.alpharogroup.file.read.ReadFileExtensions;
import de.alpharogroup.xml.XmlToObjectExtensions;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.codec.DecoderException;

public final class XmlDecryptionExtensions {
    public static <T> T readFromFileAsXmlAndHex(@NonNull XStream xstream, @NonNull Map<String, Class<?>> aliases, @NonNull File selectedFile) throws IOException, DecoderException {
        if (xstream == null) {
            throw new NullPointerException("xstream is marked non-null but is null");
        }
        if (aliases == null) {
            throw new NullPointerException("aliases is marked non-null but is null");
        }
        if (selectedFile == null) {
            throw new NullPointerException("selectedFile is marked non-null but is null");
        }
        String hexXmlString = ReadFileExtensions.readFromFile((File)selectedFile);
        String xmlString = HexExtensions.decodeHex((String)hexXmlString);
        return (T)XmlToObjectExtensions.toObjectWithXStream((XStream)xstream, (String)xmlString, aliases);
    }

    private XmlDecryptionExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

