/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.file.checksum;

import de.alpharogroup.crypto.algorithm.Algorithm;
import de.alpharogroup.file.read.ReadFileExtensions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.commons.lang3.ArrayUtils;

public final class ChecksumExtensions {
    private static final String HEXADECIMAL_CHARACTER_CLASS = "[a-fA-F0-9]";
    public static final String REGEX_VALIDATION_SHA1 = "[a-fA-F0-9]{40}";
    public static final String REGEX_VALIDATION_MD5 = "[a-fA-F0-9]{32}";
    public static final String REGEX_VALIDATION_SHA512 = "[a-fA-F0-9]{128}";

    public static String getChecksum(Algorithm algorithm, byte[] ... byteArrays) throws NoSuchAlgorithmException {
        StringBuilder sb = new StringBuilder();
        for (byte[] byteArray : byteArrays) {
            sb.append(ChecksumExtensions.getChecksum(byteArray, algorithm.getAlgorithm()));
        }
        return sb.toString();
    }

    public static String getChecksum(byte[] bytes, Algorithm algorithm) throws NoSuchAlgorithmException {
        return ChecksumExtensions.getChecksum(bytes, algorithm.getAlgorithm());
    }

    public static String getChecksum(byte[] bytes, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        messageDigest.reset();
        messageDigest.update(bytes);
        byte[] digest = messageDigest.digest();
        StringBuilder hexView = new StringBuilder();
        for (byte element : digest) {
            String intAsHex = Integer.toHexString(0xFF & element);
            if (intAsHex.length() == 1) {
                hexView.append('0');
            }
            hexView.append(intAsHex);
        }
        return hexView.toString();
    }

    public static String getChecksum(Byte[] bytes, Algorithm algorithm) throws NoSuchAlgorithmException {
        return ChecksumExtensions.getChecksum(bytes, algorithm.getAlgorithm());
    }

    public static String getChecksum(Byte[] bytes, String algorithm) throws NoSuchAlgorithmException {
        return ChecksumExtensions.getChecksum(ArrayUtils.toPrimitive((Byte[])bytes), algorithm);
    }

    public static String getChecksum(File file, Algorithm algorithm) throws NoSuchAlgorithmException, IOException {
        return ChecksumExtensions.getChecksum(file, algorithm.getAlgorithm());
    }

    public static long getChecksum(File file, boolean crc) throws FileNotFoundException, IOException {
        try (CheckedInputStream cis = crc ? new CheckedInputStream(new FileInputStream(file), new CRC32()) : new CheckedInputStream(new FileInputStream(file), new Adler32());){
            int length = (int)file.length();
            byte[] buffer = new byte[length];
            long checksum = 0L;
            while (cis.read(buffer) >= 0) {
                checksum = cis.getChecksum().getValue();
            }
            long l = checksum = cis.getChecksum().getValue();
            return l;
        }
    }

    public static String getChecksum(File file, String algorithm) throws NoSuchAlgorithmException, IOException {
        return ChecksumExtensions.getChecksum(ReadFileExtensions.toByteArray((File)file), algorithm);
    }

    public static long getCheckSumAdler32(byte[] bytes) {
        Adler32 checksum = new Adler32();
        checksum.update(bytes, 0, bytes.length);
        long cs = checksum.getValue();
        return cs;
    }

    public static long getCheckSumAdler32(File file) throws IOException {
        return ChecksumExtensions.getCheckSumAdler32(ReadFileExtensions.toByteArray((File)file));
    }

    public static long getCheckSumCRC32(byte[] bytes) {
        CRC32 checksum = new CRC32();
        checksum.update(bytes, 0, bytes.length);
        long cs = checksum.getValue();
        return cs;
    }

    public static long getCheckSumCRC32(File file) throws IOException {
        return ChecksumExtensions.getCheckSumCRC32(ReadFileExtensions.toByteArray((File)file));
    }

    public static boolean matchesMD5(String value) {
        return value.matches(REGEX_VALIDATION_MD5);
    }

    public static boolean matchesSHA1(String value) {
        return value.matches(REGEX_VALIDATION_SHA1);
    }

    public static boolean matchesSHA512(String value) {
        return value.matches(REGEX_VALIDATION_SHA512);
    }

    private ChecksumExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

