/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.file;

import de.alpharogroup.crypto.core.AbstractObjectEncryptor;
import de.alpharogroup.crypto.model.CryptModel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import lombok.NonNull;

public class GenericObjectEncryptor<T, D>
extends AbstractObjectEncryptor<T, D> {
    private static final long serialVersionUID = 1L;
    private File encryptedFile;

    public GenericObjectEncryptor(CryptModel<Cipher, String, D> model, @NonNull File encryptedFile) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
        if (encryptedFile == null) {
            throw new NullPointerException("encryptedFile is marked non-null but is null");
        }
        this.encryptedFile = encryptedFile;
    }

    public File encrypt(@NonNull T toEncrypt) throws Exception {
        if (toEncrypt == null) {
            throw new NullPointerException("toEncrypt is marked non-null but is null");
        }
        this.onBeforeEncrypt(toEncrypt);
        this.onEncrypt(toEncrypt);
        this.onAfterEncrypt(toEncrypt);
        return this.encryptedFile;
    }

    protected File newEncryptedFile(String parent, String child) {
        return new File(parent, child);
    }

    protected void onAfterEncrypt(@NonNull T toEncrypt) {
        if (toEncrypt == null) {
            throw new NullPointerException("toEncrypt is marked non-null but is null");
        }
    }

    protected void onBeforeEncrypt(@NonNull T toEncrypt) {
        if (toEncrypt == null) {
            throw new NullPointerException("toEncrypt is marked non-null but is null");
        }
    }

    private void onEncrypt(@NonNull T toEncrypt) throws IOException {
        if (toEncrypt == null) {
            throw new NullPointerException("toEncrypt is marked non-null but is null");
        }
        Cipher cipher = (Cipher)this.getModel().getCipher();
        try (CipherOutputStream cipherOutputStream = new CipherOutputStream(new BufferedOutputStream(new FileOutputStream(this.encryptedFile)), cipher);
             ObjectOutputStream outputStream = new ObjectOutputStream(cipherOutputStream);){
            outputStream.writeObject(toEncrypt);
            outputStream.close();
        }
    }
}

