/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.file;

import de.alpharogroup.crypto.core.AbstractObjectDecryptor;
import de.alpharogroup.crypto.model.CryptModel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import lombok.NonNull;

public class GenericObjectDecryptor<R, D>
extends AbstractObjectDecryptor<R, D> {
    private static final long serialVersionUID = 1L;

    public GenericObjectDecryptor(CryptModel<Cipher, String, D> model) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
    }

    public R decrypt(@NonNull File encrypted) throws Exception {
        if (encrypted == null) {
            throw new NullPointerException("encrypted is marked non-null but is null");
        }
        this.onBeforeDecrypt(encrypted);
        R genericObject = this.onDecrypt(encrypted);
        this.onAfterDecrypt(encrypted);
        return genericObject;
    }

    protected void onAfterDecrypt(@NonNull File encrypted) {
        if (encrypted == null) {
            throw new NullPointerException("encrypted is marked non-null but is null");
        }
    }

    protected void onBeforeDecrypt(@NonNull File encrypted) {
        if (encrypted == null) {
            throw new NullPointerException("encrypted is marked non-null but is null");
        }
    }

    private R onDecrypt(@NonNull File encrypted) throws IOException, ClassNotFoundException {
        if (encrypted == null) {
            throw new NullPointerException("encrypted is marked non-null but is null");
        }
        Object genericObject = null;
        Cipher cipher = (Cipher)this.getModel().getCipher();
        try (CipherInputStream cipherInputStream = new CipherInputStream(new BufferedInputStream(new FileInputStream(encrypted)), cipher);
             ObjectInputStream inputStream = new ObjectInputStream(cipherInputStream);){
            genericObject = inputStream.readObject();
            inputStream.close();
        }
        return (R)genericObject;
    }
}

