/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.file;

import de.alpharogroup.crypto.core.AbstractFileDecryptor;
import de.alpharogroup.crypto.decorator.CryptObjectDecoratorExtensions;
import de.alpharogroup.crypto.io.CryptoCipherOutputStream;
import de.alpharogroup.crypto.model.CryptModel;
import de.alpharogroup.crypto.model.CryptObjectDecorator;
import de.alpharogroup.file.read.ReadFileExtensions;
import de.alpharogroup.file.write.WriteFileExtensions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;

public class FileDecryptor
extends AbstractFileDecryptor {
    private static final long serialVersionUID = 1L;
    private File decryptedFile;

    public FileDecryptor(CryptModel<Cipher, String, String> model) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
    }

    public FileDecryptor(CryptModel<Cipher, String, String> model, File decryptedFile) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        super(model);
        this.decryptedFile = decryptedFile;
    }

    public File decrypt(@NonNull File encrypted) throws Exception {
        if (encrypted == null) {
            throw new NullPointerException("encrypted is marked non-null but is null");
        }
        this.onBeforeDecrypt(encrypted);
        this.onDecrypt(encrypted);
        this.onAfterDecrypt(encrypted);
        return this.decryptedFile;
    }

    protected File newDecryptedFile(String parent, String child) {
        return new File(parent, child);
    }

    protected void onAfterDecrypt(@NonNull File encrypted) throws IOException {
        if (encrypted == null) {
            throw new NullPointerException("encrypted is marked non-null but is null");
        }
        String decryptedFileString = ReadFileExtensions.readFromFile((File)this.decryptedFile);
        List decorators = this.getModel().getDecorators();
        if (decorators != null && !decorators.isEmpty()) {
            for (int i = decorators.size() - 1; 0 <= i; --i) {
                decryptedFileString = CryptObjectDecoratorExtensions.undecorateFile(this.decryptedFile, (CryptObjectDecorator<String>)((CryptObjectDecorator)decorators.get(i)));
            }
        }
        WriteFileExtensions.writeStringToFile((File)this.decryptedFile, (String)decryptedFileString, (String)Charset.forName("UTF-8").name());
    }

    protected void onBeforeDecrypt(@NonNull File encrypted) {
        if (encrypted == null) {
            throw new NullPointerException("encrypted is marked non-null but is null");
        }
        if (this.decryptedFile == null) {
            String filename = FilenameUtils.getBaseName((String)encrypted.getName());
            this.decryptedFile = this.newDecryptedFile(encrypted.getParent(), filename + ".decrypted");
        }
    }

    protected void onDecrypt(@NonNull File encrypted) throws Exception {
        if (encrypted == null) {
            throw new NullPointerException("encrypted is marked non-null but is null");
        }
        try (FileOutputStream decryptedOut = new FileOutputStream(this.decryptedFile);
             CryptoCipherOutputStream cos = new CryptoCipherOutputStream(decryptedOut, (Cipher)this.getModel().getCipher());
             FileInputStream fileInputStream = new FileInputStream(encrypted);){
            int c;
            while ((c = ((InputStream)fileInputStream).read()) != -1) {
                cos.write(c);
            }
        }
    }
}

