/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.decorator;

import de.alpharogroup.crypto.model.CharacterDecorator;
import de.alpharogroup.crypto.model.CryptObjectDecorator;
import de.alpharogroup.file.read.ReadFileExtensions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class CryptObjectDecoratorExtensions {
    public static String decorateFile(@NonNull File toEncrypt, @NonNull CryptObjectDecorator<String> decorator) throws IOException {
        if (toEncrypt == null) {
            throw new NullPointerException("toEncrypt is marked non-null but is null");
        }
        if (decorator == null) {
            throw new NullPointerException("decorator is marked non-null but is null");
        }
        return CryptObjectDecoratorExtensions.decorateWithStringDecorator(ReadFileExtensions.readFromFile((File)toEncrypt), decorator);
    }

    public static String decorateWithBytearrayDecorator(@NonNull String toEncrypt, @NonNull CryptObjectDecorator<byte[]> decorator, @NonNull Charset charset) {
        if (toEncrypt == null) {
            throw new NullPointerException("toEncrypt is marked non-null but is null");
        }
        if (decorator == null) {
            throw new NullPointerException("decorator is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(new String((byte[])decorator.getPrefix(), charset));
        sb.append(toEncrypt);
        sb.append(new String((byte[])decorator.getSuffix(), charset));
        return sb.toString();
    }

    public static String decorateWithCharacterDecorator(@NonNull String toEncrypt, @NonNull CharacterDecorator decorator) {
        if (toEncrypt == null) {
            throw new NullPointerException("toEncrypt is marked non-null but is null");
        }
        if (decorator == null) {
            throw new NullPointerException("decorator is marked non-null but is null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(decorator.getPrefix());
        sb.append(toEncrypt);
        sb.append(decorator.getSuffix());
        return sb.toString();
    }

    public static String decorateWithStringDecorator(@NonNull String toEncrypt, @NonNull CryptObjectDecorator<String> decorator) {
        if (toEncrypt == null) {
            throw new NullPointerException("toEncrypt is marked non-null but is null");
        }
        if (decorator == null) {
            throw new NullPointerException("decorator is marked non-null but is null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append((String)decorator.getPrefix());
        sb.append(toEncrypt);
        sb.append((String)decorator.getSuffix());
        return sb.toString();
    }

    private static boolean endsWith(@NonNull byte[] array, @NonNull byte[] suffix) {
        int lastIndex;
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        int currentIndex = lastIndex = suffix.length - 1;
        if (ArrayUtils.isEmpty((byte[])suffix)) {
            return false;
        }
        for (int i = array.length - 1; 0 <= i; --i) {
            if (suffix[currentIndex--] != array[i]) {
                return false;
            }
            if (currentIndex == -1) break;
        }
        return true;
    }

    private static byte[] removeFromEnd(@NonNull byte[] array, @NonNull byte[] suffix) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        return Arrays.copyOf(array, array.length - suffix.length);
    }

    private static byte[] removeFromStart(@NonNull byte[] array, @NonNull byte[] prefix) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        byte[] result = new byte[array.length - prefix.length];
        System.arraycopy(array, prefix.length, result, 0, result.length);
        return result;
    }

    private static boolean startsWith(byte[] array, byte[] prefix) {
        for (int i = 0; i < prefix.length; ++i) {
            if (prefix[i] == array[i]) continue;
            return false;
        }
        return true;
    }

    public static String undecorateFile(@NonNull File decrypted, @NonNull CryptObjectDecorator<String> decorator) throws IOException {
        if (decrypted == null) {
            throw new NullPointerException("decrypted is marked non-null but is null");
        }
        if (decorator == null) {
            throw new NullPointerException("decorator is marked non-null but is null");
        }
        return CryptObjectDecoratorExtensions.undecorateWithStringDecorator(ReadFileExtensions.readFromFile((File)decrypted), decorator);
    }

    public static String undecorateWithBytearrayDecorator(@NonNull String toEncrypt, @NonNull CryptObjectDecorator<byte[]> decorator) {
        if (toEncrypt == null) {
            throw new NullPointerException("toEncrypt is marked non-null but is null");
        }
        if (decorator == null) {
            throw new NullPointerException("decorator is marked non-null but is null");
        }
        byte[] result = toEncrypt.getBytes();
        byte[] prefix = (byte[])decorator.getPrefix();
        byte[] suffix = (byte[])decorator.getSuffix();
        if (CryptObjectDecoratorExtensions.startsWith(result = ArrayUtils.removeElements((byte[])result, (byte[])prefix), prefix)) {
            result = CryptObjectDecoratorExtensions.removeFromStart(result, prefix);
        }
        if (CryptObjectDecoratorExtensions.endsWith(result, suffix)) {
            result = CryptObjectDecoratorExtensions.removeFromEnd(result, suffix);
        }
        return new String(result);
    }

    public static String undecorateWithCharacterDecorator(@NonNull String toEncrypt, @NonNull CharacterDecorator decorator) {
        if (toEncrypt == null) {
            throw new NullPointerException("toEncrypt is marked non-null but is null");
        }
        if (decorator == null) {
            throw new NullPointerException("decorator is marked non-null but is null");
        }
        StringBuilder sb = new StringBuilder(toEncrypt);
        boolean prefixRemoved = false;
        if (toEncrypt.startsWith(((Character)decorator.getPrefix()).toString())) {
            sb.deleteCharAt(0);
            prefixRemoved = true;
        }
        if (toEncrypt.endsWith(((Character)decorator.getSuffix()).toString())) {
            if (prefixRemoved) {
                sb.deleteCharAt(toEncrypt.length() - 2);
            } else {
                sb.deleteCharAt(toEncrypt.length() - 1);
            }
        }
        return sb.toString();
    }

    public static String undecorateWithStringDecorator(@NonNull String decrypted, @NonNull CryptObjectDecorator<String> decorator) {
        if (decrypted == null) {
            throw new NullPointerException("decrypted is marked non-null but is null");
        }
        if (decorator == null) {
            throw new NullPointerException("decorator is marked non-null but is null");
        }
        String result = decrypted;
        if (decrypted.startsWith((String)decorator.getPrefix())) {
            result = StringUtils.removeStart((String)result, (String)((String)decorator.getPrefix()));
        }
        if (decrypted.endsWith((String)decorator.getSuffix())) {
            result = StringUtils.removeEnd((String)result, (String)((String)decorator.getSuffix()));
        }
        return result;
    }
}

