/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.delete;

import de.alpharogroup.file.exceptions.DirectoryHasNoContentException;
import de.alpharogroup.file.exceptions.FileDoesNotExistException;
import de.alpharogroup.file.exceptions.FileIsNotADirectoryException;
import de.alpharogroup.file.exceptions.FileIsSecurityRestrictedException;
import de.alpharogroup.file.search.FileSearchExtensions;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;

public final class DeleteFileExtensions {
    public static Exception checkFile(File file) {
        Exception ex = null;
        String error = null;
        if (!file.exists()) {
            error = "The " + file + " does not exists.";
            ex = new FileDoesNotExistException(error);
            return ex;
        }
        if (!file.isDirectory()) {
            error = "The " + file + " is not a directory.";
            ex = new FileIsNotADirectoryException(error);
            return ex;
        }
        File[] ff = file.listFiles();
        if (ff == null) {
            error = "The " + file + " could not list the content.";
            ex = new DirectoryHasNoContentException(error);
        }
        return ex;
    }

    public static void delete(Collection<File> files) throws IOException {
        for (File file : files) {
            DeleteFileExtensions.delete(file);
        }
    }

    public static void delete(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        if (file.isDirectory()) {
            DeleteFileExtensions.deleteAllFiles(file);
        } else {
            String error = null;
            if (!file.delete()) {
                error = "Cannot delete the File " + file.getAbsolutePath() + ".";
                throw new IOException(error);
            }
        }
    }

    public static void deleteAllFiles(File file) throws IOException {
        String error = null;
        if (!file.exists()) {
            return;
        }
        Exception ex = DeleteFileExtensions.checkFile(file);
        if (ex != null) {
            try {
                throw ex;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DeleteFileExtensions.deleteFiles(file);
        if (!file.delete()) {
            error = "Cannot delete the File " + file.getAbsolutePath() + ".";
            throw new IOException(error);
        }
    }

    public static void deleteAllFilesWithSuffix(File file, String theSuffix) throws IOException {
        String filePath = file.getAbsolutePath();
        String[] suffix = new String[]{theSuffix};
        List<File> files = FileSearchExtensions.findFiles(filePath, suffix);
        int fileCount = files.size();
        for (int i = 0; i < fileCount; ++i) {
            DeleteFileExtensions.deleteFile(files.get(i));
        }
    }

    public static void deleteFile(File fileToDelete) throws IOException {
        DeleteFileExtensions.delete(fileToDelete);
    }

    public static void deleteFiles(File file) throws IOException {
        File[] ff = file.listFiles();
        if (ff != null) {
            for (File f : ff) {
                DeleteFileExtensions.delete(f);
            }
        }
    }

    public static void deleteFilesWithFileFilter(File source, FileFilter includeFileFilter) throws FileIsNotADirectoryException, IOException, FileIsSecurityRestrictedException {
        DeleteFileExtensions.deleteFilesWithFileFilter(source, includeFileFilter, null);
    }

    public static void deleteFilesWithFileFilter(File source, FileFilter includeFileFilter, FileFilter excludeFileFilter) throws FileIsNotADirectoryException, IOException, FileIsSecurityRestrictedException {
        if (!source.isDirectory()) {
            throw new FileIsNotADirectoryException("Source file '" + source.getAbsolutePath() + "' is not a directory.");
        }
        File[] includeFilesArray = null != includeFileFilter ? source.listFiles(includeFileFilter) : source.listFiles();
        if (null != includeFilesArray) {
            File[] excludeFilesArray = null;
            List<File> excludeFilesList = null;
            if (null != excludeFileFilter) {
                excludeFilesArray = source.listFiles(excludeFileFilter);
                excludeFilesList = Arrays.asList(excludeFilesArray);
            }
            if (null != excludeFilesList && !excludeFilesList.isEmpty()) {
                for (File element : includeFilesArray) {
                    File currentFile = element;
                    if (excludeFilesList.contains(currentFile)) continue;
                    if (currentFile.isDirectory()) {
                        DeleteFileExtensions.deleteFilesWithFileFilter(currentFile, includeFileFilter, excludeFileFilter);
                        continue;
                    }
                    DeleteFileExtensions.deleteFile(currentFile);
                }
            } else {
                for (File currentFile : includeFilesArray) {
                    if (currentFile.isDirectory()) {
                        DeleteFileExtensions.deleteFilesWithFileFilter(currentFile, includeFileFilter, excludeFileFilter);
                        continue;
                    }
                    DeleteFileExtensions.deleteFile(currentFile);
                }
            }
        } else {
            throw new FileIsSecurityRestrictedException("File '" + source.getAbsolutePath() + "' is security restricted.");
        }
    }

    public static void deleteFilesWithFilenameFilter(File source, FilenameFilter includeFilenameFilter) throws FileIsNotADirectoryException, IOException, FileIsSecurityRestrictedException {
        DeleteFileExtensions.deleteFilesWithFilenameFilter(source, includeFilenameFilter, null);
    }

    public static void deleteFilesWithFilenameFilter(File source, FilenameFilter includeFilenameFilter, FilenameFilter excludeFilenameFilter) throws FileIsNotADirectoryException, IOException, FileIsSecurityRestrictedException {
        if (!source.isDirectory()) {
            throw new FileIsNotADirectoryException("Source file '" + source.getAbsolutePath() + "' is not a directory.");
        }
        File[] includeFilesArray = null != includeFilenameFilter ? source.listFiles(includeFilenameFilter) : source.listFiles();
        if (null != includeFilesArray) {
            File[] excludeFilesArray = null;
            List<File> excludeFilesList = null;
            if (null != excludeFilenameFilter) {
                excludeFilesArray = source.listFiles(excludeFilenameFilter);
                excludeFilesList = Arrays.asList(excludeFilesArray);
            }
            if (null != excludeFilesList && !excludeFilesList.isEmpty()) {
                for (File element : includeFilesArray) {
                    File currentFile = element;
                    if (excludeFilesList.contains(currentFile)) continue;
                    if (currentFile.isDirectory()) {
                        DeleteFileExtensions.deleteFilesWithFilenameFilter(currentFile, includeFilenameFilter, excludeFilenameFilter);
                        continue;
                    }
                    DeleteFileExtensions.deleteFile(currentFile);
                }
            } else {
                for (File currentFile : includeFilesArray) {
                    if (currentFile.isDirectory()) {
                        DeleteFileExtensions.deleteFilesWithFilenameFilter(currentFile, includeFilenameFilter, excludeFilenameFilter);
                        continue;
                    }
                    DeleteFileExtensions.deleteFile(currentFile);
                }
            }
        } else {
            throw new FileIsSecurityRestrictedException("File '" + source.getAbsolutePath() + "' is security restricted.");
        }
    }

    private DeleteFileExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

