/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.webjars.collectors;

import de.agilecoders.wicket.webjars.collectors.ProtocolAwareAssetPathCollector;
import de.agilecoders.wicket.webjars.util.WebJarAssetLocator;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;

public class JarAssetPathCollector
extends ProtocolAwareAssetPathCollector {
    public JarAssetPathCollector() {
        super("jar");
    }

    protected JarAssetPathCollector(String ... protocols) {
        super(protocols);
    }

    @Override
    public Collection<String> collect(URL url, Pattern filterExpr) {
        JarFile jarFile = this.newJarFile(url);
        HashSet<String> assetPaths = new HashSet<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String assetPathCandidate = entry.getName();
            if (entry.isDirectory() || !filterExpr.matcher(assetPathCandidate).matches()) continue;
            assetPaths.add(assetPathCandidate);
        }
        return assetPaths;
    }

    protected JarFile newJarFile(URL url) {
        try {
            String path = url.getPath();
            File file = new File(URI.create(path.substring(0, path.indexOf("!"))));
            return new JarFile(file);
        }
        catch (IOException e) {
            throw new WebJarAssetLocator.ResourceException(url.toString(), e.getMessage());
        }
    }
}

