/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.jquery;

import com.google.common.base.Function;
import de.agilecoders.wicket.jquery.Attr;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.IFunction;
import de.agilecoders.wicket.jquery.util.CharSequenceWrapper;
import de.agilecoders.wicket.jquery.util.Generics2;
import de.agilecoders.wicket.jquery.util.Strings2;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.string.Strings;

public class JQuery
implements IClusterable {
    private static final Function<IFunction, String> FUNCTION_TRANSFORMER = new Function<IFunction, String>(){

        public String apply(IFunction function) {
            return function != null ? function.build() : null;
        }
    };
    private final Attr selector;
    private final List<IFunction> functions;

    public static Attr quoted(CharSequence value) {
        if (!Strings.isEmpty((CharSequence)value)) {
            return new Attr.Quoted(value);
        }
        return Attr.nullValue();
    }

    public static Attr plain(CharSequence value) {
        if (!Strings.isEmpty((CharSequence)value)) {
            return new Attr.Plain(value);
        }
        return Attr.nullValue();
    }

    public static Attr.MarkupId markupId(Component component) {
        return new Attr.MarkupId(component);
    }

    public static Attr.MarkupId markupId(CharSequence markupId) {
        return new Attr.MarkupId(markupId);
    }

    public static Attr auto(Object value) {
        if (value instanceof Attr) {
            return (Attr)value;
        }
        if (value != null) {
            return new Attr.Auto(value);
        }
        return Attr.nullValue();
    }

    public static JQuery $(CharSequence selector) {
        return new JQuery(JQuery.quoted(selector));
    }

    public static JQuery $(Attr selector) {
        if (selector instanceof Attr.MarkupId) {
            return new JQuery(((Attr.MarkupId)selector).quoted());
        }
        return new JQuery(selector);
    }

    public static JQuery $(Component component) {
        return JQuery.$(JQuery.markupId(component));
    }

    public static JQuery $(Component component, CharSequence ... additionalSelector) {
        ArrayList<Object> selectors = Generics2.newArrayList(new Object[0]);
        selectors.add(JQuery.markupId(component));
        if (additionalSelector != null) {
            for (CharSequence selector : additionalSelector) {
                selectors.add(JQuery.plain(selector));
            }
        }
        return JQuery.$(Generics2.join(selectors, ' '));
    }

    public static JQuery $(Component component, Attr ... additionalSelector) {
        ArrayList<Object> selector = Generics2.newArrayList(new Object[0]);
        selector.add(JQuery.markupId(component));
        if (additionalSelector != null) {
            selector.addAll(Generics2.newArrayList(additionalSelector));
        }
        return JQuery.$(Generics2.join(selector, ' '));
    }

    private JQuery(Attr selector) {
        this.selector = selector;
        this.functions = Generics2.newArrayList(new Object[0]);
    }

    public JQuery chain(IFunction function) {
        this.functions.add(function);
        return this;
    }

    public JQuery on(CharSequence events, JavaScriptInlineFunction handler) {
        return this.chain(OnJqueryFunction.on(events, handler));
    }

    public JQuery on(CharSequence events, CharSequence selector, JavaScriptInlineFunction handler) {
        return this.on(JQuery.quoted(events), JQuery.quoted(selector), handler);
    }

    public JQuery on(Attr events, Attr selector, JavaScriptInlineFunction handler) {
        return this.chain(OnJqueryFunction.on(events, selector, handler));
    }

    public JQuery on(Attr events, JavaScriptInlineFunction handler) {
        return this.on(events, Attr.nullValue(), handler);
    }

    public JQuery closest(CharSequence selector) {
        return this.closest(JQuery.quoted(selector));
    }

    public JQuery closest(Attr selector) {
        return this.chain(ClosestJqueryFunction.closest(selector));
    }

    public JQuery chain(CharSequence functionName) {
        this.functions.add(new SimpleFunction(functionName));
        return this;
    }

    public String get() {
        return this.build() + ";";
    }

    public String build() {
        return "$(" + this.selector + ")" + this.createFunctionString();
    }

    public OnDomReadyHeaderItem asDomReadyScript() {
        return OnDomReadyHeaderItem.forScript((CharSequence)this.get());
    }

    private String createFunctionString() {
        return this.functions.isEmpty() ? "" : "." + Generics2.join(Generics2.transform(this.functions, FUNCTION_TRANSFORMER), '.');
    }

    public JQuery chain(CharSequence functionName, Config config, Config ... extraConfigs) {
        this.functions.add(new ConfigurableFunction(functionName, config, extraConfigs));
        return this;
    }

    public static abstract class AbstractFunction
    implements IFunction {
        private final CharSequence functionName;
        private final List<CharSequence> parameters;

        protected AbstractFunction(CharSequence functionName) {
            this.functionName = functionName;
            this.parameters = Generics2.newArrayList(new Object[0]);
        }

        @Override
        public String build() {
            return this.functionName + "(" + this.buildParameters() + ")";
        }

        protected final char getSeparator() {
            return ',';
        }

        protected String buildParameters() {
            return Generics2.join(this.parameters, this.getSeparator());
        }

        protected final void addParameter(CharSequence parameter) {
            this.parameters.add(parameter);
        }

        protected final CharSequence toParameterValue(Object value) {
            return CharSequenceWrapper.toParameterValue(value);
        }

        protected final CharSequence toParameterValue(JavaScriptInlineFunction value) {
            return CharSequenceWrapper.toParameterValue(value);
        }

        protected final CharSequence toParameterValue(Long value) {
            return CharSequenceWrapper.toParameterValue(value);
        }

        protected final CharSequence toParameterValue(Integer value) {
            return CharSequenceWrapper.toParameterValue(value);
        }

        protected final CharSequence toParameterValue(Float value) {
            return CharSequenceWrapper.toParameterValue(value);
        }

        protected final CharSequence toParameterValue(Boolean value) {
            return CharSequenceWrapper.toParameterValue(value);
        }
    }

    public static final class OnJqueryFunction
    extends AbstractFunction {
        public static OnJqueryFunction on(Attr events, JavaScriptInlineFunction handler) {
            return new OnJqueryFunction(events, Attr.nullValue(), null, handler);
        }

        public static OnJqueryFunction on(CharSequence events, JavaScriptInlineFunction handler) {
            return new OnJqueryFunction(JQuery.quoted(events), Attr.nullValue(), Attr.nullValue(), handler);
        }

        public static OnJqueryFunction on(Attr events, Attr selector, JavaScriptInlineFunction handler) {
            return OnJqueryFunction.on(events, selector, Attr.nullValue(), handler);
        }

        public static OnJqueryFunction on(Attr events, Attr selector, Attr data, JavaScriptInlineFunction handler) {
            return new OnJqueryFunction(events, selector, data, handler);
        }

        public static OnJqueryFunction on(Attr events, Attr selector, Object data, JavaScriptInlineFunction handler) {
            return OnJqueryFunction.on(events, selector, JQuery.auto(data), handler);
        }

        public static OnJqueryFunction on(CharSequence events, CharSequence selector, JavaScriptInlineFunction handler) {
            return OnJqueryFunction.on(JQuery.quoted(events), JQuery.quoted(selector), Attr.nullValue(), handler);
        }

        public static OnJqueryFunction on(CharSequence events, CharSequence selector, Object data, JavaScriptInlineFunction handler) {
            return new OnJqueryFunction(JQuery.quoted(events), JQuery.quoted(selector), JQuery.auto(data), handler);
        }

        protected OnJqueryFunction(Attr events, Attr selector, Attr data, JavaScriptInlineFunction handler) {
            super("on");
            this.addParameter(events);
            if (!Attr.isNullOrEmpty(selector)) {
                this.addParameter(selector);
            }
            if (!Attr.isNullOrEmpty(data)) {
                if (Attr.isNullOrEmpty(selector)) {
                    this.addParameter(Attr.nullValue());
                }
                this.addParameter(data);
            }
            handler.addParameter("evt");
            this.addParameter(this.toParameterValue(handler));
        }
    }

    public static final class ClosestJqueryFunction
    extends AbstractFunction {
        public static ClosestJqueryFunction closest(Attr selector) {
            return new ClosestJqueryFunction(selector);
        }

        public static ClosestJqueryFunction closest(CharSequence selector) {
            return ClosestJqueryFunction.closest(JQuery.quoted(selector));
        }

        protected ClosestJqueryFunction(Attr selector) {
            super("closest");
            this.addParameter(selector);
        }
    }

    public static final class EachJqueryFunction
    extends AbstractFunction {
        public static EachJqueryFunction each(JavaScriptInlineFunction function) {
            return new EachJqueryFunction(function);
        }

        protected EachJqueryFunction(JavaScriptInlineFunction function) {
            super("each");
            this.addParameter(this.toParameterValue(function));
        }
    }

    public static final class ConfigurableFunction
    extends AbstractFunction {
        protected ConfigurableFunction(CharSequence functionName, Config config) {
            this(functionName, config, null);
        }

        protected ConfigurableFunction(CharSequence functionName, Config config, Config ... extraConfigs) {
            super(functionName);
            if (extraConfigs != null && extraConfigs.length > 0) {
                this.addParameter(config.toJsonString());
                for (Config extraConfig : extraConfigs) {
                    this.addParameter(extraConfig.toJsonString());
                }
            } else if (!config.isEmpty()) {
                this.addParameter(config.toJsonString());
            }
        }
    }

    public static final class SimpleFunction
    extends AbstractFunction {
        protected SimpleFunction(CharSequence functionName) {
            super(functionName);
        }
    }

    public static class JavaScriptInlineFunction
    extends AbstractFunction {
        private final String functionBody;

        public JavaScriptInlineFunction(String functionBody) {
            super("function");
            this.functionBody = Strings2.nullToEmpty(functionBody);
        }

        @Override
        public String build() {
            return super.build() + "{" + this.functionBody + "}";
        }

        public boolean equals(Object o) {
            if (o instanceof JavaScriptInlineFunction) {
                return this.functionBody.equals(((JavaScriptInlineFunction)o).functionBody);
            }
            if (o instanceof String) {
                return this.functionBody.equals(o);
            }
            return false;
        }

        public int hashCode() {
            return this.functionBody.hashCode();
        }

        public String toString() {
            return this.functionBody;
        }

        public static String toString(JavaScriptInlineFunction value) {
            return value != null ? value.toString() : "null";
        }
    }
}

