/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.security;

import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.internal.util.Base64;
import com.taobao.api.internal.util.LruHashMap;
import com.taobao.api.internal.util.NamedThreadFactory;
import com.taobao.api.internal.util.StringUtils;
import com.taobao.api.security.SecretContext;
import com.taobao.api.security.SecretData;
import com.taobao.api.security.TopSecretGetRequest;
import com.taobao.api.security.TopSecretGetResponse;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SecurityCore {
    private static final Log log = LogFactory.getLog(SecurityCore.class);
    private String randomNum;
    private static final LruHashMap<String, SecretContext> appUserSecretCache = new LruHashMap(16, 131072);
    private static SecretContext appSecretContext;
    private ExecutorService asynUpdateSecret;
    private DefaultTaobaoClient defaultTaobaoClient;
    private Set<String> asynQueneKey = new HashSet<String>();
    private ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public SecurityCore(DefaultTaobaoClient defaultTaobaoClient, String randomNum, int corePoolSize, int maxPoolSize, int maxQueue) {
        this.defaultTaobaoClient = defaultTaobaoClient;
        this.randomNum = randomNum;
        this.init(corePoolSize, maxPoolSize, maxQueue);
    }

    private void init(int corePoolSize, int maxPoolSize, int maxQueue) {
        if (corePoolSize <= 0 || maxPoolSize <= 0 || maxQueue <= 0 || corePoolSize > maxPoolSize) {
            throw new IllegalArgumentException("param error");
        }
        this.asynUpdateSecret = new ThreadPoolExecutor(corePoolSize, maxPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxQueue), new NamedThreadFactory("taobao sdk asyn update secret", true), new ThreadPoolExecutor.AbortPolicy());
    }

    public void setRandomNum(String randomNum) {
        this.randomNum = randomNum;
    }

    public SecretContext getSecret(String session, Long secretVersion) throws ApiException {
        SecretContext secretContext = this.getSecret(this.generateSecretKey(session, secretVersion));
        if (secretContext != null) {
            if (secretContext.isValid()) {
                return secretContext;
            }
            if (secretContext.isMaxValid()) {
                this.asynUpdateSecret(session, secretVersion);
                return secretContext;
            }
            return this.callSecretApi(session, secretVersion);
        }
        return this.callSecretApi(session, secretVersion);
    }

    private String generateSecretKey(String session, Long secretVersion) {
        if (secretVersion == null) {
            return session;
        }
        return session + "_" + secretVersion;
    }

    private SecretContext getSecret(String session) {
        SecretContext secretContext = session != null ? appUserSecretCache.get(session) : appSecretContext;
        return secretContext;
    }

    private SecretContext callSecretApi(String session, Long secretVersion) throws ApiException {
        if (StringUtils.isEmpty(this.randomNum)) {
            throw new IllegalArgumentException("randomNum can`t be empty");
        }
        TopSecretGetRequest request = new TopSecretGetRequest();
        request.setRandomNum(this.randomNum);
        request.setSecretVersion(secretVersion);
        TopSecretGetResponse response = this.defaultTaobaoClient.execute(request, session);
        if (response.isSuccess() && response.getSecret() != null) {
            SecretContext secretContext = new SecretContext();
            long currentTime = System.currentTimeMillis();
            secretContext.setInvalidTime(currentTime + response.getInterval() * 1000L);
            secretContext.setMaxInvalidTime(currentTime + response.getMaxInterval() * 1000L);
            secretContext.setSecret(Base64.decode(response.getSecret()));
            secretContext.setSecretVersion(response.getSecretVersion());
            if (session != null) {
                appUserSecretCache.put(this.generateSecretKey(session, secretVersion), secretContext);
            } else {
                appSecretContext = secretContext;
            }
            return secretContext;
        }
        throw new ApiException("error_code=" + response.getErrorCode() + ",error_msg=" + response.getMsg());
    }

    private void asynUpdateSecret(final String session, final Long secretVersion) {
        final String cacheKey = this.generateSecretKey(session, secretVersion);
        if (this.readWriteLock.writeLock().tryLock()) {
            try {
                if (this.asynQueneKey.contains(cacheKey)) {
                    return;
                }
                this.asynQueneKey.add(cacheKey);
                this.asynUpdateSecret.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            SecurityCore.this.callSecretApi(session, secretVersion);
                        }
                        catch (ApiException e) {
                            if (log.isErrorEnabled()) {
                                log.error((Object)"asyn update secret error", (Throwable)e);
                            }
                        }
                        finally {
                            if (SecurityCore.this.readWriteLock.writeLock().tryLock()) {
                                SecurityCore.this.asynQueneKey.remove(cacheKey);
                                SecurityCore.this.readWriteLock.writeLock().unlock();
                            }
                        }
                    }
                });
            }
            catch (RuntimeException e) {
                this.asynQueneKey.remove(cacheKey);
                throw e;
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }

    public SecretData getSecretData(String data, char separatorChar) {
        SecretData secretData = new SecretData();
        if ('$' == separatorChar) {
            for (int i = data.length() - 2; i > 1; --i) {
                char value = data.charAt(i);
                if (separatorChar != value) continue;
                int phonePrefixIndex = data.indexOf(separatorChar, 1);
                if (phonePrefixIndex != i) {
                    secretData.setPrefixValue(data.substring(1, phonePrefixIndex));
                    secretData.setOriginalBase64Value(data.substring(phonePrefixIndex + 1, i));
                }
                secretData.setSecretVersion(Long.valueOf(data.substring(i + 1, data.length() - 1)));
                break;
            }
        } else {
            for (int i = data.length() - 2; i > 1; --i) {
                char value = data.charAt(i);
                if (separatorChar != value) continue;
                secretData.setOriginalBase64Value(data.substring(1, i));
                secretData.setSecretVersion(Long.valueOf(data.substring(i + 1, data.length() - 1)));
                break;
            }
        }
        return secretData;
    }
}

