/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.security;

import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.SecretException;
import com.taobao.api.internal.util.StringUtils;
import com.taobao.api.internal.util.TaobaoUtils;
import com.taobao.api.security.SecretContext;
import com.taobao.api.security.SecretData;
import com.taobao.api.security.SecurityCore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityClient {
    public static final String NICK = "nick";
    public static final String PHONE = "phone";
    public static final String NORMAL = "normal";
    public static final char NICK_SEPARATOR_CHAR = '~';
    public static final String NICK_SEPARATOR = String.valueOf('~');
    public static final char PHONE_SEPARATOR_CHAR = '$';
    public static final String PHONE_SEPARATOR = String.valueOf('$');
    public static final char NORMAL_SEPARATOR_CHAR = '\u0001';
    public static final String NORMAL_SEPARATOR = String.valueOf('\u0001');
    private SecurityCore secretCore;

    public SecurityClient(DefaultTaobaoClient defaultTaobaoClient, String randomNum) {
        this(defaultTaobaoClient, randomNum, 2, 8, Integer.MAX_VALUE);
    }

    public SecurityClient(DefaultTaobaoClient defaultTaobaoClient, String randomNum, int corePoolSize, int maxPoolSize, int maxQueue) {
        this.secretCore = new SecurityCore(defaultTaobaoClient, randomNum, corePoolSize, maxPoolSize, maxQueue);
    }

    public void initSecret() throws ApiException {
        this.secretCore.getSecret(null, null);
    }

    public void setRandomNum(String randomNum) {
        this.secretCore.setRandomNum(randomNum);
    }

    public void initSecret(String session) throws ApiException {
        this.secretCore.getSecret(session, null);
    }

    public Map<String, String> decrypt(List<String> dataList, String type) throws SecretException {
        return this.decrypt(dataList, type, null);
    }

    public Map<String, String> decrypt(List<String> dataList, String type, String session) throws SecretException {
        if (dataList == null || dataList.isEmpty()) {
            throw new SecretException("dataList can`t be empty");
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (String data : dataList) {
            String decryptValue = this.decrypt(data, type, session);
            resultMap.put(data, decryptValue);
        }
        return resultMap;
    }

    public String decrypt(String data, String type) throws SecretException {
        return this.decrypt(data, type, null);
    }

    public String decrypt(String data, String type, String session) throws SecretException {
        if (StringUtils.isEmpty(data) || data.length() < 4) {
            return data;
        }
        SecretData secretDataDO = null;
        if (NICK.equals(type)) {
            if (!data.startsWith(NICK_SEPARATOR) || !data.endsWith(NICK_SEPARATOR)) {
                return data;
            }
            secretDataDO = this.secretCore.getSecretData(data, '~');
        } else if (PHONE.equals(type)) {
            if (!data.startsWith(PHONE_SEPARATOR) || !data.endsWith(PHONE_SEPARATOR)) {
                return data;
            }
            secretDataDO = this.secretCore.getSecretData(data, '$');
        } else if (NORMAL.equals(type)) {
            if (!data.startsWith(NORMAL_SEPARATOR) || !data.endsWith(NORMAL_SEPARATOR)) {
                return data;
            }
            secretDataDO = this.secretCore.getSecretData(data, '\u0001');
        } else {
            throw new SecretException("type error");
        }
        try {
            SecretContext secretContextDO = this.secretCore.getSecret(session, secretDataDO.getSecretVersion());
            String decryptValue = TaobaoUtils.aesDecrypt(secretDataDO.getOriginalBase64Value(), secretContextDO.getSecret());
            if (PHONE.equals(type)) {
                return secretDataDO.getPrefixValue() + decryptValue;
            }
            return decryptValue;
        }
        catch (ApiException e) {
            throw new SecretException("get secret error", e);
        }
    }

    public static boolean isEncryptData(List<String> dataList, String type) throws SecretException {
        if (dataList == null || dataList.isEmpty()) {
            return false;
        }
        boolean result = false;
        for (String data : dataList) {
            result = SecurityClient.isEncryptData(data, type);
            if (result) continue;
            return false;
        }
        return result;
    }

    public static boolean isEncryptData(String data, String type) throws SecretException {
        if (StringUtils.isEmpty(data) || data.length() < 4) {
            return false;
        }
        if (NICK.equals(type)) {
            if (data.startsWith(NICK_SEPARATOR) && data.endsWith(NICK_SEPARATOR)) {
                return true;
            }
        } else if (PHONE.equals(type)) {
            if (data.startsWith(PHONE_SEPARATOR) && data.endsWith(PHONE_SEPARATOR)) {
                return true;
            }
        } else if (NORMAL.equals(type)) {
            if (data.startsWith(NORMAL_SEPARATOR) && data.endsWith(NORMAL_SEPARATOR)) {
                return true;
            }
        } else {
            throw new SecretException("type error");
        }
        return false;
    }

    public String encrypt(String data, String type) throws SecretException {
        return this.encrypt(data, type, null);
    }

    public String encrypt(String data, String type, String session) throws SecretException {
        if (StringUtils.isEmpty(data)) {
            return data;
        }
        try {
            SecretContext secretContext = this.secretCore.getSecret(session, null);
            if (secretContext == null) {
                throw new SecretException("secretKey is null");
            }
            if (NICK.equals(type)) {
                return NICK_SEPARATOR + TaobaoUtils.aesEncrypt(data, secretContext.getSecret()) + NICK_SEPARATOR + secretContext.getSecretVersion() + NICK_SEPARATOR;
            }
            if (PHONE.equals(type)) {
                if (data.length() < 11) {
                    throw new SecretException("phoneNumber error");
                }
                String prefixNumber = data.substring(0, data.length() - 8);
                String last8Number = data.substring(data.length() - 8);
                return PHONE_SEPARATOR + prefixNumber + PHONE_SEPARATOR + TaobaoUtils.aesEncrypt(last8Number, secretContext.getSecret()) + PHONE_SEPARATOR + secretContext.getSecretVersion() + PHONE_SEPARATOR;
            }
            if (NORMAL.equals(type)) {
                return NORMAL_SEPARATOR + TaobaoUtils.aesEncrypt(data, secretContext.getSecret()) + NORMAL_SEPARATOR + secretContext.getSecretVersion() + NORMAL_SEPARATOR;
            }
            throw new SecretException("type error");
        }
        catch (ApiException e) {
            throw new SecretException("get secret error", e);
        }
    }

    public Map<String, String> encrypt(List<String> dataList, String type) throws SecretException {
        return this.encrypt(dataList, type, null);
    }

    public Map<String, String> encrypt(List<String> dataList, String type, String session) throws SecretException {
        if (dataList == null || dataList.isEmpty()) {
            throw new SecretException("dataList can`t be empty");
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (String data : dataList) {
            String encryptValue = this.encrypt(data, type, session);
            resultMap.put(data, encryptValue);
        }
        return resultMap;
    }
}

