/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.tmc;

import com.taobao.api.internal.tmc.DuplicateRemoverTmcHandler;
import com.taobao.api.internal.tmc.KeySelector;
import com.taobao.api.internal.tmc.Message;
import com.taobao.api.internal.tmc.MessageHandler;
import com.taobao.api.internal.tmc.MessageKind;
import com.taobao.api.internal.tmc.MixClient;
import com.taobao.api.internal.tmc.TmcHandler;
import com.taobao.api.internal.tmc.TmcIdentity;
import com.taobao.api.internal.toplink.LinkException;
import com.taobao.api.internal.util.NamedThreadFactory;
import com.taobao.api.internal.util.StringUtils;
import com.taobao.api.internal.util.TaobaoUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TmcClient {
    private static final Log log = LogFactory.getLog(TmcClient.class);
    private static final String TIMESTAMP = "timestamp";
    private static final String APP_KEY = "app_key";
    private static final String GROUP_NAME = "group_name";
    private static final String INTRANET_IP = "intranet_ip";
    private static final String SIGN = "sign";
    private static final String SDK = "sdk";
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private InnerClient client;
    private MessageHandler messageHandler;
    private TmcHandler tmcHandler;
    private ThreadPoolExecutor threadPool;
    private ThreadPoolExecutor confirmThreadPool = null;
    private int queueSize = 2000;
    private int threadCount = Runtime.getRuntime().availableProcessors() * 10;
    private int confirmThreadCount = 4;
    private int fetchPeriod = 15;
    private int reconnectInterval = 10000;
    private int heartbeatInterval = 45000;
    private boolean removeDuplicate = false;
    private boolean useDefaultConfirm = true;
    private KeySelector keySelector;
    private Timer fetchTimer;
    private TimerTask fetchTimerTask;
    private String uri;
    private String appKey;
    private String groupName;

    public TmcClient(String appKey, String appSecret) {
        this(appKey, appSecret, "default");
    }

    public TmcClient(String appKey, String appSecret, String groupName) {
        this("ws://mc.api.taobao.com/", appKey, appSecret, groupName);
    }

    public TmcClient(String uri, String appKey, String appSecret, String groupName) {
        this.uri = uri;
        this.appKey = appKey;
        this.groupName = groupName;
        this.client = new InnerClient(new TmcIdentity(appKey, groupName));
        this.client.appKey = appKey;
        this.client.appSecret = appSecret;
        this.client.groupName = groupName;
    }

    protected void setUri(String uri) {
        this.uri = uri;
    }

    protected String getAppKey() {
        return this.appKey;
    }

    protected String getGroupName() {
        return this.groupName;
    }

    protected InnerClient getClient() {
        return this.client;
    }

    protected ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    public ThreadPoolExecutor getConfirmThreadPool() {
        return this.confirmThreadPool;
    }

    protected MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(MessageHandler handler) {
        this.messageHandler = handler;
    }

    protected TmcHandler getTmcHandler() {
        return this.tmcHandler;
    }

    protected int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        if (queueSize < this.threadCount) {
            throw new IllegalArgumentException("queue size must greater than thread count");
        }
        this.queueSize = queueSize;
    }

    public void setThreadCount(int threadCount) {
        if (threadCount < 1) {
            throw new IllegalArgumentException("thread count must greater than 1");
        }
        this.threadCount = threadCount;
    }

    public void setConfirmThreadCount(int threadCount) {
        if (threadCount < 1) {
            throw new IllegalArgumentException("thread count must greater than 1");
        }
        this.confirmThreadCount = threadCount;
    }

    public void setFetchPeriod(int fetchPeriod) {
        if (fetchPeriod < 1) {
            throw new IllegalArgumentException("fetch period must greater than 1");
        }
        this.fetchPeriod = fetchPeriod;
    }

    public void setRemoveDuplicate(boolean removeDuplicate) {
        this.removeDuplicate = removeDuplicate;
    }

    protected KeySelector getKeySelector() {
        return this.keySelector;
    }

    public void setKeySelector(KeySelector keySelector) {
        this.keySelector = keySelector;
    }

    public void connect() throws LinkException {
        this.connect(false);
    }

    public void connect(String uri) throws LinkException {
        this.connect(uri, false);
    }

    public void connect(String uri, boolean async) throws LinkException {
        this.uri = uri;
        this.connect(async);
    }

    private void connect(boolean async) throws LinkException {
        if (!this.connected.compareAndSet(false, true)) {
            return;
        }
        this.tmcHandler = this.removeDuplicate ? new DuplicateRemoverTmcHandler(this) : new TmcHandler(this);
        this.client.setMessageHandler(this.tmcHandler);
        this.threadPool = new ThreadPoolExecutor(this.threadCount, this.threadCount, this.fetchPeriod * 2, TimeUnit.MICROSECONDS, new ArrayBlockingQueue<Runnable>(this.queueSize), new NamedThreadFactory("tmc-worker"), new ThreadPoolExecutor.AbortPolicy());
        try {
            this.client.connect(this.uri, async);
        }
        catch (LinkException e) {
            this.connected.set(false);
            throw e;
        }
        this.doPullRequest();
    }

    public void send(String topic, String content) throws LinkException {
        if (StringUtils.isEmpty(topic)) {
            throw new LinkException("topic is required");
        }
        if (StringUtils.isEmpty(content)) {
            throw new LinkException("content is required");
        }
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("__kind", MessageKind.Data);
        msg.put("topic", topic);
        msg.put("content", content);
        this.client.sendAndWait(msg, 2000);
    }

    public void send(String topic, String content, String session) throws LinkException {
        if (StringUtils.isEmpty(topic)) {
            throw new LinkException("topic is required");
        }
        if (StringUtils.isEmpty(content)) {
            throw new LinkException("content is required");
        }
        if (StringUtils.isEmpty(session)) {
            throw new LinkException("session is required");
        }
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("__kind", MessageKind.Data);
        msg.put("topic", topic);
        msg.put("content", content);
        msg.put("session", session);
        this.client.sendAndWait(msg, 2000);
    }

    public void manualConfirm(Message message) {
        this.tmcHandler.handleConfirm(message);
    }

    public void retryMessage(Message message) throws RejectedExecutionException {
        this.tmcHandler.retryMessage(message);
    }

    public void close() {
        this.close("tmc client closed");
    }

    public void close(String reason) {
        this.stopPullRequest();
        if (this.tmcHandler != null) {
            this.tmcHandler.close();
        }
        if (this.threadPool != null) {
            this.threadPool.shutdown();
            this.threadPool = null;
        }
        if (this.confirmThreadPool != null) {
            this.confirmThreadPool.shutdown();
            this.confirmThreadPool = null;
        }
        this.client.disconnect(reason);
        this.client.close();
        this.connected.set(false);
        log.warn((Object)"tmc client closed");
    }

    public boolean isOnline() {
        return this.client != null && this.client.isOnline();
    }

    protected void pullRequest() {
        try {
            HashMap<String, Object> msg = new HashMap<String, Object>();
            msg.put("__kind", MessageKind.PullRequest);
            if (this.client.isOnline()) {
                this.client.send(msg);
            }
        }
        catch (Exception e) {
            log.warn((Object)"pull request error", (Throwable)e);
        }
    }

    private void doPullRequest() {
        this.stopPullRequest();
        this.fetchTimerTask = new TimerTask(){

            public void run() {
                TmcClient.this.pullRequest();
            }
        };
        Date begin = new Date();
        begin.setTime(begin.getTime() + (long)this.fetchPeriod * 1000L);
        this.fetchTimer = new Timer("tmc-pull", true);
        this.fetchTimer.schedule(this.fetchTimerTask, begin, (long)this.fetchPeriod * 1000L);
    }

    private void stopPullRequest() {
        if (this.fetchTimer != null) {
            this.fetchTimer.cancel();
            this.fetchTimer = null;
        }
    }

    public boolean isUseDefaultConfirm() {
        return this.useDefaultConfirm;
    }

    public void setUseDefaultConfirm(boolean useDefaultConfirm) throws InterruptedException {
        if (!useDefaultConfirm && this.confirmThreadPool == null) {
            this.confirmThreadPool = new ThreadPoolExecutor(this.confirmThreadCount, this.confirmThreadCount, this.fetchPeriod * 2, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.queueSize), new NamedThreadFactory("tmc-confirm-worker"), new ThreadPoolExecutor.AbortPolicy());
        }
        if (useDefaultConfirm && this.confirmThreadPool != null) {
            this.confirmThreadPool.awaitTermination(30L, TimeUnit.SECONDS);
        }
        this.useDefaultConfirm = useDefaultConfirm;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InnerClient
    extends MixClient {
        private String appKey;
        private String appSecret;
        private String groupName;

        public InnerClient(TmcIdentity id) {
            super(id, TmcClient.this.reconnectInterval, TmcClient.this.heartbeatInterval);
        }

        @Override
        protected Map<String, Object> createConnectHeaders() {
            HashMap<String, String> signHeader = new HashMap<String, String>();
            signHeader.put(TmcClient.TIMESTAMP, String.valueOf(System.currentTimeMillis()));
            signHeader.put(TmcClient.APP_KEY, this.appKey);
            signHeader.put(TmcClient.GROUP_NAME, this.groupName);
            try {
                signHeader.put(TmcClient.SIGN, TaobaoUtils.signTopRequest(signHeader, null, this.appSecret, "md5"));
            }
            catch (Exception e) {
                log.error((Object)"tmc sign error", (Throwable)e);
            }
            HashMap<String, Object> requestHeader = new HashMap<String, Object>();
            requestHeader.putAll(signHeader);
            requestHeader.put(TmcClient.SDK, "top-sdk-java-20160413");
            requestHeader.put(TmcClient.INTRANET_IP, TaobaoUtils.getIntranetIp());
            return requestHeader;
        }
    }
}

