/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.parser.xml;

import com.taobao.api.ApiException;
import com.taobao.api.internal.mapping.Converter;
import com.taobao.api.internal.mapping.Converters;
import com.taobao.api.internal.mapping.Reader;
import com.taobao.api.internal.util.StringUtils;
import com.taobao.api.internal.util.XmlUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlConverter
implements Converter {
    @Override
    public <T> T toResponse(String rsp, Class<T> clazz) throws ApiException {
        Element root = XmlUtils.getRootElementFromString(rsp);
        return this.getModelFromXML(root, clazz);
    }

    private <T> T getModelFromXML(final Element element, Class<T> clazz) throws ApiException {
        if (element == null) {
            return null;
        }
        return Converters.convert(clazz, new Reader(){

            @Override
            public boolean hasReturnField(Object name) {
                Element childE = XmlUtils.getChildElement(element, (String)name);
                return childE != null;
            }

            @Override
            public Object getPrimitiveObject(Object name) {
                return XmlUtils.getChildElementValue(element, (String)name);
            }

            @Override
            public Object getObject(Object name, Class<?> type) throws ApiException {
                Element childE = XmlUtils.getChildElement(element, (String)name);
                if (childE != null) {
                    return XmlConverter.this.getModelFromXML(childE, type);
                }
                return null;
            }

            @Override
            public List<?> getListObjects(Object listName, Object itemName, Class<?> subType) throws ApiException {
                ArrayList<String> list = null;
                Element listE = XmlUtils.getChildElement(element, (String)listName);
                if (listE != null) {
                    list = new ArrayList<String>();
                    List<Element> itemEs = XmlUtils.getChildElements(listE, (String)itemName);
                    for (Element itemE : itemEs) {
                        Object obj = null;
                        String value = XmlUtils.getElementValue(itemE);
                        obj = String.class.isAssignableFrom(subType) ? value : (Long.class.isAssignableFrom(subType) ? Long.valueOf(value) : (Integer.class.isAssignableFrom(subType) ? Integer.valueOf(value) : (Boolean.class.isAssignableFrom(subType) ? Boolean.valueOf(value) : (Date.class.isAssignableFrom(subType) ? StringUtils.parseDateTime(value) : XmlConverter.this.getModelFromXML(itemE, subType)))));
                        if (obj == null) continue;
                        list.add((String)obj);
                    }
                }
                return list;
            }
        });
    }
}

