/*
 * Decompiled with CFR 0.152.
 */
package com.purgeteam.dynamic.config.starter.event;

import com.purgeteam.dynamic.config.starter.event.ActionConfigEvent;
import com.purgeteam.dynamic.config.starter.util.PropertyUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySources;

public class DynamicConfigApplicationListener
implements ApplicationListener<RefreshEvent>,
ApplicationContextAware,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(DynamicConfigApplicationListener.class);
    private ContextRefresher refresh;
    private ApplicationContext context;
    private PropertyUtil propertyUtil;

    public DynamicConfigApplicationListener(ContextRefresher contextRefresher) {
        this.refresh = contextRefresher;
    }

    public DynamicConfigApplicationListener(ContextRefresher contextRefresher, PropertyUtil propertyUtil) {
        this.refresh = contextRefresher;
        this.propertyUtil = propertyUtil;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    public void onApplicationEvent(RefreshEvent event) {
        ConfigurableEnvironment beforeEnv = (ConfigurableEnvironment)this.context.getEnvironment();
        MutablePropertySources propertySources = beforeEnv.getPropertySources();
        MutablePropertySources beforeSources = new MutablePropertySources((PropertySources)propertySources);
        Set refresh = this.refresh.refresh();
        Map<String, HashMap> contrast = this.propertyUtil.contrast(beforeSources, propertySources);
        this.context.publishEvent((ApplicationEvent)new ActionConfigEvent(this, "Refresh config", contrast));
        log.info("[ActionApplicationListener] The update is successful {}", (Object)refresh);
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }
}

