/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.consistency;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public interface Serializer {
    public static final Map<String, Class<?>> CLASS_CACHE = new ConcurrentHashMap(8);

    public <T> T deserialize(byte[] var1, Class var2);

    default public <T> T deserialize(byte[] data, String classFullName) {
        try {
            CLASS_CACHE.computeIfAbsent(classFullName, name -> {
                try {
                    return Class.forName(classFullName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            });
            Class<?> cls = CLASS_CACHE.get(classFullName);
            return this.deserialize(data, cls);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public <T> byte[] serialize(T var1);

    public String name();
}

