/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.core.utils.SystemUtils;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class PropertyUtil {
    private static final Logger logger = LogUtil.defaultLog;
    private static int notifyConnectTimeout = 100;
    private static int notifySocketTimeout = 200;
    private static int maxHealthCheckFailCount = 12;
    private static boolean isHealthCheck = true;
    private static int maxContent = 0xA00000;
    private static boolean isManageCapacity = true;
    private static boolean isCapacityLimitCheck = false;
    private static int defaultClusterQuota = 100000;
    private static int defaultGroupQuota = 200;
    private static int defaultTenantQuota = 200;
    private static int defaultMaxSize = 102400;
    private static int defaultMaxAggrCount = 10000;
    private static int defaultMaxAggrSize = 1024;
    private static int initialExpansionPercent = 100;
    private static int correctUsageDelay = 600;
    private static boolean standaloneUseMysql = false;
    @Autowired
    private Environment env;

    @PostConstruct
    public void init() {
        try {
            PropertyUtil.setNotifyConnectTimeout(Integer.parseInt(this.env.getProperty("notifyConnectTimeout", "100")));
            logger.info("notifyConnectTimeout:{}", (Object)notifyConnectTimeout);
            PropertyUtil.setNotifySocketTimeout(Integer.parseInt(this.env.getProperty("notifySocketTimeout", "200")));
            logger.info("notifySocketTimeout:{}", (Object)notifySocketTimeout);
            PropertyUtil.setHealthCheck(Boolean.valueOf(this.env.getProperty("isHealthCheck", "true")));
            logger.info("isHealthCheck:{}", (Object)isHealthCheck);
            PropertyUtil.setMaxHealthCheckFailCount(Integer.parseInt(this.env.getProperty("maxHealthCheckFailCount", "12")));
            logger.info("maxHealthCheckFailCount:{}", (Object)maxHealthCheckFailCount);
            PropertyUtil.setMaxContent(Integer.parseInt(this.env.getProperty("maxContent", String.valueOf(maxContent))));
            logger.info("maxContent:{}", (Object)maxContent);
            PropertyUtil.setManageCapacity(this.getBoolean("isManageCapacity", isManageCapacity));
            PropertyUtil.setCapacityLimitCheck(this.getBoolean("isCapacityLimitCheck", isCapacityLimitCheck));
            PropertyUtil.setDefaultClusterQuota(this.getInt("defaultClusterQuota", defaultClusterQuota));
            PropertyUtil.setDefaultGroupQuota(this.getInt("defaultGroupQuota", defaultGroupQuota));
            PropertyUtil.setDefaultTenantQuota(this.getInt("defaultTenantQuota", defaultTenantQuota));
            PropertyUtil.setDefaultMaxSize(this.getInt("defaultMaxSize", defaultMaxSize));
            PropertyUtil.setDefaultMaxAggrCount(this.getInt("defaultMaxAggrCount", defaultMaxAggrCount));
            PropertyUtil.setDefaultMaxAggrSize(this.getInt("defaultMaxAggrSize", defaultMaxAggrSize));
            PropertyUtil.setCorrectUsageDelay(this.getInt("correctUsageDelay", correctUsageDelay));
            PropertyUtil.setInitialExpansionPercent(this.getInt("initialExpansionPercent", initialExpansionPercent));
            PropertyUtil.setStandaloneUseMysql(this.getString("spring.datasource.platform", "").equals("mysql"));
        }
        catch (Exception e) {
            logger.error("read application.properties failed", (Throwable)e);
        }
    }

    public static int getNotifyConnectTimeout() {
        return notifyConnectTimeout;
    }

    public static int getNotifySocketTimeout() {
        return notifySocketTimeout;
    }

    public static int getMaxHealthCheckFailCount() {
        return maxHealthCheckFailCount;
    }

    public static boolean isHealthCheck() {
        return isHealthCheck;
    }

    private boolean getBoolean(String key, boolean defaultValue) {
        return Boolean.valueOf(this.getString(key, String.valueOf(defaultValue)));
    }

    private int getInt(String key, int defaultValue) {
        return Integer.parseInt(this.getString(key, String.valueOf(defaultValue)));
    }

    private String getString(String key, String defaultValue) {
        String value = this.env.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        logger.info("{}:{}", (Object)key, (Object)value);
        return value;
    }

    public String getProperty(String key) {
        return this.env.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.env.getProperty(key, defaultValue);
    }

    public static int getMaxContent() {
        return maxContent;
    }

    public static boolean isManageCapacity() {
        return isManageCapacity;
    }

    public static int getDefaultClusterQuota() {
        return defaultClusterQuota;
    }

    public static boolean isCapacityLimitCheck() {
        return isCapacityLimitCheck;
    }

    public static int getDefaultGroupQuota() {
        return defaultGroupQuota;
    }

    public static int getDefaultTenantQuota() {
        return defaultTenantQuota;
    }

    public static int getInitialExpansionPercent() {
        return initialExpansionPercent;
    }

    public static int getDefaultMaxSize() {
        return defaultMaxSize;
    }

    public static int getDefaultMaxAggrCount() {
        return defaultMaxAggrCount;
    }

    public static int getDefaultMaxAggrSize() {
        return defaultMaxAggrSize;
    }

    public static int getCorrectUsageDelay() {
        return correctUsageDelay;
    }

    public static boolean isStandaloneMode() {
        return SystemUtils.STANDALONE_MODE;
    }

    public static boolean isStandaloneUseMysql() {
        return standaloneUseMysql;
    }

    public static void setNotifyConnectTimeout(int notifyConnectTimeout) {
        PropertyUtil.notifyConnectTimeout = notifyConnectTimeout;
    }

    public static void setNotifySocketTimeout(int notifySocketTimeout) {
        PropertyUtil.notifySocketTimeout = notifySocketTimeout;
    }

    public static void setMaxHealthCheckFailCount(int maxHealthCheckFailCount) {
        PropertyUtil.maxHealthCheckFailCount = maxHealthCheckFailCount;
    }

    public static void setHealthCheck(boolean isHealthCheck) {
        PropertyUtil.isHealthCheck = isHealthCheck;
    }

    public static void setMaxContent(int maxContent) {
        PropertyUtil.maxContent = maxContent;
    }

    public static void setManageCapacity(boolean isManageCapacity) {
        PropertyUtil.isManageCapacity = isManageCapacity;
    }

    public static void setCapacityLimitCheck(boolean isCapacityLimitCheck) {
        PropertyUtil.isCapacityLimitCheck = isCapacityLimitCheck;
    }

    public static void setDefaultClusterQuota(int defaultClusterQuota) {
        PropertyUtil.defaultClusterQuota = defaultClusterQuota;
    }

    public static void setDefaultGroupQuota(int defaultGroupQuota) {
        PropertyUtil.defaultGroupQuota = defaultGroupQuota;
    }

    public static void setDefaultTenantQuota(int defaultTenantQuota) {
        PropertyUtil.defaultTenantQuota = defaultTenantQuota;
    }

    public static void setDefaultMaxSize(int defaultMaxSize) {
        PropertyUtil.defaultMaxSize = defaultMaxSize;
    }

    public static void setDefaultMaxAggrCount(int defaultMaxAggrCount) {
        PropertyUtil.defaultMaxAggrCount = defaultMaxAggrCount;
    }

    public static void setDefaultMaxAggrSize(int defaultMaxAggrSize) {
        PropertyUtil.defaultMaxAggrSize = defaultMaxAggrSize;
    }

    public static void setInitialExpansionPercent(int initialExpansionPercent) {
        PropertyUtil.initialExpansionPercent = initialExpansionPercent;
    }

    public static void setCorrectUsageDelay(int correctUsageDelay) {
        PropertyUtil.correctUsageDelay = correctUsageDelay;
    }

    public static void setStandaloneUseMysql(boolean standaloneUseMysql) {
        PropertyUtil.standaloneUseMysql = standaloneUseMysql;
    }
}

