/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.notify;

import com.alibaba.nacos.config.server.manager.TaskManager;
import com.alibaba.nacos.config.server.service.ServerListService;
import com.alibaba.nacos.config.server.service.notify.NotifyTaskProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class NotifyService {
    public static final String NOTIFY_HEADER_LAST_MODIFIED = "lastModified";
    public static final String NOTIFY_HEADER_OP_HANDLE_IP = "opHandleIp";
    static final int TIMEOUT = 500;
    private TaskManager notifyTaskManager;

    @Autowired
    public NotifyService(ServerListService serverListService) {
        this.notifyTaskManager = new TaskManager("com.alibaba.nacos.NotifyTaskManager");
        this.notifyTaskManager.setDefaultTaskProcessor(new NotifyTaskProcessor(serverListService));
    }

    protected NotifyService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult invokeURL(String url, List<String> headers, String encoding) throws IOException {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setConnectTimeout(500);
            conn.setReadTimeout(500);
            conn.setRequestMethod("GET");
            if (null != headers && !StringUtils.isEmpty((CharSequence)encoding)) {
                Iterator<String> iter = headers.iterator();
                while (iter.hasNext()) {
                    conn.addRequestProperty(iter.next(), iter.next());
                }
            }
            conn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + encoding);
            conn.connect();
            int respCode = conn.getResponseCode();
            String resp = null;
            resp = 200 == respCode ? IOUtils.toString((InputStream)conn.getInputStream()) : IOUtils.toString((InputStream)conn.getErrorStream());
            HttpResult httpResult = new HttpResult(respCode, resp);
            return httpResult;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static class HttpResult {
        public final int code;
        public final String content;

        public HttpResult(int code, String content) {
            this.code = code;
            this.content = content;
        }
    }
}

