/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump;

import com.alibaba.nacos.config.server.manager.AbstractTask;
import com.alibaba.nacos.config.server.manager.TaskProcessor;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo4Beta;
import com.alibaba.nacos.config.server.model.ConfigInfo4Tag;
import com.alibaba.nacos.config.server.service.AggrWhitelist;
import com.alibaba.nacos.config.server.service.ClientIpWhiteList;
import com.alibaba.nacos.config.server.service.ConfigService;
import com.alibaba.nacos.config.server.service.SwitchService;
import com.alibaba.nacos.config.server.service.dump.DumpService;
import com.alibaba.nacos.config.server.service.dump.DumpTask;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import org.apache.commons.lang3.StringUtils;

class DumpProcessor
implements TaskProcessor {
    final DumpService dumpService;

    DumpProcessor(DumpService dumpService) {
        this.dumpService = dumpService;
    }

    @Override
    public boolean process(String taskType, AbstractTask task) {
        boolean result;
        DumpTask dumpTask = (DumpTask)task;
        String[] pair = GroupKey2.parseKey(dumpTask.groupKey);
        String dataId = pair[0];
        String group = pair[1];
        String tenant = pair[2];
        long lastModified = dumpTask.lastModified;
        String handleIp = dumpTask.handleIp;
        boolean isBeta = dumpTask.isBeta;
        String tag = dumpTask.tag;
        if (isBeta) {
            boolean result2;
            ConfigInfo4Beta cf = this.dumpService.persistService.findConfigInfo4Beta(dataId, group, tenant);
            if (null != cf) {
                result2 = ConfigService.dumpBeta(dataId, group, tenant, cf.getContent(), lastModified, cf.getBetaIps());
                if (result2) {
                    ConfigTraceService.logDumpEvent(dataId, group, tenant, null, lastModified, handleIp, "ok", System.currentTimeMillis() - lastModified, cf.getContent().length());
                }
            } else {
                result2 = ConfigService.removeBeta(dataId, group, tenant);
                if (result2) {
                    ConfigTraceService.logDumpEvent(dataId, group, tenant, null, lastModified, handleIp, "remove-ok", System.currentTimeMillis() - lastModified, 0L);
                }
            }
            return result2;
        }
        if (StringUtils.isBlank((CharSequence)tag)) {
            boolean result3;
            ConfigInfo cf = this.dumpService.persistService.findConfigInfo(dataId, group, tenant);
            if (dataId.equals("com.alibaba.nacos.metadata.aggrIDs")) {
                if (null != cf) {
                    AggrWhitelist.load(cf.getContent());
                } else {
                    AggrWhitelist.load(null);
                }
            }
            if (dataId.equals("com.alibaba.nacos.metadata.clientIpWhitelist")) {
                if (null != cf) {
                    ClientIpWhiteList.load(cf.getContent());
                } else {
                    ClientIpWhiteList.load(null);
                }
            }
            if (dataId.equals("com.alibaba.nacos.meta.switch")) {
                if (null != cf) {
                    SwitchService.load(cf.getContent());
                } else {
                    SwitchService.load(null);
                }
            }
            if (null != cf) {
                result3 = ConfigService.dump(dataId, group, tenant, cf.getContent(), lastModified);
                if (result3) {
                    ConfigTraceService.logDumpEvent(dataId, group, tenant, null, lastModified, handleIp, "ok", System.currentTimeMillis() - lastModified, cf.getContent().length());
                }
            } else {
                result3 = ConfigService.remove(dataId, group, tenant);
                if (result3) {
                    ConfigTraceService.logDumpEvent(dataId, group, tenant, null, lastModified, handleIp, "remove-ok", System.currentTimeMillis() - lastModified, 0L);
                }
            }
            return result3;
        }
        ConfigInfo4Tag cf = this.dumpService.persistService.findConfigInfo4Tag(dataId, group, tenant, tag);
        if (null != cf) {
            result = ConfigService.dumpTag(dataId, group, tenant, tag, cf.getContent(), lastModified);
            if (result) {
                ConfigTraceService.logDumpEvent(dataId, group, tenant, null, lastModified, handleIp, "ok", System.currentTimeMillis() - lastModified, cf.getContent().length());
            }
        } else {
            result = ConfigService.removeTag(dataId, group, tenant, tag);
            if (result) {
                ConfigTraceService.logDumpEvent(dataId, group, tenant, null, lastModified, handleIp, "remove-ok", System.currentTimeMillis() - lastModified, 0L);
            }
        }
        return result;
    }
}

