/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.config.server.monitor.MetricsMonitor;
import com.alibaba.nacos.config.server.service.DataSourceService;
import com.alibaba.nacos.config.server.service.PersistService;
import com.alibaba.nacos.config.server.service.TimerTaskService;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.core.utils.SystemUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Service(value="basicDataSourceService")
public class BasicDataSourceServiceImpl
implements DataSourceService {
    private static final Logger log = LoggerFactory.getLogger(BasicDataSourceServiceImpl.class);
    private static final String DEFAULT_MYSQL_DRIVER = "com.mysql.jdbc.Driver";
    private static final String MYSQL_HIGH_LEVEL_DRIVER = "com.mysql.cj.jdbc.Driver";
    private static String JDBC_DRIVER_NAME;
    private int queryTimeout = 3;
    private static final int TRANSACTION_QUERY_TIMEOUT = 5;
    private static final String DB_LOAD_ERROR_MSG = "[db-load-error]load jdbc.properties error";
    private List<BasicDataSource> dataSourceList = new ArrayList<BasicDataSource>();
    private JdbcTemplate jt;
    private DataSourceTransactionManager tm;
    private TransactionTemplate tjt;
    private JdbcTemplate testMasterJT;
    private JdbcTemplate testMasterWritableJT;
    private volatile List<JdbcTemplate> testJTList;
    private volatile List<Boolean> isHealthList;
    private volatile int masterIndex;
    private static Pattern ipPattern;
    @Autowired
    private Environment env;

    @PostConstruct
    public void init() {
        this.queryTimeout = NumberUtils.toInt((String)System.getProperty("QUERYTIMEOUT"), (int)3);
        this.jt = new JdbcTemplate();
        this.jt.setMaxRows(50000);
        this.jt.setQueryTimeout(this.queryTimeout);
        this.testMasterJT = new JdbcTemplate();
        this.testMasterJT.setQueryTimeout(this.queryTimeout);
        this.testMasterWritableJT = new JdbcTemplate();
        this.testMasterWritableJT.setQueryTimeout(1);
        this.testJTList = new ArrayList<JdbcTemplate>();
        this.isHealthList = new ArrayList<Boolean>();
        this.tm = new DataSourceTransactionManager();
        this.tjt = new TransactionTemplate((PlatformTransactionManager)this.tm);
        this.tjt.setTimeout(5);
        if (!SystemUtils.STANDALONE_MODE || PropertyUtil.isStandaloneUseMysql()) {
            try {
                this.reload();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(DB_LOAD_ERROR_MSG);
            }
            TimerTaskService.scheduleWithFixedDelay(new SelectMasterTask(), 10L, 10L, TimeUnit.SECONDS);
            TimerTaskService.scheduleWithFixedDelay(new CheckDBHealthTask(), 10L, 10L, TimeUnit.SECONDS);
        }
    }

    @Override
    public synchronized void reload() throws IOException {
        ArrayList<BasicDataSource> dblist = new ArrayList<BasicDataSource>();
        try {
            String val = null;
            val = this.env.getProperty("db.num");
            if (null == val) {
                throw new IllegalArgumentException("db.num is null");
            }
            int dbNum = Integer.parseInt(val.trim());
            for (int i = 0; i < dbNum; ++i) {
                BasicDataSource ds = new BasicDataSource();
                ds.setDriverClassName(JDBC_DRIVER_NAME);
                val = this.env.getProperty("db.url." + i);
                if (null == val) {
                    LogUtil.fatalLog.error("db.url." + i + " is null");
                    throw new IllegalArgumentException();
                }
                ds.setUrl(val.trim());
                val = this.env.getProperty("db.user." + i, this.env.getProperty("db.user"));
                if (null == val) {
                    LogUtil.fatalLog.error("db.user." + i + " is null");
                    throw new IllegalArgumentException();
                }
                ds.setUsername(val.trim());
                val = this.env.getProperty("db.password." + i, this.env.getProperty("db.password"));
                if (null == val) {
                    LogUtil.fatalLog.error("db.password." + i + " is null");
                    throw new IllegalArgumentException();
                }
                ds.setPassword(val.trim());
                val = this.env.getProperty("db.initialSize." + i, this.env.getProperty("db.initialSize"));
                ds.setInitialSize(Integer.parseInt(BasicDataSourceServiceImpl.defaultIfNull(val, "10")));
                val = this.env.getProperty("db.maxActive." + i, this.env.getProperty("db.maxActive"));
                ds.setMaxActive(Integer.parseInt(BasicDataSourceServiceImpl.defaultIfNull(val, "20")));
                val = this.env.getProperty("db.maxIdle." + i, this.env.getProperty("db.maxIdle"));
                ds.setMaxIdle(Integer.parseInt(BasicDataSourceServiceImpl.defaultIfNull(val, "50")));
                ds.setMaxWait(3000L);
                ds.setPoolPreparedStatements(true);
                ds.setTimeBetweenEvictionRunsMillis(TimeUnit.MINUTES.toMillis(10L));
                ds.setTestWhileIdle(true);
                ds.setValidationQuery("SELECT 1 FROM dual");
                dblist.add(ds);
                JdbcTemplate jdbcTemplate = new JdbcTemplate();
                jdbcTemplate.setQueryTimeout(this.queryTimeout);
                jdbcTemplate.setDataSource((DataSource)ds);
                this.testJTList.add(jdbcTemplate);
                this.isHealthList.add(Boolean.TRUE);
            }
            if (dblist == null || dblist.size() == 0) {
                throw new RuntimeException("no datasource available");
            }
            this.dataSourceList = dblist;
            new SelectMasterTask().run();
            new CheckDBHealthTask().run();
        }
        catch (RuntimeException e) {
            LogUtil.fatalLog.error(DB_LOAD_ERROR_MSG, (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public boolean checkMasterWritable() {
        this.testMasterWritableJT.setDataSource(this.jt.getDataSource());
        this.testMasterWritableJT.setQueryTimeout(1);
        String sql = " SELECT @@read_only ";
        try {
            Integer result = (Integer)this.testMasterWritableJT.queryForObject(sql, Integer.class);
            if (result == null) {
                return false;
            }
            return result == 0;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.fatalLog.error("[db-error] " + e.toString(), (Throwable)e);
            return false;
        }
    }

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jt;
    }

    @Override
    public TransactionTemplate getTransactionTemplate() {
        return this.tjt;
    }

    @Override
    public String getCurrentDBUrl() {
        DataSource ds = this.jt.getDataSource();
        if (ds == null) {
            return "";
        }
        BasicDataSource bds = (BasicDataSource)ds;
        return bds.getUrl();
    }

    @Override
    public String getHealth() {
        for (int i = 0; i < this.isHealthList.size(); ++i) {
            if (this.isHealthList.get(i).booleanValue()) continue;
            if (i == this.masterIndex) {
                return "DOWN:" + this.getIpFromUrl(this.dataSourceList.get(i).getUrl());
            }
            return "WARN:" + this.getIpFromUrl(this.dataSourceList.get(i).getUrl());
        }
        return "UP";
    }

    private String getIpFromUrl(String url) {
        Matcher m = ipPattern.matcher(url);
        if (m.find()) {
            return m.group();
        }
        return "";
    }

    static String defaultIfNull(String value, String defaultValue) {
        return null == value ? defaultValue : value;
    }

    static {
        ipPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
        try {
            Class.forName(MYSQL_HIGH_LEVEL_DRIVER);
            JDBC_DRIVER_NAME = MYSQL_HIGH_LEVEL_DRIVER;
            log.info("Use Mysql 8 as the driver");
        }
        catch (ClassNotFoundException e) {
            log.info("Use Mysql as the driver");
            JDBC_DRIVER_NAME = DEFAULT_MYSQL_DRIVER;
        }
    }

    class CheckDBHealthTask
    implements Runnable {
        CheckDBHealthTask() {
        }

        @Override
        public void run() {
            if (LogUtil.defaultLog.isDebugEnabled()) {
                LogUtil.defaultLog.debug("check db health.");
            }
            String sql = "SELECT * FROM config_info_beta WHERE id = 1";
            for (int i = 0; i < BasicDataSourceServiceImpl.this.testJTList.size(); ++i) {
                JdbcTemplate jdbcTemplate = (JdbcTemplate)BasicDataSourceServiceImpl.this.testJTList.get(i);
                try {
                    jdbcTemplate.query(sql, (RowMapper)PersistService.CONFIG_INFO4BETA_ROW_MAPPER);
                    BasicDataSourceServiceImpl.this.isHealthList.set(i, Boolean.TRUE);
                    continue;
                }
                catch (DataAccessException e) {
                    if (i == BasicDataSourceServiceImpl.this.masterIndex) {
                        LogUtil.fatalLog.error("[db-error] master db {} down.", (Object)BasicDataSourceServiceImpl.this.getIpFromUrl(((BasicDataSource)BasicDataSourceServiceImpl.this.dataSourceList.get(i)).getUrl()));
                    } else {
                        LogUtil.fatalLog.error("[db-error] slave db {} down.", (Object)BasicDataSourceServiceImpl.this.getIpFromUrl(((BasicDataSource)BasicDataSourceServiceImpl.this.dataSourceList.get(i)).getUrl()));
                    }
                    BasicDataSourceServiceImpl.this.isHealthList.set(i, Boolean.FALSE);
                    MetricsMonitor.getDbException().increment();
                }
            }
        }
    }

    class SelectMasterTask
    implements Runnable {
        SelectMasterTask() {
        }

        @Override
        public void run() {
            if (LogUtil.defaultLog.isDebugEnabled()) {
                LogUtil.defaultLog.debug("check master db.");
            }
            boolean isFound = false;
            int index = -1;
            for (BasicDataSource ds : BasicDataSourceServiceImpl.this.dataSourceList) {
                ++index;
                BasicDataSourceServiceImpl.this.testMasterJT.setDataSource((DataSource)ds);
                BasicDataSourceServiceImpl.this.testMasterJT.setQueryTimeout(BasicDataSourceServiceImpl.this.queryTimeout);
                try {
                    BasicDataSourceServiceImpl.this.testMasterJT.update("DELETE FROM config_info WHERE data_id='com.alibaba.nacos.testMasterDB'");
                    if (BasicDataSourceServiceImpl.this.jt.getDataSource() != ds) {
                        LogUtil.fatalLog.warn("[master-db] {}", (Object)ds.getUrl());
                    }
                    BasicDataSourceServiceImpl.this.jt.setDataSource((DataSource)ds);
                    BasicDataSourceServiceImpl.this.tm.setDataSource((DataSource)ds);
                    isFound = true;
                    BasicDataSourceServiceImpl.this.masterIndex = index;
                    break;
                }
                catch (DataAccessException e) {
                    e.printStackTrace();
                }
            }
            if (!isFound) {
                LogUtil.fatalLog.error("[master-db] master db not found.");
                MetricsMonitor.getDbException().increment();
            }
        }
    }
}

