/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.config.server.service.PersistService;
import com.alibaba.nacos.config.server.service.dump.DumpService;
import com.alibaba.nacos.config.server.utils.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/cs/ops"})
public class OpsController {
    private static final Logger log = LoggerFactory.getLogger(OpsController.class);
    protected final PersistService persistService;
    private final DumpService dumpService;

    @Autowired
    public OpsController(PersistService persistService, DumpService dumpService) {
        this.persistService = persistService;
        this.dumpService = dumpService;
    }

    @PostMapping(value={"/localCache"})
    public String updateLocalCacheFromStore() {
        log.info("start to dump all data from store.");
        this.dumpService.dumpAll();
        log.info("finish to dump all data from store.");
        return "200";
    }

    @PutMapping(value={"/log"})
    public String setLogLevel(@RequestParam String logName, @RequestParam String logLevel) {
        LogUtil.setLogLevel(logName, logLevel);
        return "200";
    }
}

