/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.authorization;

import com.mangofactory.swagger.models.dto.Authorization;
import com.mangofactory.swagger.scanners.RegexRequestMappingPatternMatcher;
import com.mangofactory.swagger.scanners.RequestMappingPatternMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;

public class AuthorizationContext {
    private final List<Authorization> authorizations;
    private final RequestMappingPatternMatcher requestMappingPatternMatcher;
    private final List<String> includePatterns;
    private final RequestMethod[] requestMethods;

    private AuthorizationContext(AuthorizationContextBuilder builder) {
        this.authorizations = builder.authorizations;
        this.includePatterns = builder.includePatterns;
        this.requestMappingPatternMatcher = builder.requestMappingPatternMatcher;
        this.requestMethods = builder.requestMethods;
    }

    public List<Authorization> getAuthorizationsForPath(String path) {
        if (this.requestMappingPatternMatcher.pathMatchesOneOfIncluded(path, this.includePatterns)) {
            return this.authorizations;
        }
        return null;
    }

    public List<Authorization> getAuthorizations() {
        return this.authorizations;
    }

    public List<Authorization> getScalaAuthorizations() {
        return CollectionUtils.isEmpty(this.authorizations) ? new ArrayList() : this.authorizations;
    }

    public static class AuthorizationContextBuilder {
        private List<Authorization> authorizations;
        private RequestMappingPatternMatcher requestMappingPatternMatcher = new RegexRequestMappingPatternMatcher();
        private List<String> includePatterns = Arrays.asList(".*?");
        private RequestMethod[] requestMethods = RequestMethod.values();

        public AuthorizationContextBuilder(List<Authorization> authorizations) {
            this.authorizations = authorizations;
        }

        public AuthorizationContextBuilder withRequestMappingPatternMatcher(RequestMappingPatternMatcher matcher) {
            this.requestMappingPatternMatcher = matcher;
            return this;
        }

        public AuthorizationContextBuilder withIncludePatterns(List<String> includePatterns) {
            this.includePatterns = includePatterns;
            return this;
        }

        public AuthorizationContextBuilder withRequestMethods(RequestMethod[] requestMethods) {
            this.requestMethods = requestMethods;
            return this;
        }

        public AuthorizationContext build() {
            return new AuthorizationContext(this);
        }
    }
}

