/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.auth.web.shiro.util;

import com.jxwk.auth.business.dao.entity.SysUser;
import com.jxwk.auth.web.shiro.ShiroUser;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroUserUtils {
    private static final Logger logger = LoggerFactory.getLogger(ShiroUserUtils.class);

    public static ShiroUser getCurrentShiroUser() {
        Object obj = ShiroUserUtils.getSubject().getPrincipal();
        if (obj == null) {
            return null;
        }
        return (ShiroUser)obj;
    }

    public static SysUser getCurrentSysUser() {
        ShiroUser shiroUser = ShiroUserUtils.getCurrentShiroUser();
        if (shiroUser == null) {
            return null;
        }
        return shiroUser.getSysUser();
    }

    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static boolean isAuthenticated() {
        return ShiroUserUtils.getSubject().isAuthenticated();
    }

    public static Session getSession() {
        return ShiroUserUtils.getSubject().getSession();
    }

    public static void clearCachedAuthenticationInfo(String loginName) {
        if (StringUtils.isBlank((CharSequence)loginName)) {
            return;
        }
        try {
            RealmSecurityManager securityManager = (RealmSecurityManager)SecurityUtils.getSecurityManager();
            CacheManager manager = securityManager.getCacheManager();
            securityManager.logout(ShiroUserUtils.getSubject());
            Cache cache = manager.getCache("ncbqs_admin_shiroAuthorizationCache");
            cache.clear();
        }
        catch (UnavailableSecurityManagerException e) {
            logger.error("\u6e05\u9664\u7528\u6237\u8ba4\u8bc1\u4fe1\u606f\u51fa\u9519", (Throwable)e);
        }
        catch (CacheException e) {
            logger.error("\u6e05\u9664\u7528\u6237\u8ba4\u8bc1\u4fe1\u606f\u51fa\u9519", (Throwable)e);
        }
    }
}

