/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.auth.web.controller;

import com.jxwk.auth.business.biz.SysRoleBiz;
import com.jxwk.auth.business.biz.SysUserBiz;
import com.jxwk.auth.business.dao.entity.SysUser;
import com.jxwk.auth.business.pagination.Page;
import com.jxwk.auth.business.pagination.PageRequest;
import com.jxwk.auth.web.controller.BaseController;
import com.jxwk.auth.web.controller.result.FailMsg;
import com.jxwk.auth.web.controller.result.SuccessMsg;
import com.jxwk.auth.web.resolver.annotation.GridParam;
import com.jxwk.auth.web.shiro.util.ShiroUserUtils;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="authSysUserController")
@RequestMapping(value={"/user"})
public class SysUserController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(SysUserController.class);
    @Autowired
    private SysUserBiz sysUserBiz;
    @Autowired
    private SysRoleBiz sysRoleBiz;

    @RequestMapping
    public String index() {
        return "user/list";
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public Page<Map<String, Object>> list(String userName, String realName, String mobile, String userType, @GridParam PageRequest pageRequest) {
        return this.sysUserBiz.findUserList(userName, realName, mobile, userType, pageRequest);
    }

    @RequestMapping(value={"/add"})
    public String add() {
        return "user/add";
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    public Object save(@RequestParam(required=true) String userName, @RequestParam(required=true) String mobile, @RequestParam(required=true) String password, @RequestParam(required=true) String realName, @RequestParam(required=true) String roleId) {
        try {
            SysUser oUser = this.sysUserBiz.findByUsername(userName);
            if (oUser != null) {
                return new FailMsg("\u7528\u6237\u5df2\u5b58\u5728", null);
            }
            int uSize = this.sysUserBiz.countUserByMobile(mobile);
            if (uSize > 0) {
                return new FailMsg("\u8054\u7cfb\u7535\u8bdd\u5df2\u5b58\u5728", null);
            }
            SysUser user = new SysUser();
            user.setPassword(password);
            user.setUserName(userName);
            user.setLocked(false);
            user.setMobile(mobile);
            user.setRealName(realName);
            user.setRoleId(roleId);
            this.sysUserBiz.insert(user);
            return new SuccessMsg("\u4fdd\u5b58\u6210\u529f", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new FailMsg("\u4fdd\u5b58\u5931\u8d25", null);
        }
    }

    @RequestMapping(value={"/edit"})
    public String edit(Integer id, HttpServletRequest request) {
        SysUser sysUser = this.sysUserBiz.selectByPrimaryKey(id);
        request.setAttribute("sysUser", (Object)sysUser);
        return "user/edit";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @ResponseBody
    public Object update(@RequestParam(required=true) Integer id, @RequestParam(required=true) String mobile, @RequestParam(required=true) String realName, @RequestParam(required=true) String roleId, @RequestParam(required=true) Boolean locked) {
        try {
            int uSize;
            SysUser user = this.sysUserBiz.selectByPrimaryKey(id);
            if (user == null) {
                return new FailMsg("\u7528\u6237\u4e0d\u5b58\u5728", null);
            }
            if (!StringUtils.equals((CharSequence)user.getMobile(), (CharSequence)mobile) && (uSize = this.sysUserBiz.countUserByMobile(mobile)) > 0) {
                return new FailMsg("\u8054\u7cfb\u7535\u8bdd\u5df2\u5b58\u5728", null);
            }
            user.setLocked(locked);
            user.setMobile(mobile);
            user.setRealName(realName);
            user.setRoleId(roleId);
            this.sysUserBiz.updateUser(user);
            return new SuccessMsg("\u4fdd\u5b58\u6210\u529f", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new FailMsg("\u4fdd\u5b58\u5931\u8d25", null);
        }
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Object delete(Integer id) {
        try {
            if (this.sysUserBiz.removeUser(id)) {
                // empty if block
            }
            return new SuccessMsg("\u5220\u9664\u6210\u529f", null);
        }
        catch (Exception e) {
            logger.info("\u5220\u9664\u7528\u6237\u5931\u8d25\uff01");
            return new FailMsg("\u5220\u9664\u5931\u8d25", null);
        }
    }

    @RequestMapping(value={"/getSysUserRoles"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getSysUserRoles(String type) {
        ArrayList<String> userTypes = new ArrayList<String>();
        userTypes.add(type);
        return this.sysRoleBiz.findRolesByUserTypes(userTypes);
    }

    @RequestMapping(value={"/updatePwd"}, method={RequestMethod.POST})
    @ResponseBody
    public Object updatePwd(@RequestParam(required=true) int id) {
        try {
            SysUser user = this.sysUserBiz.selectByPrimaryKey(id);
            SuccessMsg success = new SuccessMsg(this.sysUserBiz.updateRandomPwd(id), null);
            ShiroUserUtils.clearCachedAuthenticationInfo(user.getUserName());
            return success;
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u5bc6\u7801\u51fa\u9519", (Throwable)e);
            return new FailMsg("\u66f4\u65b0\u5bc6\u7801\u51fa\u9519", null);
        }
    }

    @RequestMapping(value={"toChangePwd"})
    public String toChangePwd() {
        return "user/changePwd";
    }

    @RequestMapping(value={"changePwd"})
    @ResponseBody
    public Object changePwd(HttpServletRequest request) {
        FailMsg msg = new FailMsg("\u4fee\u6539\u5bc6\u7801\u5931\u8d25");
        SysUser su = ShiroUserUtils.getCurrentSysUser();
        String oldPwd = request.getParameter("oldPwd");
        String newPwd = request.getParameter("newPwd");
        if (StringUtils.isNotBlank((CharSequence)"oldPwd") && StringUtils.isNotBlank((CharSequence)newPwd)) {
            String _oldPwd = SysUserController.encryptPwd(oldPwd);
            if (_oldPwd.equals(su.getPassword())) {
                if (this.sysUserBiz.updatePwd(su.getId(), newPwd) > 0) {
                    ShiroUserUtils.clearCachedAuthenticationInfo(su.getUserName());
                    return new SuccessMsg("\u4fee\u6539\u5bc6\u7801\u6210\u529f\uff01", null);
                }
                logger.info("\u7528\u6237 [" + su.getUserName() + "]\u4fee\u6539\u5bc6\u7801\u5931\u8d25\uff01");
                msg.setMsg("\u5bc6\u7801\u4fee\u6539\u5931\u8d25\uff01");
            } else {
                msg.setMsg("\u539f\u5bc6\u7801\u9519\u8bef\uff01");
            }
        } else {
            msg.setMsg("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return msg;
    }
}

