/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.auth.web.controller;

import com.jxwk.auth.business.biz.SysResourceBiz;
import com.jxwk.auth.business.biz.SysRoleBiz;
import com.jxwk.auth.business.biz.SysUserBiz;
import com.jxwk.auth.business.dao.entity.SysRole;
import com.jxwk.auth.business.enums.UserTypeEnum;
import com.jxwk.auth.business.pagination.Page;
import com.jxwk.auth.business.pagination.PageRequest;
import com.jxwk.auth.web.controller.result.FailMsg;
import com.jxwk.auth.web.controller.result.SuccessMsg;
import com.jxwk.auth.web.resolver.annotation.GridParam;
import com.jxwk.auth.web.shiro.util.ShiroUserUtils;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller(value="authSysRoleController")
@RequestMapping(value={"/role"})
public class SysRoleController {
    private static final Logger logger = LoggerFactory.getLogger(SysRoleController.class);
    @Autowired
    private SysRoleBiz sysRoleBiz;
    @Autowired
    private SysResourceBiz sysResourceBiz;
    @Autowired
    private SysUserBiz sysUserBiz;

    @RequestMapping
    public String index() {
        return "role/list";
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public Page<SysRole> list(String roleName, String userType, @GridParam PageRequest pageRequest) {
        return this.sysRoleBiz.findPageByNameAndUserType(roleName, userType, pageRequest);
    }

    @RequestMapping(value={"/add"})
    public ModelAndView add() {
        ModelAndView mav = new ModelAndView("role/add");
        mav.addObject("roleId", (Object)ShiroUserUtils.getCurrentSysUser().getRoleId());
        return mav;
    }

    @RequestMapping(value={"/getResources"})
    @ResponseBody
    public Object getResources(Integer roleId) {
        if (roleId == null) {
            return this.sysResourceBiz.findAllResource();
        }
        return this.sysRoleBiz.findResourcesByRoleId(roleId);
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    public Object save(Integer roleId, @RequestParam(required=true) String name, String userType, String ids) {
        ArrayList<String> resourceIds = new ArrayList<String>();
        try {
            CollectionUtils.addAll(resourceIds, (Object[])StringUtils.split((String)ids, (String)","));
            if (roleId == null) {
                this.sysRoleBiz.saveRole(name, userType, resourceIds);
            } else {
                this.sysRoleBiz.updateRole(roleId, name, userType, resourceIds);
            }
            return new SuccessMsg("\u4fdd\u5b58\u6210\u529f", null);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u51fa\u9519", (Throwable)e);
            return new FailMsg("\u4fdd\u5b58\u5931\u8d25", null);
        }
    }

    @RequestMapping(value={"/edit"})
    public String edit(@RequestParam(required=true) Integer roleId, HttpServletRequest request) {
        SysRole role = this.sysRoleBiz.findOneById(roleId);
        for (UserTypeEnum ute : UserTypeEnum.values()) {
            if (!StringUtils.equals((CharSequence)ute.getValue(), (CharSequence)role.getUserType())) continue;
            request.setAttribute("userTypeName", (Object)ute.getName());
        }
        request.setAttribute("role", (Object)role);
        return "role/edit";
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Object delete(@RequestParam(required=true) Integer roleId, HttpServletRequest request) {
        int size = this.sysUserBiz.countSysUserByRoleId(roleId);
        if (size > 0) {
            return new FailMsg("\u8be5\u89d2\u8272\u5df2\u6709\u7ed1\u5b9a\u7528\u6237,\u8bf7\u5148\u89e3\u7ed1", null);
        }
        try {
            this.sysRoleBiz.deleteRoleAndRoleResourceByRoleId(roleId);
            return new SuccessMsg("\u5220\u9664\u6210\u529f", null);
        }
        catch (Exception e) {
            logger.error("{} \u89d2\u8272\u5df2\u6709\u7ed1\u5b9a\u7528\u6237,\u8bf7\u5148\u89e3\u7ed1", (Object)roleId, (Object)e);
            return new FailMsg("\u8be5\u89d2\u8272\u5df2\u6709\u7ed1\u5b9a\u7528\u6237,\u8bf7\u5148\u89e3\u7ed1", null);
        }
    }
}

