/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.auth.web.controller;

import com.jxwk.auth.business.biz.SysUserBiz;
import com.jxwk.auth.business.dao.entity.SysUser;
import com.jxwk.auth.business.util.CaptchaUtils;
import com.jxwk.auth.web.controller.result.FailMsg;
import com.jxwk.auth.web.controller.result.SuccessMsg;
import com.jxwk.auth.web.shiro.util.ShiroUserUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="authMainController")
@RequestMapping
public class MainController {
    @Value(value="${login.style}")
    private String loginStyle;
    @Value(value="${admin.frame.style}")
    private String adminFrameStyle;
    @Autowired
    private SysUserBiz userBiz;

    @RequestMapping
    public String main() {
        if (ShiroUserUtils.isAuthenticated()) {
            return "redirect:/index";
        }
        return "redirect:/login";
    }

    @RequestMapping(value={"/login"})
    public String login(HttpServletRequest request, HttpServletResponse response) {
        String msg = (String)request.getAttribute("shiroLoginFailure");
        if (StringUtils.length((CharSequence)msg) >= 15) {
            request.setAttribute("errorMsg", (Object)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        } else {
            request.setAttribute("errorMsg", (Object)msg);
        }
        if (!SecurityUtils.getSubject().isAuthenticated()) {
            response.setStatus(901);
            return "system/login/theme/" + this.loginStyle + "/login";
        }
        return "redirect:index";
    }

    @RequestMapping(value={"/welcome"})
    public String welcome() {
        return "welcome";
    }

    @RequestMapping(value={"/menus"})
    @ResponseBody
    public Object menus() {
        return ShiroUserUtils.getCurrentShiroUser().getMenus();
    }

    @RequestMapping(value={"/get-captcha"})
    public void getCaptcha(HttpSession session, HttpServletResponse response) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.IMAGE_JPEG);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String captcha = CaptchaUtils.getCaptcha(70, 32, 4, outputStream).toLowerCase();
        session.setAttribute("captcha", (Object)captcha);
        byte[] bs = outputStream.toByteArray();
        ServletOutputStream os = response.getOutputStream();
        os.write(bs);
        outputStream.close();
        os.flush();
    }

    @RequestMapping(value={"/index"})
    public String index() {
        return "system/frame/theme/" + this.adminFrameStyle + "/index";
    }

    @RequestMapping(value={"/workbench"})
    public String workbench() {
        return "system/frame/theme/" + this.adminFrameStyle + "/workbench";
    }

    @RequestMapping(value={"/unauthorized"})
    public String unauthorized(HttpServletRequest request, HttpServletResponse response) {
        response.setStatus(902);
        return "unauthorized";
    }

    @RequestMapping(value={"/personal"})
    public String personal(HttpServletRequest request, HttpServletResponse response) {
        SysUser userSession = ShiroUserUtils.getCurrentShiroUser().getSysUser();
        SysUser user = this.userBiz.selectByPrimaryKey(userSession.getId());
        request.setAttribute("user", (Object)user);
        return "/user/personal";
    }

    @RequestMapping(value={"/updateUserInformation"}, method={RequestMethod.POST})
    @ResponseBody
    public Object update(SysUser user, String oldPassword) {
        try {
            int result = this.userBiz.checkAndSaveUser(user, oldPassword);
            if (result == 5) {
                return new FailMsg("\u624b\u673a\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6539", null);
            }
            if (result == 6) {
                return new FailMsg("\u65e7\u5bc6\u7801\u8f93\u5165\u9519\u8bef", null);
            }
        }
        catch (Exception e) {
            return new FailMsg("\u66f4\u65b0\u5931\u8d25", null);
        }
        ShiroUserUtils.clearCachedAuthenticationInfo(user.getUserName());
        return new SuccessMsg("\u66f4\u65b0\u6210\u529f", null);
    }

    @RequestMapping(value={"/message"})
    public String message() {
        return "/user/messageList";
    }
}

