/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.sso.business.pagination;

import com.jxwk.sso.business.pagination.PageRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Page<T>
extends PageRequest
implements Serializable {
    protected List<T> rows = null;
    protected long total = -1L;

    public Page() {
    }

    public Page(PageRequest request) {
        this.pageNo = request.getPageNo();
        this.pageSize = request.getPageSize();
        this.countTotal = request.isCountTotal();
        this.sort = request.sort();
        this.direction = request.direction();
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int getTotalPages() {
        return (int)Math.ceil((double)this.total / (double)this.getPageSize());
    }

    public boolean hasNextPage() {
        return this.getPageNo() + 1 <= this.getTotalPages();
    }

    public int getNextPage() {
        if (this.hasNextPage()) {
            return this.getPageNo() + 1;
        }
        return this.getPageNo();
    }

    public boolean hasPrePage() {
        return this.getPageNo() > 1;
    }

    public int getPrePage() {
        if (this.hasPrePage()) {
            return this.getPageNo() - 1;
        }
        return this.getPageNo();
    }

    public List<Integer> getSlider(int count) {
        int halfSize = count / 2;
        int totalPage = this.getTotalPages();
        int startPageNo = Math.max(this.getPageNo() - halfSize, 1);
        int endPageNo = Math.min(startPageNo + count - 1, totalPage);
        if (endPageNo - startPageNo < count) {
            startPageNo = Math.max(endPageNo - count, 1);
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = startPageNo; i <= endPageNo; ++i) {
            result.add(i);
        }
        return result;
    }
}

