/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.sso.business.biz;

import com.jxwk.sso.business.entity.SsoApplication;
import com.jxwk.sso.business.entity.SsoDomain;
import com.jxwk.sso.business.mapper.SsoApplicationDao;
import com.jxwk.sso.business.mapper.SsoDomainDao;
import com.ync365.sso.service.dto.WhiteListDTO;
import com.ync365.sso.util.Configuration;
import com.ync365.sso.util.JacksonMapperUtil;
import com.ync365.util.redis.RedisShardClient;
import com.ync365.util.redis.SimpleLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class WhiteListBiz {
    @Autowired
    private SsoApplicationDao ssoAppDao;
    @Autowired
    private SsoDomainDao ssoDomainDao;
    @Autowired
    private RedisShardClient redisShardClient;
    @Autowired
    private Configuration config;

    public boolean checkWhiteList(String appcode, String domain) {
        boolean b = false;
        if (!StringUtils.isEmpty((Object)appcode) && !StringUtils.isEmpty((Object)domain)) {
            HashMap<String, String> mapDomain = new HashMap<String, String>();
            mapDomain.put("appcode", appcode);
            mapDomain.put("domain", domain);
            Integer i_domain = this.ssoDomainDao.getCountBySqls(mapDomain);
            HashMap<String, String> mapAppcod = new HashMap<String, String>();
            mapAppcod.put("appcode", appcode);
            Integer i_appcode = this.ssoAppDao.getCountBySqls(mapAppcod);
            if (i_domain != null && i_domain > 0 && i_appcode != null && i_appcode > 0) {
                b = true;
            }
        }
        return b;
    }

    public WhiteListDTO getWhiteList() {
        final WhiteListDTO whiteListDto = new WhiteListDTO();
        String domainjson = this.redisShardClient.get("YNC365:SSO:PERSIST:DOMAIN");
        if (null == domainjson) {
            SimpleLock lock = new SimpleLock("YNC365:SSO:PERSIST:DOMAIN");
            lock.wrap(new Runnable(){

                @Override
                public void run() {
                    String tmp = null;
                    tmp = WhiteListBiz.this.redisShardClient.get("YNC365:SSO:PERSIST:DOMAIN");
                    if (null != tmp) {
                        List domainList = JacksonMapperUtil.jsonToList((String)tmp, String.class);
                        whiteListDto.setDomainList(domainList);
                    }
                    if (null == tmp) {
                        HashMap<String, String> mapDomain = new HashMap<String, String>();
                        List<SsoDomain> domList = WhiteListBiz.this.ssoDomainDao.getBySqls(mapDomain);
                        if (null != domList && domList.size() > 0) {
                            ArrayList<String> doList = new ArrayList<String>();
                            for (SsoDomain domains : domList) {
                                doList.add(domains.getDomain());
                            }
                            WhiteListBiz.this.redisShardClient.set("YNC365:SSO:PERSIST:DOMAIN", JacksonMapperUtil.beanToJson(doList));
                            int cacheTime = WhiteListBiz.this.config.getCacheYncsid();
                            WhiteListBiz.this.redisShardClient.expire("YNC365:SSO:PERSIST:DOMAIN", cacheTime);
                            whiteListDto.setDomainList(doList);
                        }
                    }
                }
            });
        } else {
            List domainList = JacksonMapperUtil.jsonToList((String)domainjson, String.class);
            whiteListDto.setDomainList(domainList);
        }
        String appcodejson = this.redisShardClient.get("YNC365:SSO:PERSIST:APPCODE");
        if (null == appcodejson) {
            SimpleLock lock = new SimpleLock("YNC365:SSO:PERSIST:APPCODE");
            lock.wrap(new Runnable(){

                @Override
                public void run() {
                    String tmp = null;
                    tmp = WhiteListBiz.this.redisShardClient.get("YNC365:SSO:PERSIST:APPCODE");
                    if (null != tmp) {
                        List appcodeList = JacksonMapperUtil.jsonToList((String)tmp, String.class);
                        whiteListDto.setAcList(appcodeList);
                    }
                    if (null == tmp) {
                        HashMap<String, String> mapAppcod = new HashMap<String, String>();
                        List<SsoApplication> appList = WhiteListBiz.this.ssoAppDao.getBySqls(mapAppcod);
                        if (null != appList && appList.size() > 0) {
                            ArrayList<String> acList = new ArrayList<String>();
                            for (SsoApplication appcode : appList) {
                                acList.add(appcode.getAppcode());
                            }
                            WhiteListBiz.this.redisShardClient.set("YNC365:SSO:PERSIST:APPCODE", JacksonMapperUtil.beanToJson(acList));
                            int cacheTime = WhiteListBiz.this.config.getCacheYncsid();
                            WhiteListBiz.this.redisShardClient.expire("YNC365:SSO:PERSIST:APPCODE", cacheTime);
                            whiteListDto.setAcList(acList);
                        }
                    }
                }
            });
        } else {
            List appcodeList = JacksonMapperUtil.jsonToList((String)appcodejson, String.class);
            whiteListDto.setAcList(appcodeList);
        }
        return whiteListDto;
    }
}

