/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.sso.business.biz;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.jxwk.sso.business.entity.SysUser;
import com.jxwk.sso.business.mapper.SysUserDao;
import com.jxwk.sso.business.pagination.PageRequest;
import com.ync365.sso.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class SysUserBiz {
    @Autowired
    private SysUserDao sysUserDao;

    private boolean checkBeforeSave(SysUser entity) {
        List list;
        Example.Criteria critTmp;
        boolean rst = true;
        if (StringUtil.isBlank((String)entity.getUserName())) {
            rst = false;
            throw new IllegalArgumentException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isBlank((String)entity.getPassword())) {
            rst = false;
            throw new IllegalArgumentException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isBlank((String)entity.getRealName())) {
            rst = false;
            throw new IllegalArgumentException("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((StringUtil.isBlank((String)entity.getCardTypeId()) || StringUtil.isBlank((String)entity.getCardNum())) && StringUtil.isBlank((String)entity.getMobile()) && StringUtil.isBlank((String)entity.getEmail()) && StringUtil.isBlank((String)entity.getWeChat()) && StringUtil.isBlank((String)entity.getQq())) {
            rst = false;
            throw new IllegalArgumentException("\u4ee5\u4e0b\u51e0\u9879\u81f3\u5c11\u8f93\u5165\u4e00\u79cd\uff1a1\uff09\u8bc1\u4ef6\u7c7b\u578b+\u8bc1\u4ef6\u53f7\uff1b2\uff09\u624b\u673a\u53f7\uff1b3\uff09\u7535\u5b50\u90ae\u7bb1\uff1b4\uff09\u5fae\u4fe1\uff1b5\uff09QQ");
        }
        Example ex = new Example(SysUser.class);
        Example.Criteria crit = ex.or().andCondition("upper(user_name)=", (Object)entity.getUserName().toUpperCase()).andEqualTo("deleted", (Object)false);
        if (StringUtil.isNotBlank((String)entity.getId())) {
            crit.andNotEqualTo("id", (Object)entity.getId());
        }
        if (StringUtil.isNotBlank((String)entity.getCardTypeId()) && StringUtil.isNotBlank((String)entity.getCardNum())) {
            critTmp = ex.or().andEqualTo("cardTypeId", (Object)entity.getCardTypeId()).andEqualTo("cardNum", (Object)entity.getCardNum()).andEqualTo("deleted", (Object)false);
            if (StringUtil.isNotBlank((String)entity.getId())) {
                critTmp.andNotEqualTo("id", (Object)entity.getId());
            }
        }
        if (StringUtil.isNotBlank((String)entity.getMobile())) {
            critTmp = ex.or().andEqualTo("mobile", (Object)entity.getMobile()).andEqualTo("deleted", (Object)false);
            if (StringUtil.isNotBlank((String)entity.getId())) {
                critTmp.andNotEqualTo("id", (Object)entity.getId());
            }
        }
        if (StringUtil.isNotBlank((String)entity.getEmail())) {
            critTmp = ex.or().andEqualTo("email", (Object)entity.getEmail()).andEqualTo("deleted", (Object)false);
            if (StringUtil.isNotBlank((String)entity.getId())) {
                critTmp.andNotEqualTo("id", (Object)entity.getId());
            }
        }
        if (StringUtil.isNotBlank((String)entity.getWeChat())) {
            critTmp = ex.or().andEqualTo("weChat", (Object)entity.getWeChat()).andEqualTo("deleted", (Object)false);
            if (StringUtil.isNotBlank((String)entity.getId())) {
                critTmp.andNotEqualTo("id", (Object)entity.getId());
            }
        }
        if (StringUtil.isNotBlank((String)entity.getQq())) {
            critTmp = ex.or().andEqualTo("qq", (Object)entity.getQq()).andEqualTo("deleted", (Object)false);
            if (StringUtil.isNotBlank((String)entity.getId())) {
                critTmp.andNotEqualTo("id", (Object)entity.getId());
            }
        }
        if (null != (list = this.sysUserDao.selectByExample(ex)) && !list.isEmpty()) {
            String msg = "";
            boolean[] flag = new boolean[]{false, false, false, false, false, false};
            for (SysUser temp : list) {
                int i = 0;
                if (!flag[i] && entity.getUserName().equalsIgnoreCase(temp.getUserName())) {
                    flag[i] = true;
                    msg = msg + "\u3001\u76f8\u540c\u7528\u6237\u540d";
                }
                if (StringUtil.isNotBlank((String)entity.getCardTypeId()) && StringUtil.isNotBlank((String)entity.getCardNum()) && !flag[++i] && entity.getCardTypeId().equals(temp.getCardTypeId()) && entity.getCardNum().equals(temp.getCardNum())) {
                    flag[i] = true;
                    msg = msg + "\u3001\u76f8\u540c\u8bc1\u4ef6\u7c7b\u578b\u548c\u8bc1\u4ef6\u53f7";
                }
                if (StringUtil.isNotBlank((String)entity.getMobile()) && !flag[++i] && entity.getMobile().equals(temp.getMobile())) {
                    flag[i] = true;
                    msg = msg + "\u3001\u76f8\u540c\u624b\u673a\u53f7";
                }
                if (StringUtil.isNotBlank((String)entity.getEmail()) && !flag[++i] && entity.getEmail().equals(temp.getEmail())) {
                    flag[i] = true;
                    msg = msg + "\u3001\u76f8\u540c\u7535\u5b50\u90ae\u7bb1";
                }
                if (StringUtil.isNotBlank((String)entity.getWeChat()) && !flag[++i] && entity.getWeChat().equals(temp.getWeChat())) {
                    flag[i] = true;
                    msg = msg + "\u3001\u76f8\u540c\u5fae\u4fe1";
                }
                if (!StringUtil.isNotBlank((String)entity.getQq()) || flag[++i] || !entity.getQq().equals(temp.getQq())) continue;
                flag[i] = true;
                msg = msg + "\u3001\u76f8\u540cQQ";
            }
            msg = "\u5df2\u5b58\u5728" + msg.substring(1) + "\u7684\u8bb0\u5f55";
            rst = false;
            throw new IllegalArgumentException(msg);
        }
        return rst;
    }

    @Transactional
    public int insert(SysUser entity, String roleIds, String orgAndDeptIds) {
        if (this.checkBeforeSave(entity)) {
            entity.setDeleted(false);
            entity.setCreateTime(new Date());
            entity.setPassword(this.encryptPwd(entity.getPassword()));
            int i = this.sysUserDao.insertSelective(entity);
            if (i > 0) {
                HashMap<String, String> map;
                ArrayList<Map<String, Object>> maplist;
                if (StringUtil.isNotBlank((String)roleIds)) {
                    maplist = new ArrayList<Map<String, Object>>();
                    for (String roleId : roleIds.split(",")) {
                        map = new HashMap<String, String>();
                        map.put("roleId", roleId);
                        maplist.add(map);
                    }
                    this.sysUserDao.saveUserMRole(maplist, entity.getId());
                }
                if (StringUtil.isNotBlank((String)orgAndDeptIds)) {
                    maplist = new ArrayList();
                    for (String orgAndDeptId : orgAndDeptIds.split(",")) {
                        map = new HashMap();
                        String[] orgAndDept = orgAndDeptId.split("\\|", -1);
                        map.put("orgId", orgAndDept[0]);
                        map.put("deptId", orgAndDept[1]);
                        maplist.add(map);
                    }
                    this.sysUserDao.saveUserMOrgDept(maplist, entity.getId());
                }
            }
            return i;
        }
        return -1;
    }

    @Transactional
    public int update(SysUser entity, String roleIds, String orgAndDeptIds) {
        if (this.checkBeforeSave(entity)) {
            int i;
            SysUser temp = (SysUser)this.sysUserDao.selectByPrimaryKey(entity.getId());
            if (!temp.getPassword().equals(entity.getPassword())) {
                entity.setPassword(this.encryptPwd(entity.getPassword()));
            }
            if ((i = this.sysUserDao.updateByPrimaryKeySelective(entity)) > 0) {
                HashMap<String, String> map;
                ArrayList<Map<String, Object>> maplist;
                this.sysUserDao.deleteUserMRole(entity.getId());
                if (StringUtil.isNotBlank((String)roleIds)) {
                    maplist = new ArrayList<Map<String, Object>>();
                    for (String roleId : roleIds.split(",")) {
                        map = new HashMap<String, String>();
                        map.put("roleId", roleId);
                        maplist.add(map);
                    }
                    this.sysUserDao.saveUserMRole(maplist, entity.getId());
                }
                this.sysUserDao.deleteUserMOrgDept(entity.getId());
                if (StringUtil.isNotBlank((String)orgAndDeptIds)) {
                    maplist = new ArrayList();
                    for (String orgAndDeptId : orgAndDeptIds.split(",")) {
                        map = new HashMap();
                        String[] orgAndDept = orgAndDeptId.split("\\|", -1);
                        map.put("orgId", orgAndDept[0]);
                        map.put("deptId", orgAndDept[1]);
                        maplist.add(map);
                    }
                    this.sysUserDao.saveUserMOrgDept(maplist, entity.getId());
                }
            }
            return i;
        }
        return -1;
    }

    @Transactional
    public int delete(String id) {
        SysUser entity = new SysUser();
        entity.setId(id);
        entity.setDeleted(true);
        int i = this.sysUserDao.updateByPrimaryKeySelective(entity);
        return i;
    }

    public SysUser selectById(String id) {
        SysUser entity = this.sysUserDao.selectById(id);
        return entity;
    }

    public List<SysUser> selectByCondition(String userName, String cardTypeId, String cardNum, String mobile, String email, String weChat, String qq, String realName, String status) {
        Example example = new Example(SysUser.class);
        Example.Criteria crit = example.createCriteria();
        crit.andEqualTo("deleted", (Object)"0");
        if (StringUtil.isNotBlank((String)userName)) {
            crit.andCondition("user_name like ", (Object)("%" + userName + "%"));
        }
        if (StringUtil.isNotBlank((String)cardTypeId)) {
            crit.andEqualTo("cardTypeId", (Object)cardTypeId);
        }
        if (StringUtil.isNotBlank((String)cardNum)) {
            crit.andLike("cardNum", "%" + cardNum + "%");
        }
        if (StringUtil.isNotBlank((String)mobile)) {
            crit.andLike("mobile", "%" + mobile + "%");
        }
        if (StringUtil.isNotBlank((String)email)) {
            crit.andLike("email", "%" + email + "%");
        }
        if (StringUtil.isNotBlank((String)weChat)) {
            crit.andLike("weChat", "%" + weChat + "%");
        }
        if (StringUtil.isNotBlank((String)qq)) {
            crit.andLike("qq", "%" + qq + "%");
        }
        if (StringUtil.isNotBlank((String)realName)) {
            crit.andLike("realName", "%" + realName + "%");
        }
        if (StringUtil.isNotBlank((String)status)) {
            crit.andEqualTo("status", (Object)status);
        }
        List list = this.sysUserDao.selectByExample(example);
        return list;
    }

    public Page<SysUser> selectPageByCondition(PageRequest pr, String userName, String cardTypeId, String cardNum, String mobile, String email, String weChat, String qq, String realName, String status) {
        PageHelper.startPage((int)pr.getPageNo(), (int)pr.getPageSize(), (String)"create_time desc");
        Page list = (Page)this.selectByCondition(userName, cardTypeId, cardNum, mobile, email, weChat, qq, realName, status);
        return list;
    }

    private String getStringRandom(int length) {
        String val = "";
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            String charOrNum;
            String string = charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                int temp = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val = val + (char)(random.nextInt(26) + temp);
                continue;
            }
            if (!"num".equalsIgnoreCase(charOrNum)) continue;
            val = val + String.valueOf(random.nextInt(10));
        }
        return val;
    }

    private String encryptPwd(String pwd) {
        return new SimpleHash("MD5", (Object)pwd).toHex();
    }

    @Transactional
    public int updateUserPwd(String id, String pwd) {
        SysUser user = new SysUser();
        user.setId(id);
        user.setPassword(this.encryptPwd(pwd));
        return this.sysUserDao.updateByPrimaryKeySelective(user);
    }

    @Transactional
    public int updateSysUser(SysUser user) {
        return this.sysUserDao.updateByPrimaryKeySelective(user);
    }

    public List<SysUser> selectSynByCondition(String userName, String cardTypeId, String cardNum, String mobile, String email, String weChat, String qq, String realName) {
        Example example = new Example(SysUser.class);
        Example.Criteria crit = example.createCriteria();
        crit.andEqualTo("deleted", (Object)false);
        if (StringUtil.isNotBlank((String)userName)) {
            crit.andCondition("user_name like ", (Object)("%" + userName + "%"));
        }
        if (StringUtil.isNotBlank((String)cardTypeId)) {
            crit.andEqualTo("cardTypeId", (Object)cardTypeId);
        }
        if (StringUtil.isNotBlank((String)cardNum)) {
            crit.andLike("cardNum", "%" + cardNum + "%");
        }
        if (StringUtil.isNotBlank((String)mobile)) {
            crit.andLike("mobile", "%" + mobile + "%");
        }
        if (StringUtil.isNotBlank((String)email)) {
            crit.andLike("email", "%" + email + "%");
        }
        if (StringUtil.isNotBlank((String)weChat)) {
            crit.andLike("weChat", "%" + weChat + "%");
        }
        if (StringUtil.isNotBlank((String)qq)) {
            crit.andLike("qq", "%" + qq + "%");
        }
        if (StringUtil.isNotBlank((String)realName)) {
            crit.andLike("realName", "%" + realName + "%");
        }
        List list = this.sysUserDao.selectByExample(example);
        return list;
    }

    public List<SysUser> selectUserByCondition(String cardTypeId, String cardNum, String mobile, String email, String weChat, String qq) {
        Example example = new Example(SysUser.class);
        Example.Criteria crit = example.createCriteria();
        crit.andEqualTo("deleted", (Object)"0");
        if (StringUtil.isNotBlank((String)cardTypeId) && StringUtil.isNotBlank((String)cardNum)) {
            crit.andEqualTo("cardTypeId", (Object)cardTypeId);
            crit.andEqualTo("cardNum", (Object)cardNum);
        }
        if (StringUtil.isNotBlank((String)mobile)) {
            crit.andEqualTo("mobile", (Object)mobile);
        }
        if (StringUtil.isNotBlank((String)email)) {
            crit.andEqualTo("email", (Object)email);
        }
        if (StringUtil.isNotBlank((String)weChat)) {
            crit.andEqualTo("weChat", (Object)weChat);
        }
        if (StringUtil.isNotBlank((String)qq)) {
            crit.andEqualTo("qq", (Object)qq);
        }
        List<SysUser> list = new ArrayList<SysUser>();
        if (crit.getCriteria().size() > 1) {
            list = this.sysUserDao.selectByExample(example);
        }
        return list;
    }
}

