/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.sso.business.biz;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.jxwk.sso.business.entity.SysOrg;
import com.jxwk.sso.business.mapper.SysOrgDao;
import com.jxwk.sso.business.pagination.PageRequest;
import com.ync365.sso.util.StringUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class SysOrgBiz {
    @Autowired
    private SysOrgDao sysOrganDao;

    @Transactional
    public int insert(SysOrg entity) {
        entity.setDeleted(false);
        entity.setCreateTime(new Date());
        int i = this.sysOrganDao.insertSelective(entity);
        return i;
    }

    @Transactional
    public int update(SysOrg entity) {
        int i = this.sysOrganDao.updateByPrimaryKeySelective(entity);
        return i;
    }

    @Transactional
    public int delete(String id) {
        SysOrg entity = new SysOrg();
        entity.setId(id);
        entity.setDeleted(true);
        int i = this.sysOrganDao.updateByPrimaryKeySelective(entity);
        return i;
    }

    public SysOrg selectById(String id) {
        SysOrg entity = (SysOrg)this.sysOrganDao.selectByPrimaryKey(id);
        return entity;
    }

    public List<SysOrg> selectByCondition(String name, String code, String budgetCode, String typeId, Boolean enabled) {
        Example example = new Example(SysOrg.class);
        Example.Criteria crit = example.createCriteria();
        crit.andEqualTo("deleted", (Object)false);
        if (StringUtil.isNotBlank((String)name)) {
            crit.andLike("name", "%" + name + "%");
        }
        if (StringUtil.isNotBlank((String)code)) {
            crit.andLike("code", "%" + code + "%");
        }
        if (StringUtil.isNotBlank((String)budgetCode)) {
            crit.andLike("budgetCode", "%" + budgetCode + "%");
        }
        if (StringUtil.isNotBlank((String)typeId)) {
            crit.andEqualTo("typeId", (Object)typeId);
        }
        if (null != enabled) {
            crit.andEqualTo("enabled", (Object)enabled);
        }
        List list = this.sysOrganDao.selectByExample(example);
        return list;
    }

    public Page<SysOrg> selectPageByCondition(PageRequest pr, String name, String code, String budgetCode, String typeId, Boolean enabled) {
        PageHelper.startPage((int)pr.getPageNo(), (int)pr.getPageSize(), (String)"NLSSORT(name,'NLS_SORT=SCHINESE_PINYIN_M') asc");
        Page list = (Page)this.selectByCondition(name, code, budgetCode, typeId, enabled);
        return list;
    }

    public Page<SysOrg> selectPageByCondition(PageRequest pr, String name) {
        return this.selectPageByCondition(pr, name, null, null, null, true);
    }
}

