/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.sso.business.biz;

import com.jxwk.sso.business.entity.MSysUserSysRole;
import com.jxwk.sso.business.entity.SysLogAuditPolicy;
import com.jxwk.sso.business.mapper.MSysUserSysRoleDao;
import com.jxwk.sso.business.mapper.SysLogAuditPolicyDao;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class SysLogAuditPolicyBiz {
    @Autowired
    private SysLogAuditPolicyDao policyDao;
    @Autowired
    private MSysUserSysRoleDao userSysRoleDao;

    public List<SysLogAuditPolicy> selectList(Map<String, Object> params) {
        return this.policyDao.selectList(params);
    }

    public List<SysLogAuditPolicy> selectListByRoleId(String roleId) {
        return this.policyDao.selectListByRoleId(roleId);
    }

    public int insert(SysLogAuditPolicy entity) {
        return this.policyDao.insertSelective(entity);
    }

    @Transactional
    public int update(SysLogAuditPolicy entity, String dictIds) {
        this.delete(entity.getRoleId());
        List<String> list = Arrays.asList(dictIds.split(","));
        int count = 0;
        for (String dictId : list) {
            entity.setDictId(dictId);
            this.policyDao.insertSelective(entity);
            ++count;
        }
        return count;
    }

    public int delete(String roleId) {
        Example example = new Example(SysLogAuditPolicy.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("roleId", (Object)roleId);
        return this.policyDao.deleteByExample(example);
    }

    public Set<String> getCurrentAuditPolicy(String userId) {
        Example userRoleExample = new Example(MSysUserSysRole.class);
        Example.Criteria userRoleCriteria = userRoleExample.createCriteria();
        userRoleCriteria.andEqualTo("sysUserId", (Object)userId);
        List mSysUserSysRoles = this.userSysRoleDao.selectByExample(userRoleExample);
        HashSet<String> set = new HashSet<String>();
        for (MSysUserSysRole ur : mSysUserSysRoles) {
            List<SysLogAuditPolicy> sysLogAuditPolicies = this.selectListByRoleId(ur.getSysRoleId());
            for (SysLogAuditPolicy ap : sysLogAuditPolicies) {
                if (set.contains(ap.getPolicyValue())) continue;
                set.add(ap.getPolicyValue());
            }
        }
        return set;
    }
}

