/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.sso.business.biz;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.jxwk.sso.business.entity.SysDictData;
import com.jxwk.sso.business.mapper.SysDictDataDao;
import com.jxwk.sso.business.pagination.PageRequest;
import com.ync365.sso.util.StringUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class SysDictDataBiz {
    @Autowired
    private SysDictDataDao sysDictDao;

    private boolean checkBeforeSave(SysDictData entity) {
        int cnt;
        boolean rst = true;
        if (StringUtil.isBlank((String)entity.getValue())) {
            rst = false;
            throw new IllegalArgumentException("\u6570\u636e\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isBlank((String)entity.getLabel())) {
            rst = false;
            throw new IllegalArgumentException("\u6570\u636e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Example ex = new Example(SysDictData.class);
        Example.Criteria crit = ex.or().andCondition("upper(value)=", (Object)entity.getValue().toUpperCase()).andEqualTo("gcode", (Object)entity.getGcode());
        if (StringUtil.isNotBlank((String)entity.getId())) {
            crit.andNotEqualTo("id", (Object)entity.getId());
        }
        if ((cnt = this.sysDictDao.selectCountByExample(ex)) > 0) {
            rst = false;
            throw new IllegalArgumentException("\u540c\u7ec4\u6570\u636e\u4e2d\u7684\u6570\u636e\u503c\u51b2\u7a81");
        }
        return rst;
    }

    @CacheEvict(value={"sso_cache"}, allEntries=true)
    @Transactional
    public int insert(SysDictData entity) {
        if (this.checkBeforeSave(entity)) {
            entity.setCreateTime(new Date());
            int i = this.sysDictDao.insertSelective(entity);
            return i;
        }
        return -1;
    }

    @CacheEvict(value={"sso_cache"}, allEntries=true)
    @Transactional
    public int update(SysDictData entity) {
        if (this.checkBeforeSave(entity)) {
            int i = this.sysDictDao.updateByPrimaryKeySelective(entity);
            return i;
        }
        return -1;
    }

    @CacheEvict(value={"sso_cache"}, allEntries=true)
    @Transactional
    public int delete(String id) {
        int i = this.sysDictDao.deleteByPrimaryKey(id);
        return i;
    }

    @Cacheable(value={"sso_cache"}, key="'sso_dictData_selectById[id=' + #id + ']'")
    public SysDictData selectById(String id) {
        SysDictData entity = (SysDictData)this.sysDictDao.selectByPrimaryKey(id);
        return entity;
    }

    @Cacheable(value={"sso_cache"}, key="'sso_dictData_selectLabelById[id=' + #id + ']'")
    public String selectLabelById(String id) {
        SysDictData entity;
        String label = "";
        if (id != null && (entity = (SysDictData)this.sysDictDao.selectByPrimaryKey(id)) != null) {
            label = entity.getLabel();
        }
        return label;
    }

    @Cacheable(value={"sso_cache"}, key="'sso_dictData_selectByGcode[gcode=' + #gcode + ']'")
    public List<SysDictData> selectByGcode(String gcode) {
        Example example = new Example(SysDictData.class);
        Example.Criteria crit = example.createCriteria();
        example.setOrderByClause("sort asc");
        if (StringUtil.isNotBlank((String)gcode)) {
            crit.andEqualTo("gcode", (Object)gcode);
        }
        List list = this.sysDictDao.selectByExample(example);
        return list;
    }

    @Cacheable(value={"sso_cache"}, key="'sso_dictData_selectByCondition[gcode=' + #gcode + '_value=' + #value + ']'")
    public SysDictData selectByCondition(String gcode, String value) {
        Example example = new Example(SysDictData.class);
        Example.Criteria crit = example.createCriteria();
        example.setOrderByClause("sort asc");
        crit.andEqualTo("gcode", (Object)gcode);
        crit.andEqualTo("value", (Object)value);
        List list = this.sysDictDao.selectByExample(example);
        SysDictData entity = null;
        if (null != list && !list.isEmpty()) {
            entity = (SysDictData)list.get(0);
        }
        return entity;
    }

    public List<SysDictData> selectByCondition(String gcode, String pid, String label) {
        Example example = new Example(SysDictData.class);
        Example.Criteria crit = example.createCriteria();
        example.setOrderByClause("sort asc");
        if (StringUtil.isNotBlank((String)gcode)) {
            crit.andEqualTo("gcode", (Object)gcode);
        }
        if (StringUtil.isNotBlank((String)pid)) {
            crit.andEqualTo("pid", (Object)pid);
        }
        if (StringUtil.isNotBlank((String)label)) {
            crit.andLike("label", "%" + label + "%");
        }
        List list = this.sysDictDao.selectByExample(example);
        return list;
    }

    public Page<SysDictData> selectPageByCondition(PageRequest pr, String gcode, String pid, String label) {
        PageHelper.startPage((int)pr.getPageNo(), (int)pr.getPageSize(), (String)"sort desc");
        Page list = (Page)this.selectByCondition(gcode, pid, label);
        return list;
    }
}

