/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.sso.business.biz;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.jxwk.sso.business.entity.SsoDomain;
import com.jxwk.sso.business.mapper.SsoDomainDao;
import com.jxwk.sso.business.pagination.PageRequest;
import com.ync365.sso.util.DateUtil;
import com.ync365.sso.util.StringUtil;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class SsoDomainBiz {
    @Autowired
    private SsoDomainDao ssoDomainDao;

    @Transactional
    public int insert(SsoDomain entity) {
        entity.setRegdate(DateUtil.getNowDatetime());
        entity.setCreateTime(new Date());
        int i = this.ssoDomainDao.insertSelective(entity);
        return i;
    }

    @Transactional
    public int update(SsoDomain entity) {
        int i = this.ssoDomainDao.updateByPrimaryKeySelective(entity);
        return i;
    }

    @Transactional
    public int delete(String id) {
        int i = this.ssoDomainDao.deleteByPrimaryKey(id);
        return i;
    }

    public SsoDomain selectById(String id) {
        SsoDomain entity = (SsoDomain)this.ssoDomainDao.selectByPrimaryKey(id);
        return entity;
    }

    public Page<SsoDomain> selectPageByCondition(PageRequest pr, String domain, String appcode) {
        Example example = new Example(SsoDomain.class);
        Example.Criteria crit = example.createCriteria();
        if (StringUtil.isNotBlank((String)domain)) {
            crit.andLike("domain", "%" + domain + "%");
        }
        if (StringUtil.isNotBlank((String)appcode)) {
            crit.andEqualTo("appcode", (Object)appcode);
        }
        PageHelper.startPage((int)pr.getPageNo(), (int)pr.getPageSize(), (String)"appcode asc, domain asc");
        Page list = (Page)this.ssoDomainDao.selectByExample(example);
        return list;
    }
}

