/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.sso.business.biz;

import com.jxwk.sso.business.entity.SsoApplication;
import com.jxwk.sso.business.entity.SysUser;
import com.jxwk.sso.business.mapper.LoginDao;
import com.jxwk.sso.business.mapper.SsoApplicationDao;
import com.jxwk.util.MD5Util;
import com.ync365.sso.service.dto.SessionDTO;
import com.ync365.sso.service.dto.StringDTO;
import com.ync365.sso.service.dto.TgtDTO;
import com.ync365.sso.service.dto.TicketDTO;
import com.ync365.sso.service.dto.UserDTO;
import com.ync365.sso.util.Configuration;
import com.ync365.sso.util.DateUtil;
import com.ync365.sso.util.JacksonMapperUtil;
import com.ync365.sso.util.StringUtil;
import com.ync365.sso.util.UuidUtil;
import com.ync365.util.redis.RedisShardClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class LoginBiz {
    @Autowired
    private LoginDao loginDao;
    @Autowired
    private SsoApplicationDao ssoApplicationDao;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ThreadPoolExecutor ssoThreadPool;
    @Autowired
    private RedisShardClient redisShardClient;
    @Autowired
    private Configuration config;

    private boolean equalPassword(String password, SysUser user) {
        boolean isEq = false;
        String md5Password = MD5Util.getMD5((String)password);
        isEq = user.getPassword().equalsIgnoreCase(md5Password);
        return isEq;
    }

    public SysUser checkUser(String userName, String password, String appcode) {
        SysUser user = null;
        List<SysUser> userList = this.loginDao.getUserInfos(userName);
        if (userList != null && !userList.isEmpty()) {
            block0: for (SysUser u : userList) {
                if (!this.equalPassword(password, u)) continue;
                if (null != appcode && appcode.length() > 0) {
                    List<SsoApplication> list = this.ssoApplicationDao.findByUserId(u.getId());
                    for (SsoApplication app : list) {
                        if (!app.getAppcode().equals(appcode)) continue;
                        user = u;
                        continue block0;
                    }
                    continue;
                }
                user = u;
                break;
            }
        }
        return user;
    }

    public boolean logout(String yncsid, String ynctgc, String yncst) {
        SessionDTO sessionDto;
        boolean result = false;
        String domainKey = "YNC365:SSO:CACHE:YNCSID:" + yncsid;
        String domainJson = null;
        domainJson = this.redisShardClient.get(domainKey);
        if (null != domainJson && !"".equals(domainJson) && null != (sessionDto = (SessionDTO)JacksonMapperUtil.jsonToBean((String)domainJson, SessionDTO.class))) {
            Boolean isDelete = true;
            if (null != ynctgc && !"".equals(ynctgc) && !ynctgc.equals(sessionDto.getYnctgt().getYnctgc())) {
                isDelete = false;
            }
            if (null != yncst && !"".equals(yncst) && !yncst.equals(sessionDto.getYncst())) {
                isDelete = false;
            }
            if (isDelete.booleanValue()) {
                this.redisShardClient.del(domainKey);
                this.cleanLocalCache(yncsid);
                result = true;
            }
        }
        return result;
    }

    public SessionDTO getSessionDTO(String yncsid) {
        SessionDTO sessiondto = null;
        String sessionKey = "YNC365:SSO:CACHE:YNCSID:" + yncsid;
        String sessionDtoJson = null;
        sessionDtoJson = this.redisShardClient.get(sessionKey);
        int cacheTime = this.config.getCacheYncsid();
        this.redisShardClient.expire(sessionKey, cacheTime);
        if (null != sessionDtoJson && !"".equals(sessionDtoJson)) {
            sessiondto = (SessionDTO)JacksonMapperUtil.jsonToBean((String)sessionDtoJson, SessionDTO.class);
        }
        return sessiondto;
    }

    public void setAppid(String appip) {
        this.redisShardClient.sadd("YNC365:SSO:PERSIST:APPIP", new String[]{appip});
    }

    public TicketDTO creatTicketDto(String yncuid_cr, String yncsid_cr, String yncst_cr) {
        TicketDTO ticketDto = new TicketDTO();
        try {
            boolean isCreatSid = true;
            if (null != yncsid_cr && !"".equals(yncsid_cr) && null != yncst_cr && !"".equals(yncst_cr)) {
                SessionDTO sessionDto;
                String sessionKey = "YNC365:SSO:CACHE:YNCSID:" + yncsid_cr;
                String sessionJson = null;
                sessionJson = this.redisShardClient.get(sessionKey);
                if (null != null && !"".equals(sessionJson) && null != (sessionDto = (SessionDTO)JacksonMapperUtil.jsonToBean((String)sessionJson, SessionDTO.class)) && yncst_cr.equals(sessionDto.getYncst())) {
                    isCreatSid = false;
                }
            }
            String yncst = null;
            String yncsid = null;
            if (isCreatSid) {
                yncst = UuidUtil.getUUID();
                yncsid = UuidUtil.getUUID();
            } else {
                yncst = yncst_cr;
                yncsid = yncsid_cr;
            }
            String ynctgc = UuidUtil.getUUID();
            String yncuid = yncuid_cr;
            String ticket = UuidUtil.getUUID();
            ticketDto = new TicketDTO();
            TgtDTO tgt = new TgtDTO();
            tgt.setTime(DateUtil.getTodayByFormat((String)"yyyy-MM-dd HH:mm:ss"));
            tgt.setYnctgc(ynctgc);
            tgt.setYncuid(yncuid);
            ticketDto.setYnctgt(tgt);
            ticketDto.setYncst(yncst);
            ticketDto.setYncsid(yncsid);
            ticketDto.setTicket(ticket);
            String ticketJson = JacksonMapperUtil.beanToJson((Object)ticketDto);
            String ticketKey = "YNC365:SSO:CACHE:TICKET:" + ticket;
            int cacheTime = this.config.getCacheTicket();
            this.redisShardClient.set(ticketKey, ticketJson);
            this.redisShardClient.expire(ticketKey, cacheTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ticketDto;
    }

    public void cleanLocalCache(String yncsid) {
        Set ips = null;
        ips = this.redisShardClient.smembers("YNC365:SSO:PERSIST:APPIP");
        for (String ip : ips) {
            this.ssoThreadPool.execute(new CleanCache(ip, yncsid));
        }
    }

    public SessionDTO getTicketByTt(String ticket, String appcode, int seconds) {
        TicketDTO ticketDto;
        String ticketKey = "YNC365:SSO:CACHE:TICKET:" + ticket;
        String ticketDtoJson = null;
        ticketDtoJson = this.redisShardClient.getSet(ticketKey, "");
        this.redisShardClient.del(ticketKey);
        SessionDTO sessiondto = null;
        if (null != ticketDtoJson && !"".equals(ticketDtoJson) && null != (ticketDto = (TicketDTO)JacksonMapperUtil.jsonToBean((String)ticketDtoJson, TicketDTO.class))) {
            String yncsid = ticketDto.getYncsid();
            String yncst = ticketDto.getYncst();
            String yncuid = ticketDto.getYnctgt().getYncuid();
            String ynctgc = ticketDto.getYnctgt().getYnctgc();
            sessiondto = new SessionDTO();
            sessiondto.setYncsid(yncsid);
            sessiondto.setYncst(yncst);
            TgtDTO tgt = new TgtDTO();
            tgt.setTime(DateUtil.getTodayByFormat((String)"yyyy-MM-dd HH:mm:ss"));
            tgt.setYnctgc(ynctgc);
            tgt.setYncuid(yncuid);
            sessiondto.setYnctgt(tgt);
            sessiondto.setAc(appcode);
            sessiondto.setTime(DateUtil.getTodayByFormat((String)"yyyy-MM-dd HH:mm:ss"));
            String sessionJson = JacksonMapperUtil.beanToJson((Object)sessiondto);
            String sessionKey = "YNC365:SSO:CACHE:YNCSID:" + yncsid;
            this.redisShardClient.set(sessionKey, sessionJson);
            int saveSeconds = this.config.getCacheYncsid();
            if (seconds > saveSeconds) {
                saveSeconds = seconds;
            }
            this.redisShardClient.expire(sessionKey, saveSeconds);
        }
        return sessiondto;
    }

    public UserDTO getUserDTO(String userId, String appcode) {
        List<Map<String, Object>> list = this.loginDao.getUserinfo(userId, appcode);
        UserDTO user = new UserDTO();
        if (list != null && !list.isEmpty()) {
            user.success = true;
            Map<String, Object> map = list.get(0);
            String id = map.get("ID") != null ? map.get("ID").toString() : null;
            String username = map.get("USERNAME") != null ? map.get("USERNAME").toString() : null;
            String mobilephone = map.get("MOBILEPHONE") != null ? map.get("MOBILEPHONE").toString() : null;
            String email = map.get("EMAIL") != null ? map.get("EMAIL").toString() : null;
            String appUsername = map.get("APPUSERNAME") != null ? map.get("APPUSERNAME").toString() : null;
            String appUid = map.get("APPUID") != null ? map.get("APPUID").toString() : null;
            user.setId(id);
            user.setUsername(username);
            user.setMobilephone(mobilephone);
            user.setEmail(email);
            user.setAppUsername(appUsername);
            user.setAppUid(appUid);
        } else {
            user.success = false;
        }
        return user;
    }

    public StringDTO setSmscode(String phoneNum) {
        StringDTO stringDTO = new StringDTO();
        Integer seconds = 120;
        stringDTO.setCode(seconds.toString());
        try {
            if (StringUtil.isNotEmpty((String)phoneNum) && phoneNum.length() == 11) {
                Integer smscode = (int)((Math.random() * 9.0 + 1.0) * 1000.0);
                this.redisShardClient.setex(phoneNum, seconds.intValue(), smscode.toString());
                stringDTO.setValue("\u77ed\u4fe1\u53d1\u9001\u6210\u529f\uff01");
                stringDTO.setSuccess(true);
            } else {
                stringDTO.setValue("\u7528\u6237\u540d\u4e0d\u5408\u6cd5\uff01");
                stringDTO.setSuccess(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            stringDTO.setValue("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff01");
            stringDTO.setSuccess(false);
        }
        return stringDTO;
    }

    public String getSmscode(String phoneNum) {
        String str = this.redisShardClient.get(phoneNum);
        return str;
    }

    private class CleanCache
    implements Runnable {
        private String ip;
        private String yncsid;

        public CleanCache(String ip, String yncsid) {
            this.ip = ip;
            this.yncsid = yncsid;
        }

        @Override
        public void run() {
            int i = -1;
            for (i = 0; i < 3; ++i) {
                HashMap<String, String> urlVariables = new HashMap<String, String>();
                urlVariables.put("yncsid", this.yncsid);
                try {
                    LoginBiz.this.restTemplate.getForObject(this.ip + "?" + "yncsid" + "={" + "yncsid" + "}", String.class, urlVariables);
                    break;
                }
                catch (RuntimeException runtimeException) {
                    continue;
                }
            }
            if (i == 2) {
                LoginBiz.this.redisShardClient.srem("YNC365:SSO:PERSIST:APPIP", new String[]{this.ip});
            }
        }
    }
}

