/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.sso.business.biz;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.jxwk.sso.business.entity.AppUser;
import com.jxwk.sso.business.entity.MAppUserAppOrg;
import com.jxwk.sso.business.entity.MSysUserSysOrgDept;
import com.jxwk.sso.business.mapper.AppUserDao;
import com.jxwk.sso.business.mapper.MAppUserAppOrgDao;
import com.jxwk.sso.business.mapper.MSysUserSysOrgDeptDao;
import com.jxwk.sso.business.pagination.PageRequest;
import com.ync365.sso.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class AppUserBiz {
    @Autowired
    private AppUserDao appUserDao;
    @Autowired
    private MAppUserAppOrgDao mAppUserAppOrgDao;
    @Autowired
    private MSysUserSysOrgDeptDao mSysUserSysOrgDeptDao;

    private void setDefCheckCondition(Example.Criteria crit, AppUser entity) {
        crit.andEqualTo("appcode", (Object)entity.getAppcode());
        crit.andEqualTo("deleted", (Object)false);
        if (StringUtil.isNotBlank((String)entity.getId())) {
            crit.andNotEqualTo("id", (Object)entity.getId());
        }
    }

    private boolean checkBeforeSave(AppUser entity) {
        List list;
        Example.Criteria critTmp;
        boolean rst = true;
        if (StringUtil.isBlank((String)entity.getUserName())) {
            rst = false;
            throw new IllegalArgumentException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isBlank((String)entity.getAppcode())) {
            rst = false;
            throw new IllegalArgumentException("\u5f52\u5c5e\u4e1a\u52a1\u7cfb\u7edf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isBlank((String)entity.getRealName())) {
            rst = false;
            throw new IllegalArgumentException("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Example ex = new Example(AppUser.class);
        Example.Criteria crit = ex.or().andCondition("upper(user_name)=", (Object)entity.getUserName().toUpperCase());
        this.setDefCheckCondition(crit, entity);
        if (StringUtil.isNotBlank((String)entity.getCardTypeId()) && StringUtil.isNotBlank((String)entity.getCardNum())) {
            critTmp = ex.or().andEqualTo("cardTypeId", (Object)entity.getCardTypeId()).andEqualTo("cardNum", (Object)entity.getCardNum());
            this.setDefCheckCondition(critTmp, entity);
        }
        if (StringUtil.isNotBlank((String)entity.getMobile())) {
            critTmp = ex.or().andEqualTo("mobile", (Object)entity.getMobile());
            this.setDefCheckCondition(critTmp, entity);
        }
        if (StringUtil.isNotBlank((String)entity.getEmail())) {
            critTmp = ex.or().andEqualTo("email", (Object)entity.getEmail());
            this.setDefCheckCondition(critTmp, entity);
        }
        if (StringUtil.isNotBlank((String)entity.getWeChat())) {
            critTmp = ex.or().andEqualTo("weChat", (Object)entity.getWeChat());
            this.setDefCheckCondition(critTmp, entity);
        }
        if (StringUtil.isNotBlank((String)entity.getQq())) {
            critTmp = ex.or().andEqualTo("qq", (Object)entity.getQq());
            this.setDefCheckCondition(critTmp, entity);
        }
        if (null != (list = this.appUserDao.selectByExample(ex)) && !list.isEmpty()) {
            String msg = "";
            boolean[] flag = new boolean[]{false, false, false, false, false, false};
            for (AppUser temp : list) {
                int i = 0;
                if (!flag[i] && entity.getUserName().equalsIgnoreCase(temp.getUserName())) {
                    flag[i] = true;
                    msg = msg + "\u3001\u76f8\u540c\u7528\u6237\u540d";
                }
                if (StringUtil.isNotBlank((String)entity.getCardTypeId()) && StringUtil.isNotBlank((String)entity.getCardNum()) && !flag[++i] && entity.getCardTypeId().equals(temp.getCardTypeId()) && entity.getCardNum().equals(temp.getCardNum())) {
                    flag[i] = true;
                    msg = msg + "\u3001\u76f8\u540c\u8bc1\u4ef6\u7c7b\u578b\u548c\u8bc1\u4ef6\u53f7";
                }
                if (StringUtil.isNotBlank((String)entity.getMobile()) && !flag[++i] && entity.getMobile().equals(temp.getMobile())) {
                    flag[i] = true;
                    msg = msg + "\u3001\u76f8\u540c\u624b\u673a\u53f7";
                }
                if (StringUtil.isNotBlank((String)entity.getEmail()) && !flag[++i] && entity.getEmail().equals(temp.getEmail())) {
                    flag[i] = true;
                    msg = msg + "\u3001\u76f8\u540c\u7535\u5b50\u90ae\u7bb1";
                }
                if (StringUtil.isNotBlank((String)entity.getWeChat()) && !flag[++i] && entity.getWeChat().equals(temp.getWeChat())) {
                    flag[i] = true;
                    msg = msg + "\u3001\u76f8\u540c\u5fae\u4fe1";
                }
                if (!StringUtil.isNotBlank((String)entity.getQq()) || flag[++i] || !entity.getQq().equals(temp.getQq())) continue;
                flag[i] = true;
                msg = msg + "\u3001\u76f8\u540cQQ";
            }
            msg = "\u5df2\u5b58\u5728" + msg.substring(1) + "\u7684\u8bb0\u5f55";
            rst = false;
            throw new IllegalArgumentException(msg);
        }
        return rst;
    }

    @Transactional
    public int insert(AppUser entity, String orgIds) {
        if (this.checkBeforeSave(entity)) {
            entity.setDeleted(false);
            entity.setCreateTime(new Date());
            int i = this.appUserDao.insertSelective(entity);
            if (i > 0 && StringUtil.isNotBlank((String)orgIds)) {
                ArrayList<Map<String, Object>> maplist = new ArrayList<Map<String, Object>>();
                for (String orgId : orgIds.split(",")) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("orgId", orgId);
                    maplist.add(map);
                }
                this.appUserDao.saveUserMOrg(maplist, entity.getId());
            }
            return i;
        }
        return -1;
    }

    @Transactional
    public int update(AppUser entity, String orgIds) {
        if (this.checkBeforeSave(entity)) {
            int i = this.appUserDao.updateByPrimaryKeySelective(entity);
            if (i > 0) {
                this.appUserDao.deleteUserMOrg(entity.getId());
                if (StringUtil.isNotBlank((String)orgIds)) {
                    ArrayList<Map<String, Object>> maplist = new ArrayList<Map<String, Object>>();
                    for (String orgId : orgIds.split(",")) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("orgId", orgId);
                        maplist.add(map);
                    }
                    this.appUserDao.saveUserMOrg(maplist, entity.getId());
                }
            }
            return i;
        }
        return -1;
    }

    @Transactional
    public int delete(String id) {
        AppUser entity = new AppUser();
        entity.setId(id);
        entity.setDeleted(true);
        int i = this.appUserDao.updateByPrimaryKeySelective(entity);
        return i;
    }

    public int bindRelation(AppUser entity) {
        return this.appUserDao.bindRelation(entity);
    }

    public AppUser selectById(String id) {
        AppUser entity = this.appUserDao.selectById(id);
        return entity;
    }

    public List<AppUser> selectByAppUid(String appUid, String appcode) {
        Example example = new Example(AppUser.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("appUid", (Object)appUid);
        criteria.andEqualTo("appcode", (Object)appcode);
        List list = this.appUserDao.selectByExample(example);
        return list;
    }

    public List<AppUser> selectByCondition(String appcode, String userName, String realName, String sysUserId, String boundType) {
        List<AppUser> list = this.appUserDao.findByCondition(appcode, userName, realName, sysUserId, boundType);
        return list;
    }

    public Page<AppUser> selectPageByCondition(PageRequest pr, String appcode, String userName, String realName, String sysUserId, String boundType) {
        PageHelper.startPage((int)pr.getPageNo(), (int)pr.getPageSize(), (String)"au.create_time desc");
        Page list = (Page)this.selectByCondition(appcode, userName, realName, sysUserId, boundType);
        return list;
    }

    @Transactional
    public int updateBound(AppUser entity) {
        int i = this.appUserDao.updateByPrimaryKeySelective(entity);
        return i;
    }

    public int synInsert(AppUser entity) {
        entity.setDeleted(false);
        entity.setCreateTime(new Date());
        int i = this.appUserDao.insertSelective(entity);
        return i;
    }

    @Transactional
    public int synUpdate(AppUser entity, String orgIds) {
        int i = this.appUserDao.updateByPrimaryKeySelective(entity);
        if (i > 0) {
            this.appUserDao.deleteUserMOrg(entity.getId());
            if (StringUtil.isNotBlank((String)orgIds)) {
                ArrayList<Map<String, Object>> maplist = new ArrayList<Map<String, Object>>();
                for (String orgId : orgIds.split(",")) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("orgId", orgId);
                    maplist.add(map);
                }
                this.appUserDao.saveUserMOrg(maplist, entity.getId());
            }
        }
        return i;
    }

    public List<MAppUserAppOrg> selectByUserIdAndOrganId(String userId, String OrganId) {
        Example example = new Example(MAppUserAppOrg.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("appUserId", (Object)userId);
        if (StringUtil.isNotBlank((String)OrganId)) {
            criteria.andEqualTo("appOrgId", (Object)OrganId);
        }
        List list = this.mAppUserAppOrgDao.selectByExample(example);
        return list;
    }

    public List<MSysUserSysOrgDept> selectBySysUserIdAndOrganId(String userId) {
        Example example = new Example(MSysUserSysOrgDept.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("sysUserId", (Object)userId);
        List list = this.mSysUserSysOrgDeptDao.selectByExample(example);
        return list;
    }

    public int insertUserAndOrgan(String userId, String organId) {
        ArrayList<Map<String, Object>> maplist = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orgId", organId);
        maplist.add(map);
        this.appUserDao.saveUserMOrg(maplist, userId);
        return 0;
    }

    public int synDelete(AppUser entity) {
        return this.appUserDao.updateByPrimaryKeySelective(entity);
    }

    public List<AppUser> selectByParams(Map<String, Object> params) {
        Example example = new Example(AppUser.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("userName", params.get("userName"));
        criteria.andEqualTo("appcode", params.get("appcode"));
        List list = this.appUserDao.selectByExample(example);
        return list;
    }
}

