/*
 * Decompiled with CFR 0.152.
 */
package com.jxwk.sso.business.biz;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.jxwk.sso.business.entity.AppOrg;
import com.jxwk.sso.business.mapper.AppOrgDao;
import com.jxwk.sso.business.pagination.PageRequest;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
public class AppOrgBiz {
    private static final Logger logger = LoggerFactory.getLogger(AppOrgBiz.class);
    @Autowired
    private AppOrgDao appOrgDao;

    @Transactional
    public int insert(AppOrg entity) {
        entity.setDeleted(false);
        entity.setCreateTime(new Date());
        int i = this.appOrgDao.insertSelective(entity);
        return i;
    }

    @Transactional
    public int update(AppOrg entity) {
        int i = this.appOrgDao.updateByPrimaryKeySelective(entity);
        return i;
    }

    @Transactional
    public int delete(String id) {
        AppOrg entity = new AppOrg();
        entity.setId(id);
        entity.setDeleted(true);
        int i = this.appOrgDao.updateByPrimaryKeySelective(entity);
        return i;
    }

    public AppOrg selectById(String id) {
        AppOrg entity = this.appOrgDao.findById(id);
        return entity;
    }

    public List<AppOrg> selectByAppUid(String appUid, String appcode) {
        Example example = new Example(AppOrg.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("appUid", (Object)appUid);
        criteria.andEqualTo("appcode", (Object)appcode);
        List list = this.appOrgDao.selectByExample(example);
        return list;
    }

    public List<AppOrg> selectByCondition(String appcode, String name, String code, String budgetCode, Boolean enabled, String sysOrgId, String boundType) {
        List<AppOrg> list = this.appOrgDao.findByCondition(appcode, name, code, budgetCode, enabled, sysOrgId, boundType);
        return list;
    }

    public Page<AppOrg> selectPageByCondition(PageRequest pr, String appcode, String name, String code, String budgetCode, Boolean enabled, String sysOrgId, String boundType) {
        PageHelper.startPage((int)pr.getPageNo(), (int)pr.getPageSize(), (String)"NLSSORT(ao.name,'NLS_SORT=SCHINESE_PINYIN_M') asc");
        Page list = (Page)this.selectByCondition(appcode, name, code, budgetCode, enabled, sysOrgId, boundType);
        return list;
    }

    @Transactional
    public int updateBound(AppOrg entity) {
        int i = this.appOrgDao.updateByPrimaryKeySelective(entity);
        return i;
    }
}

