/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import java.io.Serializable;
import java.security.cert.Certificate;

public class EncryptionProperties
implements Serializable {
    private static final long serialVersionUID = 3926570647944137843L;
    protected int encryptionAlgorithm;
    protected byte[] userPassword;
    protected byte[] ownerPassword;
    protected int standardEncryptPermissions;
    protected Certificate[] publicCertificates;
    protected int[] publicKeyEncryptPermissions;

    public EncryptionProperties setStandardEncryption(byte[] userPassword, byte[] ownerPassword, int permissions, int encryptionAlgorithm) {
        this.clearEncryption();
        this.userPassword = userPassword;
        if (ownerPassword != null) {
            this.ownerPassword = ownerPassword;
        } else {
            int r = (int)(2.147483647E9 * Math.random());
            this.ownerPassword = Integer.toHexString(r).getBytes();
        }
        this.standardEncryptPermissions = permissions;
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    public EncryptionProperties setPublicKeyEncryption(Certificate[] certs, int[] permissions, int encryptionAlgorithm) {
        this.clearEncryption();
        this.publicCertificates = certs;
        this.publicKeyEncryptPermissions = permissions;
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    boolean isStandardEncryptionUsed() {
        return this.ownerPassword != null;
    }

    boolean isPublicKeyEncryptionUsed() {
        return this.publicCertificates != null;
    }

    private void clearEncryption() {
        this.publicCertificates = null;
        this.publicKeyEncryptPermissions = null;
        this.userPassword = null;
        this.ownerPassword = null;
    }
}

