/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpStatusCodes;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.Sleeper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryHttpInitializer
implements HttpRequestInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(RetryHttpInitializer.class);
    private final Credential credential;
    private Sleeper sleeperOverride;
    private String defaultUserAgent;

    public RetryHttpInitializer(Credential credential, String defaultUserAgent) {
        Preconditions.checkArgument((credential != null ? 1 : 0) != 0, (Object)"A valid Credential is required");
        this.credential = credential;
        this.sleeperOverride = null;
        this.defaultUserAgent = defaultUserAgent;
    }

    public void initialize(HttpRequest request) {
        request.setInterceptor((HttpExecuteInterceptor)this.credential);
        HttpBackOffIOExceptionHandler exceptionHandler = new HttpBackOffIOExceptionHandler((BackOff)new ExponentialBackOff());
        if (this.sleeperOverride != null) {
            exceptionHandler.setSleeper(this.sleeperOverride);
        }
        LoggingResponseHandler loggingResponseHandler = new LoggingResponseHandler(new CredentialOrBackoffResponseHandler(), (HttpIOExceptionHandler)exceptionHandler, (Set<Integer>)ImmutableSet.of((Object)410, (Object)503));
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)loggingResponseHandler);
        request.setIOExceptionHandler((HttpIOExceptionHandler)loggingResponseHandler);
        if (Strings.isNullOrEmpty((String)request.getHeaders().getUserAgent())) {
            LOG.debug("Request is missing a user-agent, adding default value of '{}'", (Object)this.defaultUserAgent);
            request.getHeaders().setUserAgent(this.defaultUserAgent);
        }
    }

    @VisibleForTesting
    void setSleeperOverride(Sleeper sleeper) {
        this.sleeperOverride = sleeper;
    }

    private class CredentialOrBackoffResponseHandler
    implements HttpUnsuccessfulResponseHandler {
        private final HttpUnsuccessfulResponseHandler delegateHandler;

        public CredentialOrBackoffResponseHandler() {
            HttpBackOffUnsuccessfulResponseHandler errorCodeHandler = new HttpBackOffUnsuccessfulResponseHandler((BackOff)new ExponentialBackOff());
            if (RetryHttpInitializer.this.sleeperOverride != null) {
                errorCodeHandler.setSleeper(RetryHttpInitializer.this.sleeperOverride);
            }
            this.delegateHandler = errorCodeHandler;
        }

        public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
            if (RetryHttpInitializer.this.credential.handleResponse(request, response, supportsRetry)) {
                return true;
            }
            if (this.delegateHandler.handleResponse(request, response, supportsRetry)) {
                return true;
            }
            if (HttpStatusCodes.isRedirect((int)response.getStatusCode()) && request.getFollowRedirects() && response.getHeaders() != null && response.getHeaders().getLocation() != null) {
                String redirectLocation = response.getHeaders().getLocation();
                if (redirectLocation.indexOf(43) != -1) {
                    String escapedLocation = redirectLocation.replaceAll("\\+", "%2B");
                    LOG.debug("Redirect path '{}' contains unescaped '+', replacing with '%2B': '{}'", (Object)redirectLocation, (Object)escapedLocation);
                    response.getHeaders().setLocation(escapedLocation);
                }
                return false;
            }
            return false;
        }
    }

    private class LoggingResponseHandler
    implements HttpUnsuccessfulResponseHandler,
    HttpIOExceptionHandler {
        private final HttpUnsuccessfulResponseHandler delegateResponseHandler;
        private final HttpIOExceptionHandler delegateIOExceptionHandler;
        private final ImmutableSet<Integer> responseCodesToLog;

        public LoggingResponseHandler(HttpUnsuccessfulResponseHandler delegateResponseHandler, HttpIOExceptionHandler delegateIOExceptionHandler, Set<Integer> responseCodesToLog) {
            this.delegateResponseHandler = delegateResponseHandler;
            this.delegateIOExceptionHandler = delegateIOExceptionHandler;
            this.responseCodesToLog = ImmutableSet.copyOf(responseCodesToLog);
        }

        public boolean handleResponse(HttpRequest httpRequest, HttpResponse httpResponse, boolean supportsRetry) throws IOException {
            if (this.responseCodesToLog.contains((Object)httpResponse.getStatusCode())) {
                LOG.info("Encountered status code {} when accessing URL {}. Delegating to response handler for possible retry.", (Object)httpResponse.getStatusCode(), (Object)httpRequest.getUrl());
            }
            return this.delegateResponseHandler.handleResponse(httpRequest, httpResponse, supportsRetry);
        }

        public boolean handleIOException(HttpRequest httpRequest, boolean supportsRetry) throws IOException {
            LOG.debug("Encountered an IOException when accessing URL {}", (Object)httpRequest.getUrl());
            return this.delegateIOExceptionHandler.handleIOException(httpRequest, supportsRetry);
        }
    }
}

