/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.unionpay;

import cn.hutool.core.date.DateUtil;
import com.ijpay.unionpay.AcpService;
import com.ijpay.unionpay.SDKConfig;
import com.ijpay.unionpay.SDKUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class UnionPayApiConfig {
    private UnionPayApiConfig() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String version;
        private String encoding;
        private String signMethod;
        private String txnType;
        private String txnSubType;
        private String bizType;
        private String channelType;
        private String accessType;
        private String merId;
        private String frontUrl;
        private String backUrl;
        private String orderId;
        private String currencyCode;
        private String txnAmt;
        private String txnTime;
        private String payTimeout;
        private String accNo;
        private String reqReserved;
        private String orderDesc;
        private String acqInsCode;
        private String merCatCode;
        private String merName;
        private String merAbbr;
        private String origQryId;
        private String settleDate;
        private String fileType;
        private String bussCode;
        private String billQueryInfo;
        private String qrNo;
        private String termId;
        private String accType;
        private String encryptCertId;
        private String customerInfo;

        public Map<String, String> createMap() {
            HashMap<String, String> map = new HashMap<String, String>();
            if (SDKUtil.isEmpty(this.version)) {
                this.version = "5.1.0";
            }
            if (SDKUtil.isEmpty(this.encoding)) {
                this.encoding = "UTF-8";
            }
            if (SDKUtil.isEmpty(this.signMethod)) {
                this.signMethod = "01";
            }
            if (SDKUtil.isEmpty(this.txnType)) {
                this.txnType = "01";
            }
            if (SDKUtil.isEmpty(this.txnSubType)) {
                this.txnSubType = "01";
            }
            if (SDKUtil.isEmpty(this.bizType)) {
                this.bizType = "000201";
            }
            if (SDKUtil.isEmpty(this.channelType)) {
                this.channelType = "07";
            }
            if (SDKUtil.isEmpty(this.accessType)) {
                this.accessType = "0";
            }
            if (SDKUtil.isEmpty(this.merId)) {
                throw new IllegalArgumentException("merId \u503c\u4e0d\u80fd\u4e3a null");
            }
            if (SDKUtil.isEmpty(this.backUrl)) {
                this.backUrl = SDKConfig.getConfig().getBackUrl();
            }
            if (SDKUtil.isEmpty(this.frontUrl)) {
                this.frontUrl = SDKConfig.getConfig().getFrontUrl();
            }
            if (SDKUtil.isEmpty(this.orderId)) {
                this.orderId = String.valueOf(System.currentTimeMillis());
            }
            if (this.orderId.contains("_") || this.orderId.contains("-")) {
                throw new IllegalArgumentException("orderId \u503c\u4e0d\u5e94\u542b\u201c-\u201d\u6216\u201c_\u201d");
            }
            if (SDKUtil.isEmpty(this.currencyCode)) {
                this.currencyCode = "156";
            }
            if (SDKUtil.isEmpty(this.txnAmt)) {
                this.txnAmt = "1";
            }
            if (SDKUtil.isEmpty(this.txnTime)) {
                this.txnTime = DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss");
            }
            if (SDKUtil.isEmpty(this.payTimeout)) {
                this.payTimeout = DateUtil.format((Date)new Date(new Date().getTime() + 900000L), (String)"YYYYMMddHHmmss");
            }
            map.put("version", this.version);
            map.put("encoding", this.encoding);
            map.put("signMethod", this.signMethod);
            map.put("txnType", this.txnType);
            map.put("txnSubType", this.txnSubType);
            map.put("bizType", this.bizType);
            map.put("channelType", this.channelType);
            map.put("accessType", this.accessType);
            map.put("merId", this.merId);
            map.put("frontUrl", this.frontUrl);
            map.put("backUrl", this.backUrl);
            map.put("orderId", this.orderId);
            map.put("currencyCode", this.currencyCode);
            map.put("txnAmt", this.txnAmt);
            map.put("txnTime", this.txnTime);
            map.put("payTimeout", this.payTimeout);
            map.put("accNo", this.accNo);
            map.put("reqReserved", this.reqReserved);
            map.put("orderDesc", this.orderDesc);
            map.put("acqInsCode", this.acqInsCode);
            map.put("merCatCode", this.merCatCode);
            map.put("merName", this.merName);
            map.put("merAbbr", this.merAbbr);
            map.put("origQryId", this.origQryId);
            map.put("settleDate", this.settleDate);
            map.put("fileType", this.fileType);
            map.put("bussCode", this.bussCode);
            map.put("billQueryInfo", this.billQueryInfo);
            map.put("qrNo", this.qrNo);
            map.put("termId", this.termId);
            map.put("accType", this.accType);
            map.put("encryptCertId", this.encryptCertId);
            map.put("customerInfo", this.customerInfo);
            return this.setSignMap(map);
        }

        public Map<String, String> setSignMap(Map<String, String> map) {
            return AcpService.sign(map, this.encoding);
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder setEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder setSignMethod(String signMethod) {
            this.signMethod = signMethod;
            return this;
        }

        public Builder setTxnType(String txnType) {
            this.txnType = txnType;
            return this;
        }

        public Builder setTxnSubType(String txnSubType) {
            this.txnSubType = txnSubType;
            return this;
        }

        public Builder setBizType(String bizType) {
            this.bizType = bizType;
            return this;
        }

        public Builder setChannelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        public Builder setAccessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        public Builder setMerId(String merId) {
            this.merId = merId;
            return this;
        }

        public Builder setFrontUrl(String frontUrl) {
            this.frontUrl = frontUrl;
            return this;
        }

        public Builder setBackUrl(String backUrl) {
            this.backUrl = backUrl;
            return this;
        }

        public Builder setOrderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public Builder setTxnAmt(String txnAmt) {
            this.txnAmt = txnAmt;
            return this;
        }

        public Builder setTxnTime(String txnTime) {
            this.txnTime = txnTime;
            return this;
        }

        public Builder setPayTimeout(String payTimeout) {
            this.payTimeout = payTimeout;
            return this;
        }

        public Builder setAccNo(String accNo) {
            this.accNo = accNo;
            return this;
        }

        public Builder setReqReserved(String reqReserved) {
            this.reqReserved = reqReserved;
            return this;
        }

        public Builder setOrderDesc(String orderDesc) {
            this.orderDesc = orderDesc;
            return this;
        }

        public Builder setAcqInsCode(String acqInsCode) {
            this.acqInsCode = acqInsCode;
            return this;
        }

        public Builder setMerCatCode(String merCatCode) {
            this.merCatCode = merCatCode;
            return this;
        }

        public Builder setMerName(String merName) {
            this.merName = merName;
            return this;
        }

        public Builder setMerAbbr(String merAbbr) {
            this.merAbbr = merAbbr;
            return this;
        }

        public Builder setOrigQryId(String origQryId) {
            this.origQryId = origQryId;
            return this;
        }

        public Builder setSettleDate(String settleDate) {
            this.settleDate = settleDate;
            return this;
        }

        public Builder setFileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        public Builder setBussCode(String bussCode) {
            this.bussCode = bussCode;
            return this;
        }

        public Builder setBillQueryInfo(String billQueryInfo) {
            this.billQueryInfo = billQueryInfo;
            return this;
        }

        public Builder setQrNo(String qrNo) {
            this.qrNo = qrNo;
            return this;
        }

        public Builder setTermId(String termId) {
            this.termId = termId;
            return this;
        }

        public Builder setAccType(String accType) {
            this.accType = accType;
            return this;
        }

        public Builder setEncryptCertId(String encryptCertId) {
            this.encryptCertId = encryptCertId;
            return this;
        }

        public Builder setCustomerInfo(String customerInfo) {
            this.customerInfo = customerInfo;
            return this;
        }
    }
}

