/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.unionpay;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtil {
    private static final Logger GATE_LOG = LoggerFactory.getLogger((String)"ACP_SDK_LOG");
    private static final Logger GATE_LOG_ERROR = LoggerFactory.getLogger((String)"SDK_ERR_LOG");
    private static final Logger GATE_LOG_MESSAGE = LoggerFactory.getLogger((String)"SDK_MSG_LOG");
    static final String LOG_STRING_REQ_MSG_BEGIN = "============================== SDK REQ MSG BEGIN ==============================";
    static final String LOG_STRING_REQ_MSG_END = "==============================  SDK REQ MSG END  ==============================";
    static final String LOG_STRING_RSP_MSG_BEGIN = "============================== SDK RSP MSG BEGIN ==============================";
    static final String LOG_STRING_RSP_MSG_END = "==============================  SDK RSP MSG END  ==============================";

    public static void writeLog(String cont) {
        GATE_LOG.info(cont);
    }

    public static void writeErrorLog(String cont) {
        GATE_LOG_ERROR.error(cont);
    }

    public static void writeErrorLog(String cont, Throwable ex) {
        GATE_LOG_ERROR.error(cont, ex);
    }

    public static void writeMessage(String msg) {
        GATE_LOG_MESSAGE.info(msg);
    }

    public static void printRequestLog(Map<String, String> reqParam) {
        LogUtil.writeMessage(LOG_STRING_REQ_MSG_BEGIN);
        for (Map.Entry<String, String> en : reqParam.entrySet()) {
            LogUtil.writeMessage("[" + en.getKey() + "] = [" + en.getValue() + "]");
        }
        LogUtil.writeMessage(LOG_STRING_REQ_MSG_END);
    }

    public static void printResponseLog(String res) {
        LogUtil.writeMessage(LOG_STRING_RSP_MSG_BEGIN);
        LogUtil.writeMessage(res);
        LogUtil.writeMessage(LOG_STRING_RSP_MSG_END);
    }

    public static void debug(String cont) {
        if (GATE_LOG.isDebugEnabled()) {
            GATE_LOG.debug(cont);
        }
    }
}

