/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.unionpay;

import com.ijpay.unionpay.CertUtil;
import com.ijpay.unionpay.LogUtil;
import com.ijpay.unionpay.SDKUtil;
import com.ijpay.unionpay.SecureUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AcpService {
    public static Map<String, String> sign(Map<String, String> reqData, String encoding) {
        reqData = SDKUtil.filterBlank(reqData);
        SDKUtil.sign(reqData, encoding);
        return reqData;
    }

    public static Map<String, String> signByCertInfo(Map<String, String> reqData, String certPath, String certPwd, String encoding) {
        reqData = SDKUtil.filterBlank(reqData);
        SDKUtil.signByCertInfo(reqData, certPath, certPwd, encoding);
        return reqData;
    }

    public static Map<String, String> signBySecureKey(Map<String, String> reqData, String secureKey, String encoding) {
        reqData = SDKUtil.filterBlank(reqData);
        SDKUtil.signBySecureKey(reqData, secureKey, encoding);
        return reqData;
    }

    public static boolean validate(Map<String, String> rspData, String encoding) {
        return SDKUtil.validate(rspData, encoding);
    }

    public static boolean validateBySecureKey(Map<String, String> rspData, String secureKey, String encoding) {
        return SDKUtil.validateBySecureKey(rspData, secureKey, encoding);
    }

    public static String createAutoFormHtml(String reqUrl, Map<String, String> hiddenMap, String encoding) {
        StringBuffer sf = new StringBuffer();
        sf.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + encoding + "\"/></head><body>");
        sf.append("<form id = \"pay_form\" action=\"" + reqUrl + "\" method=\"post\">");
        if (null != hiddenMap && 0 != hiddenMap.size()) {
            Set<Map.Entry<String, String>> set = hiddenMap.entrySet();
            for (Map.Entry<String, String> ey : set) {
                String key = ey.getKey();
                String value = ey.getValue();
                sf.append("<input type=\"hidden\" name=\"" + key + "\" id=\"" + key + "\" value=\"" + value + "\"/>");
            }
        }
        sf.append("</form>");
        sf.append("</body>");
        sf.append("<script type=\"text/javascript\">");
        sf.append("document.all.pay_form.submit();");
        sf.append("</script>");
        sf.append("</html>");
        return sf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String enCodeFileContent(String filePath, String encoding) {
        String baseFileContent = "";
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                LogUtil.writeErrorLog(e.getMessage(), e);
            }
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            int fl = ((InputStream)in).available();
            if (null != in) {
                byte[] s = new byte[fl];
                ((InputStream)in).read(s, 0, fl);
                baseFileContent = new String(SecureUtil.base64Encode(SDKUtil.deflater(s)), encoding);
            }
        }
        catch (Exception e) {
            LogUtil.writeErrorLog(e.getMessage(), e);
        }
        finally {
            if (null != in) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    LogUtil.writeErrorLog(e.getMessage(), e);
                }
            }
        }
        return baseFileContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String deCodeFileContent(Map<String, String> resData, String fileDirectory, String encoding) {
        String filePath = null;
        String fileContent = resData.get("fileContent");
        if (null != fileContent && !"".equals(fileContent)) {
            FileOutputStream out = null;
            try {
                byte[] fileArray = SDKUtil.inflater(SecureUtil.base64Decode(fileContent.getBytes(encoding)));
                filePath = SDKUtil.isEmpty(resData.get("fileName")) ? fileDirectory + File.separator + resData.get("merId") + "_" + resData.get("batchNo") + "_" + resData.get("txnTime") + ".txt" : fileDirectory + File.separator + resData.get("fileName");
                File file = new File(filePath);
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                out = new FileOutputStream(file);
                out.write(fileArray, 0, fileArray.length);
                out.flush();
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.writeErrorLog(e.getMessage(), e);
            }
            catch (IOException e) {
                LogUtil.writeErrorLog(e.getMessage(), e);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return filePath;
    }

    public static String getFileContent(String fileContent, String encoding) {
        String fc = "";
        try {
            fc = new String(SDKUtil.inflater(SecureUtil.base64Decode(fileContent.getBytes())), encoding);
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog(e.getMessage(), e);
        }
        catch (IOException e) {
            LogUtil.writeErrorLog(e.getMessage(), e);
        }
        return fc;
    }

    public static String getCustomerInfo(Map<String, String> customerInfoMap, String accNo, String encoding) {
        if (customerInfoMap.isEmpty()) {
            return "{}";
        }
        StringBuffer sf = new StringBuffer("{");
        Iterator<String> it = customerInfoMap.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            String value = customerInfoMap.get(key);
            if ("pin".equals(key)) {
                if (null == accNo || "".equals(accNo.trim())) {
                    LogUtil.writeLog("\u9001\u4e86\u5bc6\u7801\uff08PIN\uff09\uff0c\u5fc5\u987b\u5728getCustomerInfo\u53c2\u6570\u4e2d\u4e0a\u4f20\u5361\u53f7");
                    throw new RuntimeException("\u52a0\u5bc6PIN\u6ca1\u9001\u5361\u53f7\u65e0\u6cd5\u540e\u7eed\u5904\u7406");
                }
                value = AcpService.encryptPin(accNo, value, encoding);
            }
            sf.append(key).append("=").append(value);
            if (!it.hasNext()) continue;
            sf.append("&");
        }
        String customerInfo = sf.append("}").toString();
        LogUtil.writeLog("\u7ec4\u88c5\u7684customerInfo\u660e\u6587\uff1a" + customerInfo);
        try {
            return new String(SecureUtil.base64Encode(sf.toString().getBytes(encoding)), encoding);
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog(e.getMessage(), e);
        }
        catch (IOException e) {
            LogUtil.writeErrorLog(e.getMessage(), e);
        }
        return customerInfo;
    }

    public static String getCustomerInfoWithEncrypt(Map<String, String> customerInfoMap, String accNo, String encoding) {
        if (customerInfoMap.isEmpty()) {
            return "{}";
        }
        StringBuffer sf = new StringBuffer("{");
        StringBuffer encryptedInfoSb = new StringBuffer("");
        for (String key : customerInfoMap.keySet()) {
            String value = customerInfoMap.get(key);
            if ("phoneNo".equals(key) || "cvn2".equals(key) || "expired".equals(key)) {
                encryptedInfoSb.append(key).append("=").append(value).append("&");
                continue;
            }
            if ("pin".equals(key)) {
                if (null == accNo || "".equals(accNo.trim())) {
                    LogUtil.writeLog("\u9001\u4e86\u5bc6\u7801\uff08PIN\uff09\uff0c\u5fc5\u987b\u5728getCustomerInfoWithEncrypt\u53c2\u6570\u4e2d\u4e0a\u4f20\u5361\u53f7");
                    throw new RuntimeException("\u52a0\u5bc6PIN\u6ca1\u9001\u5361\u53f7\u65e0\u6cd5\u540e\u7eed\u5904\u7406");
                }
                value = AcpService.encryptPin(accNo, value, encoding);
            }
            sf.append(key).append("=").append(value).append("&");
        }
        if (!"".equals(encryptedInfoSb.toString())) {
            encryptedInfoSb.setLength(encryptedInfoSb.length() - 1);
            LogUtil.writeLog("\u7ec4\u88c5\u7684customerInfo encryptedInfo\u660e\u6587\uff1a" + encryptedInfoSb.toString());
            sf.append("encryptedInfo").append("=").append(AcpService.encryptData(encryptedInfoSb.toString(), encoding));
        } else {
            sf.setLength(sf.length() - 1);
        }
        String customerInfo = sf.append("}").toString();
        LogUtil.writeLog("\u7ec4\u88c5\u7684customerInfo\u660e\u6587\uff1a" + customerInfo);
        try {
            return new String(SecureUtil.base64Encode(sf.toString().getBytes(encoding)), encoding);
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog(e.getMessage(), e);
        }
        catch (IOException e) {
            LogUtil.writeErrorLog(e.getMessage(), e);
        }
        return customerInfo;
    }

    public static Map<String, String> parseCustomerInfo(String customerInfo, String encoding) {
        Map<String, String> customerInfoMap = null;
        try {
            byte[] b = SecureUtil.base64Decode(customerInfo.getBytes(encoding));
            String customerInfoNoBase64 = new String(b, encoding);
            LogUtil.writeLog("\u89e3base64\u540e===>" + customerInfoNoBase64);
            customerInfoNoBase64 = customerInfoNoBase64.substring(1, customerInfoNoBase64.length() - 1);
            customerInfoMap = SDKUtil.parseQString(customerInfoNoBase64);
            if (customerInfoMap.containsKey("encryptedInfo")) {
                String encInfoStr = customerInfoMap.get("encryptedInfo");
                customerInfoMap.remove("encryptedInfo");
                String encryptedInfoStr = AcpService.decryptData(encInfoStr, encoding);
                Map<String, String> encryptedInfoMap = SDKUtil.parseQString(encryptedInfoStr);
                customerInfoMap.putAll(encryptedInfoMap);
            }
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog(e.getMessage(), e);
        }
        catch (IOException e) {
            LogUtil.writeErrorLog(e.getMessage(), e);
        }
        return customerInfoMap;
    }

    public static Map<String, String> parseCustomerInfo(String customerInfo, String certPath, String certPwd, String encoding) {
        Map<String, String> customerInfoMap = null;
        try {
            byte[] b = SecureUtil.base64Decode(customerInfo.getBytes(encoding));
            String customerInfoNoBase64 = new String(b, encoding);
            LogUtil.writeLog("\u89e3base64\u540e===>" + customerInfoNoBase64);
            customerInfoNoBase64 = customerInfoNoBase64.substring(1, customerInfoNoBase64.length() - 1);
            customerInfoMap = SDKUtil.parseQString(customerInfoNoBase64);
            if (customerInfoMap.containsKey("encryptedInfo")) {
                String encInfoStr = customerInfoMap.get("encryptedInfo");
                customerInfoMap.remove("encryptedInfo");
                String encryptedInfoStr = AcpService.decryptData(encInfoStr, certPath, certPwd, encoding);
                Map<String, String> encryptedInfoMap = SDKUtil.parseQString(encryptedInfoStr);
                customerInfoMap.putAll(encryptedInfoMap);
            }
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog(e.getMessage(), e);
        }
        catch (IOException e) {
            LogUtil.writeErrorLog(e.getMessage(), e);
        }
        return customerInfoMap;
    }

    public static String encryptPin(String accNo, String pin, String encoding) {
        return SecureUtil.encryptPin(accNo, pin, encoding, CertUtil.getEncryptCertPublicKey());
    }

    public static String encryptData(String data, String encoding) {
        return SecureUtil.encryptData(data, encoding, CertUtil.getEncryptCertPublicKey());
    }

    public static String decryptData(String base64EncryptedInfo, String encoding) {
        return SecureUtil.decryptData(base64EncryptedInfo, encoding, CertUtil.getSignCertPrivateKey());
    }

    public static String decryptData(String base64EncryptedInfo, String certPath, String certPwd, String encoding) {
        return SecureUtil.decryptData(base64EncryptedInfo, encoding, CertUtil.getSignCertPrivateKeyByStoreMap(certPath, certPwd));
    }

    public static String getEncryptCertId() {
        return CertUtil.getEncryptCertId();
    }

    public static String base64Encode(String rawStr, String encoding) throws IOException {
        byte[] rawByte = rawStr.getBytes(encoding);
        return new String(SecureUtil.base64Encode(rawByte), encoding);
    }

    public static String base64Decode(String base64Str, String encoding) throws IOException {
        byte[] rawByte = base64Str.getBytes(encoding);
        return new String(SecureUtil.base64Decode(rawByte), encoding);
    }

    public static String getCardTransData(Map<String, String> cardTransDataMap, Map<String, String> requestData, String encoding) {
        StringBuffer cardTransDataBuffer = new StringBuffer();
        if (cardTransDataMap.containsKey("track2Data")) {
            StringBuffer track2Buffer = new StringBuffer();
            track2Buffer.append(requestData.get("merId")).append("|").append(requestData.get("orderId")).append("|").append(requestData.get("txnTime")).append("|").append(requestData.get("txnAmt") == null ? Integer.valueOf(0) : (Serializable)((Object)requestData.get("txnAmt"))).append("|").append(cardTransDataMap.get("track2Data"));
            cardTransDataMap.put("track2Data", AcpService.encryptData(track2Buffer.toString(), encoding));
        }
        if (cardTransDataMap.containsKey("track3Data")) {
            StringBuffer track3Buffer = new StringBuffer();
            track3Buffer.append(requestData.get("merId")).append("|").append(requestData.get("orderId")).append("|").append(requestData.get("txnTime")).append("|").append(requestData.get("txnAmt") == null ? Integer.valueOf(0) : (Serializable)((Object)requestData.get("txnAmt"))).append("|").append(cardTransDataMap.get("track3Data"));
            cardTransDataMap.put("track3Data", AcpService.encryptData(track3Buffer.toString(), encoding));
        }
        return cardTransDataBuffer.append("{").append(SDKUtil.coverMap2String(cardTransDataMap)).append("}").toString();
    }

    public static int updateEncryptCert(Map<String, String> resData, String encoding) {
        return SDKUtil.getEncryptCert(resData, encoding);
    }

    public static int genLuHn(String number) {
        return SecureUtil.genLuHn(number);
    }
}

