/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.api;

import com.egzosn.pay.common.api.Callback;
import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.api.PayService;
import com.egzosn.pay.common.bean.RefundOrder;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.bean.TransferOrder;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.common.http.HttpRequestTemplate;
import com.egzosn.pay.common.util.sign.SignUtils;
import com.egzosn.pay.common.util.sign.encrypt.Base64;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public abstract class BasePayService
implements PayService {
    protected PayConfigStorage payConfigStorage;
    protected HttpRequestTemplate requestTemplate;
    protected int retrySleepMillis = 1000;
    protected int maxRetryTimes = 5;

    @Override
    public BasePayService setPayConfigStorage(PayConfigStorage payConfigStorage) {
        this.payConfigStorage = payConfigStorage;
        return this;
    }

    @Override
    public PayConfigStorage getPayConfigStorage() {
        return this.payConfigStorage;
    }

    @Override
    public HttpRequestTemplate getHttpRequestTemplate() {
        return this.requestTemplate;
    }

    @Override
    public BasePayService setRequestTemplateConfigStorage(HttpConfigStorage configStorage) {
        this.requestTemplate = new HttpRequestTemplate(configStorage);
        return this;
    }

    public BasePayService(PayConfigStorage payConfigStorage) {
        this(payConfigStorage, null);
    }

    public BasePayService(PayConfigStorage payConfigStorage, HttpConfigStorage configStorage) {
        this.setPayConfigStorage(payConfigStorage);
        this.setRequestTemplateConfigStorage(configStorage);
    }

    protected String authorizationString(String user, String password) {
        String base64ClientID = null;
        try {
            base64ClientID = Base64.encode(String.format("%s:%s", user, password).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return base64ClientID;
    }

    @Override
    public String createSign(String content, String characterEncoding) {
        return SignUtils.valueOf(this.payConfigStorage.getSignType()).createSign(content, this.payConfigStorage.getKeyPrivate(), characterEncoding);
    }

    @Override
    public String createSign(Map<String, Object> content, String characterEncoding) {
        return SignUtils.valueOf(this.payConfigStorage.getSignType()).sign(content, this.payConfigStorage.getKeyPrivate(), characterEncoding);
    }

    @Override
    public Map<String, Object> getParameter2Map(Map<String, String[]> parameterMap, InputStream is) {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        for (String name : parameterMap.keySet()) {
            String[] values = parameterMap.get(name);
            String valueStr = "";
            int len = values.length;
            for (int i = 0; i < len; ++i) {
                valueStr = valueStr + (i == len - 1 ? values[i] : values[i] + ",");
            }
            if (!valueStr.matches("\\w+")) {
                try {
                    if (valueStr.equals(new String(valueStr.getBytes("iso8859-1"), "iso8859-1"))) {
                        valueStr = new String(valueStr.getBytes("iso8859-1"), this.payConfigStorage.getInputCharset());
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            params.put(name, valueStr);
        }
        return params;
    }

    @Override
    public <T> T query(String tradeNo, String outTradeNo, Callback<T> callback) {
        return callback.perform(this.query(tradeNo, outTradeNo));
    }

    @Override
    public <T> T close(String tradeNo, String outTradeNo, Callback<T> callback) {
        return callback.perform(this.close(tradeNo, outTradeNo));
    }

    @Override
    @Deprecated
    public <T> T refund(String tradeNo, String outTradeNo, BigDecimal refundAmount, BigDecimal totalAmount, Callback<T> callback) {
        return callback.perform(this.refund(new RefundOrder(tradeNo, outTradeNo, refundAmount, totalAmount)));
    }

    @Override
    public <T> T refund(RefundOrder refundOrder, Callback<T> callback) {
        return callback.perform(this.refund(refundOrder));
    }

    @Override
    public <T> T refundquery(String tradeNo, String outTradeNo, Callback<T> callback) {
        return callback.perform(this.refundquery(tradeNo, outTradeNo));
    }

    @Override
    public <T> T refundquery(RefundOrder refundOrder, Callback<T> callback) {
        return callback.perform(this.refundquery(refundOrder));
    }

    @Override
    public <T> T downloadbill(Date billDate, String billType, Callback<T> callback) {
        return callback.perform(this.downloadbill(billDate, billType));
    }

    @Override
    public <T> T secondaryInterface(Object tradeNoOrBillDate, String outTradeNoBillType, TransactionType transactionType, Callback<T> callback) {
        return callback.perform(this.secondaryInterface(tradeNoOrBillDate, outTradeNoBillType, transactionType));
    }

    @Override
    public <T> T transfer(TransferOrder order, Callback<T> callback) {
        return callback.perform(this.transfer(order));
    }

    @Override
    public Map<String, Object> transfer(TransferOrder order) {
        return new HashMap<String, Object>(0);
    }

    @Override
    public Map<String, Object> transferQuery(String outNo, String tradeNo) {
        return new HashMap<String, Object>(0);
    }

    @Override
    public <T> T transferQuery(String outNo, String tradeNo, Callback<T> callback) {
        return callback.perform(this.transferQuery(outNo, tradeNo));
    }
}

