/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.parser;

import dm.jdbc.convert.J2DB;
import dm.jdbc.parser.LVal;
import dm.jdbc.parser.LVal$Type;
import dm.jdbc.parser.Lexer;
import dm.jdbc.parser.SQLProcessor$Parameter;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.StringUtil;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class SQLProcessor {
    public static List lex(String string) {
        Lexer lexer = new Lexer(new StringReader(string), false);
        int n2 = 0;
        LVal lVal = null;
        ArrayList<LVal> arrayList = new ArrayList<LVal>(32);
        while ((lVal = lexer.yylex()) != null) {
            lVal.position = n2++;
            arrayList.add(lVal);
        }
        return arrayList;
    }

    public static int getParameterCount(String string) {
        Lexer lexer = new Lexer(new StringReader(string), false);
        int n2 = 0;
        LVal lVal = null;
        ArrayList<LVal> arrayList = new ArrayList<LVal>(32);
        int n3 = 0;
        while ((lVal = lexer.yylex()) != null) {
            if (lVal.type == LVal$Type.NORMAL && (StringUtil.equals("?", lVal.value) || StringUtil.equals(":", lVal.value))) {
                ++n3;
            }
            lVal.position = n2++;
            arrayList.add(lVal);
        }
        return n3;
    }

    public static List lexSkipWhitespace(String string, int n2) {
        int n3 = n2;
        Lexer lexer = new Lexer(new StringReader(string), false);
        int n4 = 0;
        LVal lVal = null;
        ArrayList<LVal> arrayList = new ArrayList<LVal>(32);
        while ((lVal = lexer.yylex()) != null) {
            lVal.position = n4++;
            if (lVal.type == LVal$Type.WHITESPACE_OR_COMMENT) continue;
            arrayList.add(lVal);
            if (n2 > 0 && --n3 == 0) break;
        }
        return arrayList;
    }

    public static String escape(String string, String[] stringArray) {
        CharSequence charSequence;
        if ((stringArray == null || stringArray.length == 0) && string.indexOf("{") == -1) {
            return string;
        }
        HashMap hashMap = null;
        if (stringArray != null && stringArray.length > 0) {
            hashMap = new HashMap();
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                charSequence = stringArray2[n3];
                hashMap.put(((String)charSequence).toUpperCase(), null);
                ++n3;
            }
        }
        charSequence = new StringBuilder();
        Stack<Boolean> stack = new Stack<Boolean>();
        List list = SQLProcessor.lex(string);
        int n4 = 0;
        while (n4 < list.size()) {
            LVal lVal = (LVal)list.get(n4);
            if (lVal.type == LVal$Type.NORMAL) {
                if (StringUtil.equals(lVal.value, "{")) {
                    LVal lVal2;
                    LVal lVal3 = SQLProcessor.next(list, n4 + 1);
                    if (lVal3 == null || lVal3.type != LVal$Type.NORMAL) {
                        stack.push(false);
                        ((StringBuilder)charSequence).append(lVal.value);
                    } else if (StringUtil.equalsIgnoreCase(lVal3.value, "escape") || StringUtil.equalsIgnoreCase(lVal3.value, "call")) {
                        stack.push(true);
                    } else if (StringUtil.equalsIgnoreCase(lVal3.value, "oj")) {
                        stack.push(true);
                        lVal3.value = "";
                        lVal3.type = LVal$Type.WHITESPACE_OR_COMMENT;
                    } else if (StringUtil.equalsIgnoreCase(lVal3.value, "d")) {
                        stack.push(true);
                        lVal3.value = "date";
                    } else if (StringUtil.equalsIgnoreCase(lVal3.value, "t")) {
                        stack.push(true);
                        lVal3.value = "time";
                    } else if (StringUtil.equalsIgnoreCase(lVal3.value, "ts")) {
                        stack.push(true);
                        lVal3.value = "datetime";
                    } else if (StringUtil.equalsIgnoreCase(lVal3.value, "fn")) {
                        stack.push(true);
                        lVal3.value = "";
                        lVal3.type = LVal$Type.WHITESPACE_OR_COMMENT;
                        lVal2 = SQLProcessor.next(list, lVal3.position + 1);
                        if (lVal2 != null && lVal2.type == LVal$Type.NORMAL && StringUtil.equalsIgnoreCase(lVal2.value, "database")) {
                            lVal2.value = "cur_database";
                        }
                    } else if (StringUtil.equals(lVal3.value, "?")) {
                        lVal2 = SQLProcessor.next(list, lVal3.position + 1);
                        if (lVal2 != null && lVal2.type == LVal$Type.NORMAL && StringUtil.equalsIgnoreCase(lVal2.value, "=")) {
                            LVal lVal4 = SQLProcessor.next(list, lVal2.position + 1);
                            if (lVal4 != null && lVal4.type == LVal$Type.NORMAL && StringUtil.equalsIgnoreCase(lVal4.value, "call")) {
                                stack.push(true);
                                lVal4.value = "";
                                lVal4.type = LVal$Type.WHITESPACE_OR_COMMENT;
                            } else {
                                stack.push(false);
                                ((StringBuilder)charSequence).append(lVal.value);
                            }
                        } else {
                            stack.push(false);
                            ((StringBuilder)charSequence).append(lVal.value);
                        }
                    } else {
                        stack.push(false);
                        ((StringBuilder)charSequence).append(lVal.value);
                    }
                } else if (StringUtil.equals(lVal.value, "}")) {
                    if (stack.isEmpty() || !((Boolean)stack.pop()).booleanValue()) {
                        ((StringBuilder)charSequence).append(lVal.value);
                    }
                } else if (hashMap != null && hashMap.containsKey(lVal.value.toUpperCase())) {
                    ((StringBuilder)charSequence).append("\"" + StringUtil.processDoubleQuoteOfName(lVal.value.toUpperCase()) + "\"");
                } else {
                    ((StringBuilder)charSequence).append(lVal.value);
                }
            } else if (lVal.type == LVal$Type.STRING) {
                ((StringBuilder)charSequence).append("'" + StringUtil.processSingleQuoteOfName(lVal.value) + '\'');
            } else {
                ((StringBuilder)charSequence).append(lVal.value);
            }
            ++n4;
        }
        return ((StringBuilder)charSequence).toString();
    }

    private static LVal next(List list, int n2) {
        LVal lVal = null;
        int n3 = list.size();
        int n4 = n2;
        while (n4 < n3) {
            lVal = (LVal)list.get(n4);
            if (lVal.type != LVal$Type.WHITESPACE_OR_COMMENT) break;
            ++n4;
        }
        return lVal;
    }

    public static String execOpt(String string, List list, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        List list2 = SQLProcessor.lex(string);
        if (list2 == null || list2.size() == 0) {
            return string;
        }
        String string3 = ((LVal)list2.get((int)0)).value;
        if (!(string3.equalsIgnoreCase("INSERT") || string3.equalsIgnoreCase("SELECT") || string3.equalsIgnoreCase("UPDATE") || string3.equalsIgnoreCase("DELETE"))) {
            return string;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < list2.size()) {
            LVal lVal = (LVal)list2.get(n3);
            switch (lVal.type) {
                case NULL: {
                    stringBuilder.append("?");
                    list.add(new SQLProcessor$Parameter(null, 25, 0));
                    break;
                }
                case INT: {
                    stringBuilder.append("?");
                    Number number = new Long(lVal.value);
                    if ((Long)number <= Integer.MAX_VALUE && (Long)number >= Integer.MIN_VALUE) {
                        list.add(new SQLProcessor$Parameter(J2DB.toInt((Long)number), 7, 4));
                        break;
                    }
                    list.add(new SQLProcessor$Parameter(J2DB.toBigint((Long)number), 8, 8));
                    break;
                }
                case DOUBLE: {
                    stringBuilder.append("?");
                    Number number = new Double(lVal.value);
                    list.add(new SQLProcessor$Parameter(J2DB.toDouble((Double)number), 11, 8));
                    break;
                }
                case DECIMAL: {
                    stringBuilder.append("?");
                    list.add(new SQLProcessor$Parameter(J2DB.toDecimal(lVal.value, 0, 0), 9, 0));
                    break;
                }
                case STRING: {
                    if (lVal.value.length() > Short.MAX_VALUE) {
                        stringBuilder.append("'" + StringUtil.processSingleQuoteOfName(lVal.value) + "'");
                        break;
                    }
                    stringBuilder.append("?");
                    list.add(new SQLProcessor$Parameter(ByteUtil.fromString(lVal.value, string2), 2, 8188));
                    break;
                }
                case HEX_INT: {
                    stringBuilder.append(lVal.value);
                    break;
                }
                default: {
                    stringBuilder.append(lVal.value);
                }
            }
            if (n2 > 0) break;
            ++n3;
        }
        if (n2 > 0) {
            n3 = n2 + 1;
            while (n3 < list2.size()) {
                stringBuilder.append(((LVal)list2.get((int)n3)).value);
                ++n3;
            }
        }
        return stringBuilder.toString();
    }

    public static boolean hasConst(String string) {
        List list = SQLProcessor.lex(string);
        if (list == null || list.size() == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            LVal lVal = (LVal)list.get(n2);
            switch (lVal.type) {
                case INT: 
                case DOUBLE: 
                case DECIMAL: 
                case STRING: 
                case HEX_INT: 
                case NULL: {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        String string = "select * from test where 1 := :A";
        long l2 = System.currentTimeMillis();
        System.out.println(SQLProcessor.getParameterCount(string));
        System.out.println("time: " + (System.currentTimeMillis() - l2) + "ms");
    }
}

