/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.ArrayDescriptor;
import dm.jdbc.desc.Column;
import dm.jdbc.desc.TypeData;
import dm.jdbc.desc.TypeDescriptor;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArrayDataResultSet;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbStruct;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.util.StringUtil;
import java.sql.Array;
import java.sql.ResultSet;
import java.util.Map;

public class DmdbArray
extends TypeData
implements Array {
    public ArrayDescriptor m_arrDesc;
    public TypeData[] m_arrData;
    public Object m_objArray;
    public int m_itemCount;
    public int m_itemSize;
    public int m_objCount = 0;
    public int m_strCount = 0;
    public int[] m_objStrOffs = null;

    private void initData() {
        this.m_itemCount = 0;
        this.m_itemSize = 0;
        this.m_objCount = 0;
        this.m_strCount = 0;
        this.m_objStrOffs = null;
        this.m_dumyData = null;
        this.m_offset = 0;
        this.m_objArray = null;
    }

    public DmdbArray(TypeData[] typeDataArray, TypeDescriptor typeDescriptor) {
        super(null, null);
        this.m_arrDesc = new ArrayDescriptor(typeDescriptor);
        this.m_arrData = typeDataArray;
    }

    public DmdbArray(ArrayDescriptor arrayDescriptor, DmdbConnection dmdbConnection, Object[] objectArray) {
        super(null, null);
        if (arrayDescriptor == null) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwException(new String[0]);
            return;
        }
        dmdbConnection.checkClosed();
        this.initData();
        this.m_arrDesc = arrayDescriptor;
        if (objectArray == null) {
            this.m_arrData = new TypeData[0];
        } else {
            if (arrayDescriptor.getMDesc() == null || arrayDescriptor.getMDesc().getDType() == 122 && objectArray.length > arrayDescriptor.getMDesc().getStaticArrayLength()) {
                DBError.ECJDBC_INVALID_ARRAY_LEN.throwException(new String[0]);
            }
            this.m_arrData = TypeData.toArray(objectArray, this.m_arrDesc.getMDesc());
        }
        this.m_itemCount = this.m_arrData.length;
    }

    private void checkIndex(long l2) {
        if (l2 < 1L || l2 > (long)this.m_arrData.length) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwException(new String[0]);
        }
    }

    private void checkIndexAndCount(long l2, int n2) {
        this.checkIndex(l2);
        if (n2 <= 0 || l2 - 1L + (long)n2 > (long)this.m_arrData.length) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwException(new String[0]);
        }
    }

    @Override
    public String getBaseTypeName() {
        return this.m_arrDesc.m_typeDesc.getFulName();
    }

    @Override
    public int getBaseType() {
        return DmdbType.d2jType(this.m_arrDesc.getItemDesc().column, this.m_arrDesc.getItemDesc().m_conn);
    }

    @Override
    public Object getArray() {
        if (this.m_arrData == null || this.m_arrData.length <= 0) {
            return null;
        }
        return this.toJavaArray(this, this.m_arrData.length, this.m_arrDesc.getItemDesc().getDType());
    }

    public Object getArray(Map map) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public Object getArray(long l2, int n2) {
        this.checkIndexAndCount(l2, n2);
        return this.toJavaArray(this, l2, n2, this.m_arrDesc.getItemDesc().getDType());
    }

    public Object getArray(long l2, int n2, Map map) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    public int[] getIntArray() {
        return (int[])this.toNumericArray(this, 1L, this.m_itemCount, 2);
    }

    public int[] getIntArray(long l2, int n2) {
        this.checkIndexAndCount(l2, n2);
        return (int[])this.toNumericArray(this, l2, n2, 2);
    }

    public short[] getShortArray() {
        return (short[])this.toNumericArray(this, 1L, this.m_itemCount, 1);
    }

    public short[] getShortArray(long l2, int n2) {
        this.checkIndexAndCount(l2, n2);
        return (short[])this.toNumericArray(this, l2, n2, 1);
    }

    public long[] getLongArray() {
        return (long[])this.toNumericArray(this, 1L, this.m_itemCount, 3);
    }

    public long[] getLongArray(long l2, int n2) {
        this.checkIndexAndCount(l2, n2);
        return (long[])this.toNumericArray(this, l2, n2, 3);
    }

    public float[] getFloatArray() {
        return (float[])this.toNumericArray(this, 1L, this.m_itemCount, 4);
    }

    public float[] getFloatArray(long l2, int n2) {
        this.checkIndexAndCount(l2, n2);
        return (float[])this.toNumericArray(this, l2, n2, 4);
    }

    public double[] getDoubleArray() {
        return (double[])this.toNumericArray(this, 1L, this.m_itemCount, 5);
    }

    public double[] getDoubleArray(long l2, int n2) {
        this.checkIndexAndCount(l2, n2);
        return (double[])this.toNumericArray(this, l2, n2, 5);
    }

    @Override
    public ResultSet getResultSet() {
        return new DmdbArrayDataResultSet(this);
    }

    public ResultSet getResultSet(Map map) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public ResultSet getResultSet(long l2, int n2) {
        this.checkIndexAndCount(l2, n2);
        return new DmdbArrayDataResultSet(this, l2, n2);
    }

    public ResultSet getResultSet(long l2, int n2, Map map) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwException(new String[0]);
        return null;
    }

    @Override
    public void free() {
        this.m_arrData = null;
        this.m_arrDesc = null;
        this.initData();
    }

    public TypeData getData(long l2, int n2, Map map) {
        this.checkIndex(l2);
        TypeData typeData = this.m_arrData[(int)(l2 - 1L)];
        if (typeData.m_dumyData instanceof DmdbStruct) {
            return ((DmdbStruct)typeData.m_dumyData).getAttrValue(n2);
        }
        return typeData;
    }

    public Column getDataDesc(long l2, int n2) {
        this.checkIndex(l2);
        Column column = new Column();
        TypeDescriptor typeDescriptor = this.m_arrDesc.getItemDesc();
        if (typeDescriptor.getDType() == 121 || typeDescriptor.getDType() == 119) {
            TypeDescriptor[] typeDescriptorArray = typeDescriptor.m_fieldsObj;
            if (n2 < 1 || n2 > typeDescriptorArray.length) {
                DBError.ECJDBC_INVALID_SEQUENCE_NUMBER.throwException(new String[0]);
            }
            column.typeDescriptor = typeDescriptor = typeDescriptorArray[n2 - 1];
        }
        column.type = typeDescriptor.getDType();
        column.prec = typeDescriptor.getPrec();
        column.scale = typeDescriptor.getScale();
        return column;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append(this.getBaseTypeName()).append("(");
            int n2 = 0;
            while (n2 < this.m_arrData.length) {
                Object object = this.m_arrData[n2].m_dumyData;
                if (object instanceof byte[]) {
                    object = "0x" + StringUtil.bytesToHexString((byte[])object);
                }
                if (n2 != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object);
                ++n2;
            }
            stringBuilder.append(")");
        }
        catch (Exception exception) {}
        return stringBuilder.toString();
    }
}

